/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest_client;

import co.elastic.clients.transport.endpoints.BinaryResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;

class HttpClientBinaryResponse
implements BinaryResponse {
    private final HttpEntity entity;
    private boolean consumed = false;

    HttpClientBinaryResponse(HttpEntity entity) {
        this.entity = entity;
    }

    @Override
    public String contentType() {
        Header h = this.entity.getContentType();
        return h == null ? "application/octet-stream" : h.getValue();
    }

    @Override
    public long contentLength() {
        long len = this.entity.getContentLength();
        return len < 0L ? -1L : this.entity.getContentLength();
    }

    @Override
    public InputStream content() throws IOException {
        if (this.consumed) {
            throw new IllegalStateException("Response content has already been consumed");
        }
        this.consumed = true;
        return this.entity.getContent();
    }

    @Override
    public void close() throws IOException {
        this.consumed = true;
        EntityUtils.consume((HttpEntity)this.entity);
    }
}

