/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.register.scan;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.client.job.core.IJobExecutor;
import com.aizuda.snailjob.client.job.core.Scanner;
import com.aizuda.snailjob.client.job.core.annotation.JobExecutor;
import com.aizuda.snailjob.client.job.core.cache.JobExecutorInfoCache;
import com.aizuda.snailjob.client.job.core.dto.JobArgs;
import com.aizuda.snailjob.client.job.core.dto.JobExecutorInfo;
import com.aizuda.snailjob.common.log.SnailJobLog;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class JobExecutorScanner
implements Scanner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(JobExecutorScanner.class);
    public ApplicationContext applicationContext;

    @Override
    public List<JobExecutorInfo> doScan() {
        return this.scanJobExecutor();
    }

    private List<JobExecutorInfo> scanJobExecutor() {
        String[] beanDefinitionNames;
        ArrayList<JobExecutorInfo> jobExecutorInfoList = new ArrayList<JobExecutorInfo>();
        for (String beanDefinitionName : beanDefinitionNames = this.applicationContext.getBeanNamesForType(Object.class, false, true)) {
            String executorName;
            JobExecutor jobExecutor;
            Object bean = this.applicationContext.getBean(beanDefinitionName);
            Map annotatedMethods = null;
            try {
                annotatedMethods = MethodIntrospector.selectMethods(bean.getClass(), method -> (JobExecutor)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, JobExecutor.class));
            }
            catch (Throwable ex) {
                SnailJobLog.LOCAL.error("{} JobExecutor\u52a0\u8f7d\u5f02\u5e38\uff1a{}", new Object[]{beanDefinitionName, ex});
            }
            Class executorNotProxy = AopProxyUtils.ultimateTargetClass((Object)bean);
            String executorClassName = executorNotProxy.getName();
            if (IJobExecutor.class.isAssignableFrom(bean.getClass()) && !JobExecutorInfoCache.isExisted(executorClassName)) {
                jobExecutorInfoList.add(new JobExecutorInfo(executorClassName, ReflectionUtils.findMethod(bean.getClass(), (String)"jobExecute"), bean));
            }
            if (Objects.nonNull(jobExecutor = bean.getClass().getAnnotation(JobExecutor.class)) && !JobExecutorInfoCache.isExisted(executorName = jobExecutor.name())) {
                Method method2 = ReflectionUtils.findMethod(bean.getClass(), (String)jobExecutor.method(), (Class[])new Class[]{JobArgs.class});
                if (method2 == null) {
                    method2 = ReflectionUtils.findMethod(bean.getClass(), (String)jobExecutor.method());
                }
                JobExecutorInfo jobExecutorInfo = new JobExecutorInfo(executorName, method2, bean);
                jobExecutorInfoList.add(jobExecutorInfo);
            }
            if (CollUtil.isEmpty((Map)annotatedMethods)) continue;
            for (Map.Entry methodEntry : annotatedMethods.entrySet()) {
                Method executeMethod = (Method)methodEntry.getKey();
                jobExecutor = (JobExecutor)methodEntry.getValue();
                if (JobExecutorInfoCache.isExisted(jobExecutor.name())) continue;
                JobExecutorInfo jobExecutorInfo = new JobExecutorInfo(jobExecutor.name(), executeMethod, bean);
                jobExecutorInfoList.add(jobExecutorInfo);
            }
        }
        return jobExecutorInfoList;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

