/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.memory.jdbc;

import com.alibaba.cloud.ai.memory.jdbc.JdbcChatMemoryRepository;
import org.springframework.jdbc.core.JdbcTemplate;

public class MysqlChatMemoryRepository
extends JdbcChatMemoryRepository {
    private static final String MYSQL_QUERY_ADD = "INSERT INTO ai_chat_memory (conversation_id, content, type, timestamp) VALUES (?, ?, ?, ?)";
    private static final String MYSQL_QUERY_GET = "SELECT content, type FROM ai_chat_memory WHERE conversation_id = ? ORDER BY timestamp";

    private MysqlChatMemoryRepository(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate);
    }

    public static MysqlBuilder mysqlBuilder() {
        return new MysqlBuilder();
    }

    @Override
    protected String hasTableSql(String tableName) {
        return String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = '%s'", tableName);
    }

    @Override
    protected String createTableSql(String tableName) {
        return String.format("CREATE TABLE %s (id BIGINT AUTO_INCREMENT PRIMARY KEY, conversation_id VARCHAR(256) NOT NULL, content LONGTEXT NOT NULL, type VARCHAR(100) NOT NULL, timestamp TIMESTAMP NOT NULL, CONSTRAINT chk_message_type CHECK (type IN ('USER', 'ASSISTANT', 'SYSTEM', 'TOOL')))", tableName);
    }

    @Override
    protected String getAddSql() {
        return MYSQL_QUERY_ADD;
    }

    @Override
    protected String getGetSql() {
        return MYSQL_QUERY_GET;
    }

    public static class MysqlBuilder {
        private JdbcTemplate jdbcTemplate;

        public MysqlBuilder jdbcTemplate(JdbcTemplate jdbcTemplate) {
            this.jdbcTemplate = jdbcTemplate;
            return this;
        }

        public MysqlChatMemoryRepository build() {
            return new MysqlChatMemoryRepository(this.jdbcTemplate);
        }
    }
}

