/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.tts;

import com.alibaba.dashscope.audio.tts.SpeechSynthesisAudioFormat;
import com.alibaba.dashscope.audio.tts.SpeechSynthesisTextType;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class SpeechSynthesisParam
extends HalfDuplexServiceParam {
    @NonNull
    private String text;
    private SpeechSynthesisTextType textType;
    private SpeechSynthesisAudioFormat format;
    private int sampleRate;
    private int volume;
    private float rate;
    private float pitch;
    private boolean enableWordTimestamp;
    private boolean enablePhonemeTimestamp;

    @Override
    public JsonObject getHttpBody() {
        throw new UnsupportedOperationException("Not support http");
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("text_type", this.getTextType().getValue());
        params.put("format", this.getFormat().getValue());
        params.put("sample_rate", this.getSampleRate());
        params.put("volume", this.getVolume());
        params.put("rate", Float.valueOf(this.getRate()));
        params.put("pitch", Float.valueOf(this.getPitch()));
        params.put("word_timestamp_enabled", this.isEnableWordTimestamp());
        params.put("phoneme_timestamp_enabled", this.isEnablePhonemeTimestamp());
        params.putAll(this.parameters);
        return params;
    }

    @Override
    public Object getInput() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("text", this.getText());
        return jsonObject;
    }

    @Override
    public ByteBuffer getBinaryData() {
        return null;
    }

    @Override
    public void validate() throws InputRequiredException {
    }

    private static SpeechSynthesisTextType $default$textType() {
        return SpeechSynthesisTextType.PLAIN_TEXT;
    }

    private static SpeechSynthesisAudioFormat $default$format() {
        return SpeechSynthesisAudioFormat.WAV;
    }

    private static int $default$sampleRate() {
        return 16000;
    }

    private static int $default$volume() {
        return 50;
    }

    private static float $default$rate() {
        return 1.0f;
    }

    private static float $default$pitch() {
        return 1.0f;
    }

    private static boolean $default$enableWordTimestamp() {
        return false;
    }

    private static boolean $default$enablePhonemeTimestamp() {
        return false;
    }

    protected SpeechSynthesisParam(SpeechSynthesisParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        this.text = ((SpeechSynthesisParamBuilder)b).text;
        if (this.text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.textType = ((SpeechSynthesisParamBuilder)b).textType$set ? ((SpeechSynthesisParamBuilder)b).textType$value : SpeechSynthesisParam.$default$textType();
        this.format = ((SpeechSynthesisParamBuilder)b).format$set ? ((SpeechSynthesisParamBuilder)b).format$value : SpeechSynthesisParam.$default$format();
        this.sampleRate = ((SpeechSynthesisParamBuilder)b).sampleRate$set ? ((SpeechSynthesisParamBuilder)b).sampleRate$value : SpeechSynthesisParam.$default$sampleRate();
        this.volume = ((SpeechSynthesisParamBuilder)b).volume$set ? ((SpeechSynthesisParamBuilder)b).volume$value : SpeechSynthesisParam.$default$volume();
        this.rate = ((SpeechSynthesisParamBuilder)b).rate$set ? ((SpeechSynthesisParamBuilder)b).rate$value : SpeechSynthesisParam.$default$rate();
        this.pitch = ((SpeechSynthesisParamBuilder)b).pitch$set ? ((SpeechSynthesisParamBuilder)b).pitch$value : SpeechSynthesisParam.$default$pitch();
        this.enableWordTimestamp = ((SpeechSynthesisParamBuilder)b).enableWordTimestamp$set ? ((SpeechSynthesisParamBuilder)b).enableWordTimestamp$value : SpeechSynthesisParam.$default$enableWordTimestamp();
        this.enablePhonemeTimestamp = ((SpeechSynthesisParamBuilder)b).enablePhonemeTimestamp$set ? ((SpeechSynthesisParamBuilder)b).enablePhonemeTimestamp$value : SpeechSynthesisParam.$default$enablePhonemeTimestamp();
    }

    public static SpeechSynthesisParamBuilder<?, ?> builder() {
        return new SpeechSynthesisParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpeechSynthesisParam)) {
            return false;
        }
        SpeechSynthesisParam other = (SpeechSynthesisParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSampleRate() != other.getSampleRate()) {
            return false;
        }
        if (this.getVolume() != other.getVolume()) {
            return false;
        }
        if (Float.compare(this.getRate(), other.getRate()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        if (this.isEnableWordTimestamp() != other.isEnableWordTimestamp()) {
            return false;
        }
        if (this.isEnablePhonemeTimestamp() != other.isEnablePhonemeTimestamp()) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        SpeechSynthesisTextType this$textType = this.getTextType();
        SpeechSynthesisTextType other$textType = other.getTextType();
        if (this$textType == null ? other$textType != null : !((Object)((Object)this$textType)).equals((Object)other$textType)) {
            return false;
        }
        SpeechSynthesisAudioFormat this$format = this.getFormat();
        SpeechSynthesisAudioFormat other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !((Object)((Object)this$format)).equals((Object)other$format));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpeechSynthesisParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getSampleRate();
        result = result * 59 + this.getVolume();
        result = result * 59 + Float.floatToIntBits(this.getRate());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        result = result * 59 + (this.isEnableWordTimestamp() ? 79 : 97);
        result = result * 59 + (this.isEnablePhonemeTimestamp() ? 79 : 97);
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        SpeechSynthesisTextType $textType = this.getTextType();
        result = result * 59 + ($textType == null ? 43 : ((Object)((Object)$textType)).hashCode());
        SpeechSynthesisAudioFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)((Object)$format)).hashCode());
        return result;
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public SpeechSynthesisTextType getTextType() {
        return this.textType;
    }

    public SpeechSynthesisAudioFormat getFormat() {
        return this.format;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getVolume() {
        return this.volume;
    }

    public float getRate() {
        return this.rate;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isEnableWordTimestamp() {
        return this.enableWordTimestamp;
    }

    public boolean isEnablePhonemeTimestamp() {
        return this.enablePhonemeTimestamp;
    }

    public void setText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    public void setTextType(SpeechSynthesisTextType textType) {
        this.textType = textType;
    }

    public void setFormat(SpeechSynthesisAudioFormat format) {
        this.format = format;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setEnableWordTimestamp(boolean enableWordTimestamp) {
        this.enableWordTimestamp = enableWordTimestamp;
    }

    public void setEnablePhonemeTimestamp(boolean enablePhonemeTimestamp) {
        this.enablePhonemeTimestamp = enablePhonemeTimestamp;
    }

    @Override
    public String toString() {
        return "SpeechSynthesisParam(text=" + this.getText() + ", textType=" + (Object)((Object)this.getTextType()) + ", format=" + (Object)((Object)this.getFormat()) + ", sampleRate=" + this.getSampleRate() + ", volume=" + this.getVolume() + ", rate=" + this.getRate() + ", pitch=" + this.getPitch() + ", enableWordTimestamp=" + this.isEnableWordTimestamp() + ", enablePhonemeTimestamp=" + this.isEnablePhonemeTimestamp() + ")";
    }

    private static final class SpeechSynthesisParamBuilderImpl
    extends SpeechSynthesisParamBuilder<SpeechSynthesisParam, SpeechSynthesisParamBuilderImpl> {
        private SpeechSynthesisParamBuilderImpl() {
        }

        @Override
        protected SpeechSynthesisParamBuilderImpl self() {
            return this;
        }

        @Override
        public SpeechSynthesisParam build() {
            return new SpeechSynthesisParam(this);
        }
    }

    public static abstract class SpeechSynthesisParamBuilder<C extends SpeechSynthesisParam, B extends SpeechSynthesisParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private String text;
        private boolean textType$set;
        private SpeechSynthesisTextType textType$value;
        private boolean format$set;
        private SpeechSynthesisAudioFormat format$value;
        private boolean sampleRate$set;
        private int sampleRate$value;
        private boolean volume$set;
        private int volume$value;
        private boolean rate$set;
        private float rate$value;
        private boolean pitch$set;
        private float pitch$value;
        private boolean enableWordTimestamp$set;
        private boolean enableWordTimestamp$value;
        private boolean enablePhonemeTimestamp$set;
        private boolean enablePhonemeTimestamp$value;

        public B text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return (B)this.self();
        }

        public B textType(SpeechSynthesisTextType textType) {
            this.textType$value = textType;
            this.textType$set = true;
            return (B)this.self();
        }

        public B format(SpeechSynthesisAudioFormat format) {
            this.format$value = format;
            this.format$set = true;
            return (B)this.self();
        }

        public B sampleRate(int sampleRate) {
            this.sampleRate$value = sampleRate;
            this.sampleRate$set = true;
            return (B)this.self();
        }

        public B volume(int volume) {
            this.volume$value = volume;
            this.volume$set = true;
            return (B)this.self();
        }

        public B rate(float rate) {
            this.rate$value = rate;
            this.rate$set = true;
            return (B)this.self();
        }

        public B pitch(float pitch) {
            this.pitch$value = pitch;
            this.pitch$set = true;
            return (B)this.self();
        }

        public B enableWordTimestamp(boolean enableWordTimestamp) {
            this.enableWordTimestamp$value = enableWordTimestamp;
            this.enableWordTimestamp$set = true;
            return (B)this.self();
        }

        public B enablePhonemeTimestamp(boolean enablePhonemeTimestamp) {
            this.enablePhonemeTimestamp$value = enablePhonemeTimestamp;
            this.enablePhonemeTimestamp$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SpeechSynthesisParam.SpeechSynthesisParamBuilder(super=" + super.toString() + ", text=" + this.text + ", textType$value=" + (Object)((Object)this.textType$value) + ", format$value=" + (Object)((Object)this.format$value) + ", sampleRate$value=" + this.sampleRate$value + ", volume$value=" + this.volume$value + ", rate$value=" + this.rate$value + ", pitch$value=" + this.pitch$value + ", enableWordTimestamp$value=" + this.enableWordTimestamp$value + ", enablePhonemeTimestamp$value=" + this.enablePhonemeTimestamp$value + ")";
        }
    }
}

