/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import okhttp3.Authenticator;

public final class ConnectionOptions {
    private static final String PROXY_HOST_ENV = "DASHSCOPE_PROXY_HOST";
    private static final String PROXY_PORT_ENV = "DASHSCOPE_PROXY_PORT";
    private static final Integer defaultProxyPort = 443;
    private String proxyHost;
    private Integer proxyPort;
    private Authenticator proxyAuthenticator;
    private static final String WRITE_TIMEOUT_ENV = "DASHSCOPE_WRITE_TIMEOUT";
    private static final String READ_TIMEOUT_ENV = "DASHSCOPE_READ_TIMEOUT";
    private static final String CONNECTION_TIMEOUT_ENV = "DASHSCOPE_CONNECTION_TIMEOUT";
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(120L);
    private static final Duration DEFAULT_WRITE_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(300L);
    private Duration connectTimeout;
    private Duration writeTimeout;
    private Duration readTimeout;

    public Duration getConnectTimeout() {
        return this.getDuration(this.connectTimeout, DEFAULT_CONNECT_TIMEOUT, CONNECTION_TIMEOUT_ENV);
    }

    public Duration getWriteTimeout() {
        return this.getDuration(this.writeTimeout, DEFAULT_WRITE_TIMEOUT, WRITE_TIMEOUT_ENV);
    }

    public Duration getReadTimeout() {
        return this.getDuration(this.readTimeout, DEFAULT_READ_TIMEOUT, READ_TIMEOUT_ENV);
    }

    private Duration getDuration(Duration target, Duration defaultValue, String env) {
        if (target == null) {
            try {
                long dur = Integer.parseInt(System.getenv(env));
                return Duration.ofSeconds(dur);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return target;
    }

    public String getProxyHost() {
        if (this.proxyHost != null) {
            return this.proxyHost;
        }
        String envHost = System.getenv(PROXY_HOST_ENV);
        return envHost;
    }

    public Integer getProxyPort() {
        if (this.proxyPort != null) {
            return this.proxyPort;
        }
        String envPort = System.getenv(PROXY_PORT_ENV);
        if (envPort == null) {
            return defaultProxyPort;
        }
        return Integer.parseInt(envPort);
    }

    public Proxy getProxy() {
        String host = this.getProxyHost();
        if (host != null) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, (int)this.getProxyPort()));
        }
        return null;
    }

    protected ConnectionOptions(ConnectionOptionsBuilder<?, ?> b) {
        this.proxyHost = ((ConnectionOptionsBuilder)b).proxyHost;
        this.proxyPort = ((ConnectionOptionsBuilder)b).proxyPort;
        this.proxyAuthenticator = ((ConnectionOptionsBuilder)b).proxyAuthenticator;
        this.connectTimeout = ((ConnectionOptionsBuilder)b).connectTimeout;
        this.writeTimeout = ((ConnectionOptionsBuilder)b).writeTimeout;
        this.readTimeout = ((ConnectionOptionsBuilder)b).readTimeout;
    }

    public static ConnectionOptionsBuilder<?, ?> builder() {
        return new ConnectionOptionsBuilderImpl();
    }

    public Authenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyAuthenticator(Authenticator proxyAuthenticator) {
        this.proxyAuthenticator = proxyAuthenticator;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionOptions)) {
            return false;
        }
        ConnectionOptions other = (ConnectionOptions)o;
        Integer this$proxyPort = this.getProxyPort();
        Integer other$proxyPort = other.getProxyPort();
        if (this$proxyPort == null ? other$proxyPort != null : !((Object)this$proxyPort).equals(other$proxyPort)) {
            return false;
        }
        String this$proxyHost = this.getProxyHost();
        String other$proxyHost = other.getProxyHost();
        if (this$proxyHost == null ? other$proxyHost != null : !this$proxyHost.equals(other$proxyHost)) {
            return false;
        }
        Authenticator this$proxyAuthenticator = this.getProxyAuthenticator();
        Authenticator other$proxyAuthenticator = other.getProxyAuthenticator();
        if (this$proxyAuthenticator == null ? other$proxyAuthenticator != null : !this$proxyAuthenticator.equals(other$proxyAuthenticator)) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$writeTimeout = this.getWriteTimeout();
        Duration other$writeTimeout = other.getWriteTimeout();
        if (this$writeTimeout == null ? other$writeTimeout != null : !((Object)this$writeTimeout).equals(other$writeTimeout)) {
            return false;
        }
        Duration this$readTimeout = this.getReadTimeout();
        Duration other$readTimeout = other.getReadTimeout();
        return !(this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $proxyPort = this.getProxyPort();
        result = result * 59 + ($proxyPort == null ? 43 : ((Object)$proxyPort).hashCode());
        String $proxyHost = this.getProxyHost();
        result = result * 59 + ($proxyHost == null ? 43 : $proxyHost.hashCode());
        Authenticator $proxyAuthenticator = this.getProxyAuthenticator();
        result = result * 59 + ($proxyAuthenticator == null ? 43 : $proxyAuthenticator.hashCode());
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $writeTimeout = this.getWriteTimeout();
        result = result * 59 + ($writeTimeout == null ? 43 : ((Object)$writeTimeout).hashCode());
        Duration $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        return result;
    }

    public String toString() {
        return "ConnectionOptions(proxyHost=" + this.getProxyHost() + ", proxyPort=" + this.getProxyPort() + ", proxyAuthenticator=" + this.getProxyAuthenticator() + ", connectTimeout=" + this.getConnectTimeout() + ", writeTimeout=" + this.getWriteTimeout() + ", readTimeout=" + this.getReadTimeout() + ")";
    }

    private static final class ConnectionOptionsBuilderImpl
    extends ConnectionOptionsBuilder<ConnectionOptions, ConnectionOptionsBuilderImpl> {
        private ConnectionOptionsBuilderImpl() {
        }

        @Override
        protected ConnectionOptionsBuilderImpl self() {
            return this;
        }

        @Override
        public ConnectionOptions build() {
            return new ConnectionOptions(this);
        }
    }

    public static abstract class ConnectionOptionsBuilder<C extends ConnectionOptions, B extends ConnectionOptionsBuilder<C, B>> {
        private String proxyHost;
        private Integer proxyPort;
        private Authenticator proxyAuthenticator;
        private Duration connectTimeout;
        private Duration writeTimeout;
        private Duration readTimeout;

        public B proxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this.self();
        }

        public B proxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
            return this.self();
        }

        public B proxyAuthenticator(Authenticator proxyAuthenticator) {
            this.proxyAuthenticator = proxyAuthenticator;
            return this.self();
        }

        public B connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this.self();
        }

        public B writeTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this.self();
        }

        public B readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "ConnectionOptions.ConnectionOptionsBuilder(proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyAuthenticator=" + this.proxyAuthenticator + ", connectTimeout=" + this.connectTimeout + ", writeTimeout=" + this.writeTimeout + ", readTimeout=" + this.readTimeout + ")";
        }
    }
}

