/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.completion;

import com.alibaba.dashscope.aigc.completion.ChatCompletion;
import com.alibaba.dashscope.aigc.completion.ChatCompletionChunk;
import com.alibaba.dashscope.aigc.completion.ChatCompletionParam;
import com.alibaba.dashscope.api.GeneralApi;
import com.alibaba.dashscope.base.HalfDuplexParamBase;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.GeneralServiceOption;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import io.reactivex.Flowable;

public final class ChatCompletions {
    private final GeneralApi<HalfDuplexParamBase> api;
    private final GeneralServiceOption serviceOption = this.defaultServiceOption();

    private GeneralServiceOption defaultServiceOption() {
        return ((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)((GeneralServiceOption.GeneralServiceOptionBuilder)GeneralServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).streamingMode(StreamingMode.OUT)).path("chat/completions")).build();
    }

    public ChatCompletions() {
        this.api = new GeneralApi();
    }

    public ChatCompletions(String baseUrl, ConnectionOptions connectionOptions) {
        this.serviceOption.setBaseHttpUrl(baseUrl);
        this.api = new GeneralApi(connectionOptions);
    }

    public ChatCompletion call(ChatCompletionParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        DashScopeResult result = this.api.call(param, this.serviceOption);
        return ChatCompletion.fromDashScopeResult(result);
    }

    public void call(ChatCompletionParam param, final ResultCallback<ChatCompletion> callback) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        this.api.call(param, this.serviceOption, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult message) {
                callback.onEvent(ChatCompletion.fromDashScopeResult(message));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public Flowable<ChatCompletionChunk> streamCall(ChatCompletionParam param) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        return this.api.streamCall(param, this.serviceOption).map(item -> ChatCompletionChunk.fromDashScopeResult(item));
    }

    public void streamCall(ChatCompletionParam param, final ResultCallback<ChatCompletionChunk> callback) throws ApiException, NoApiKeyException, InputRequiredException {
        param.validate();
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        this.api.streamCall(param, this.serviceOption, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult msg) {
                callback.onEvent(ChatCompletionChunk.fromDashScopeResult(msg));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }
}

