/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.translation;

import com.alibaba.dashscope.base.FullDuplexServiceParam;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.reactivex.Flowable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class TranslationRecognizerParam
extends FullDuplexServiceParam {
    private boolean disfluencyRemovalEnabled;
    @NonNull
    private Integer sampleRate;
    @NonNull
    private String format;
    private String phraseId;
    private String vocabularyId;
    private boolean transcriptionEnabled;
    private String sourceLanguage;
    private boolean translationEnabled;
    private String[] translationLanguages;
    private boolean semanticPunctationEnabled;
    private Integer maxEndSilence;

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("format", this.format);
        params.put("sample_rate", this.sampleRate);
        params.put("disfluency_removal_enabled", this.disfluencyRemovalEnabled);
        params.put("transcription_enabled", this.transcriptionEnabled);
        if (this.sourceLanguage != null) {
            params.put("source_language", this.sourceLanguage);
        }
        params.put("translation_enabled", this.translationEnabled);
        if (this.translationEnabled && this.translationLanguages != null && this.translationLanguages.length > 0) {
            params.put("translation_target_languages", this.translationLanguages);
        }
        params.put("semantic_punctuation_enabled", this.semanticPunctationEnabled);
        if (this.vocabularyId != null) {
            params.put("vocabulary_id", this.vocabularyId);
        }
        if (this.maxEndSilence != null) {
            params.put("max_end_silence", this.maxEndSilence);
        }
        params.putAll(this.parameters);
        return params;
    }

    @Override
    public Object getResources() {
        if (this.phraseId == null || this.phraseId.isEmpty()) {
            return null;
        }
        JsonArray jsonResources = new JsonArray();
        JsonObject jsonPhraseResource = new JsonObject();
        jsonPhraseResource.addProperty("resource_id", this.phraseId);
        jsonPhraseResource.addProperty("resource_type", "asr_phrase");
        jsonResources.getAsJsonArray().add((JsonElement)jsonPhraseResource);
        return jsonResources;
    }

    @Override
    public Flowable<Object> getStreamingData() {
        return null;
    }

    private static boolean $default$disfluencyRemovalEnabled() {
        return false;
    }

    private static boolean $default$transcriptionEnabled() {
        return true;
    }

    private static String $default$sourceLanguage() {
        return null;
    }

    private static boolean $default$translationEnabled() {
        return false;
    }

    private static String[] $default$translationLanguages() {
        return null;
    }

    private static boolean $default$semanticPunctationEnabled() {
        return false;
    }

    private static Integer $default$maxEndSilence() {
        return null;
    }

    protected TranslationRecognizerParam(TranslationRecognizerParamBuilder<?, ?> b) {
        super((FullDuplexServiceParam.FullDuplexServiceParamBuilder<?, ?>)b);
        this.disfluencyRemovalEnabled = ((TranslationRecognizerParamBuilder)b).disfluencyRemovalEnabled$set ? ((TranslationRecognizerParamBuilder)b).disfluencyRemovalEnabled$value : TranslationRecognizerParam.$default$disfluencyRemovalEnabled();
        this.sampleRate = ((TranslationRecognizerParamBuilder)b).sampleRate;
        if (this.sampleRate == null) {
            throw new NullPointerException("sampleRate is marked non-null but is null");
        }
        this.format = ((TranslationRecognizerParamBuilder)b).format;
        if (this.format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.phraseId = ((TranslationRecognizerParamBuilder)b).phraseId;
        this.vocabularyId = ((TranslationRecognizerParamBuilder)b).vocabularyId;
        this.transcriptionEnabled = ((TranslationRecognizerParamBuilder)b).transcriptionEnabled$set ? ((TranslationRecognizerParamBuilder)b).transcriptionEnabled$value : TranslationRecognizerParam.$default$transcriptionEnabled();
        this.sourceLanguage = ((TranslationRecognizerParamBuilder)b).sourceLanguage$set ? ((TranslationRecognizerParamBuilder)b).sourceLanguage$value : TranslationRecognizerParam.$default$sourceLanguage();
        this.translationEnabled = ((TranslationRecognizerParamBuilder)b).translationEnabled$set ? ((TranslationRecognizerParamBuilder)b).translationEnabled$value : TranslationRecognizerParam.$default$translationEnabled();
        this.translationLanguages = ((TranslationRecognizerParamBuilder)b).translationLanguages$set ? ((TranslationRecognizerParamBuilder)b).translationLanguages$value : TranslationRecognizerParam.$default$translationLanguages();
        this.semanticPunctationEnabled = ((TranslationRecognizerParamBuilder)b).semanticPunctationEnabled$set ? ((TranslationRecognizerParamBuilder)b).semanticPunctationEnabled$value : TranslationRecognizerParam.$default$semanticPunctationEnabled();
        this.maxEndSilence = ((TranslationRecognizerParamBuilder)b).maxEndSilence$set ? ((TranslationRecognizerParamBuilder)b).maxEndSilence$value : TranslationRecognizerParam.$default$maxEndSilence();
    }

    public static TranslationRecognizerParamBuilder<?, ?> builder() {
        return new TranslationRecognizerParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslationRecognizerParam)) {
            return false;
        }
        TranslationRecognizerParam other = (TranslationRecognizerParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDisfluencyRemovalEnabled() != other.isDisfluencyRemovalEnabled()) {
            return false;
        }
        if (this.isTranscriptionEnabled() != other.isTranscriptionEnabled()) {
            return false;
        }
        if (this.isTranslationEnabled() != other.isTranslationEnabled()) {
            return false;
        }
        if (this.isSemanticPunctationEnabled() != other.isSemanticPunctationEnabled()) {
            return false;
        }
        Integer this$sampleRate = this.getSampleRate();
        Integer other$sampleRate = other.getSampleRate();
        if (this$sampleRate == null ? other$sampleRate != null : !((Object)this$sampleRate).equals(other$sampleRate)) {
            return false;
        }
        Integer this$maxEndSilence = this.getMaxEndSilence();
        Integer other$maxEndSilence = other.getMaxEndSilence();
        if (this$maxEndSilence == null ? other$maxEndSilence != null : !((Object)this$maxEndSilence).equals(other$maxEndSilence)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$phraseId = this.getPhraseId();
        String other$phraseId = other.getPhraseId();
        if (this$phraseId == null ? other$phraseId != null : !this$phraseId.equals(other$phraseId)) {
            return false;
        }
        String this$vocabularyId = this.getVocabularyId();
        String other$vocabularyId = other.getVocabularyId();
        if (this$vocabularyId == null ? other$vocabularyId != null : !this$vocabularyId.equals(other$vocabularyId)) {
            return false;
        }
        String this$sourceLanguage = this.getSourceLanguage();
        String other$sourceLanguage = other.getSourceLanguage();
        if (this$sourceLanguage == null ? other$sourceLanguage != null : !this$sourceLanguage.equals(other$sourceLanguage)) {
            return false;
        }
        return Arrays.deepEquals(this.getTranslationLanguages(), other.getTranslationLanguages());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TranslationRecognizerParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDisfluencyRemovalEnabled() ? 79 : 97);
        result = result * 59 + (this.isTranscriptionEnabled() ? 79 : 97);
        result = result * 59 + (this.isTranslationEnabled() ? 79 : 97);
        result = result * 59 + (this.isSemanticPunctationEnabled() ? 79 : 97);
        Integer $sampleRate = this.getSampleRate();
        result = result * 59 + ($sampleRate == null ? 43 : ((Object)$sampleRate).hashCode());
        Integer $maxEndSilence = this.getMaxEndSilence();
        result = result * 59 + ($maxEndSilence == null ? 43 : ((Object)$maxEndSilence).hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $phraseId = this.getPhraseId();
        result = result * 59 + ($phraseId == null ? 43 : $phraseId.hashCode());
        String $vocabularyId = this.getVocabularyId();
        result = result * 59 + ($vocabularyId == null ? 43 : $vocabularyId.hashCode());
        String $sourceLanguage = this.getSourceLanguage();
        result = result * 59 + ($sourceLanguage == null ? 43 : $sourceLanguage.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTranslationLanguages());
        return result;
    }

    public boolean isDisfluencyRemovalEnabled() {
        return this.disfluencyRemovalEnabled;
    }

    @NonNull
    public Integer getSampleRate() {
        return this.sampleRate;
    }

    @NonNull
    public String getFormat() {
        return this.format;
    }

    public String getPhraseId() {
        return this.phraseId;
    }

    public String getVocabularyId() {
        return this.vocabularyId;
    }

    public boolean isTranscriptionEnabled() {
        return this.transcriptionEnabled;
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public boolean isTranslationEnabled() {
        return this.translationEnabled;
    }

    public String[] getTranslationLanguages() {
        return this.translationLanguages;
    }

    public boolean isSemanticPunctationEnabled() {
        return this.semanticPunctationEnabled;
    }

    public Integer getMaxEndSilence() {
        return this.maxEndSilence;
    }

    public void setDisfluencyRemovalEnabled(boolean disfluencyRemovalEnabled) {
        this.disfluencyRemovalEnabled = disfluencyRemovalEnabled;
    }

    public void setSampleRate(@NonNull Integer sampleRate) {
        if (sampleRate == null) {
            throw new NullPointerException("sampleRate is marked non-null but is null");
        }
        this.sampleRate = sampleRate;
    }

    public void setFormat(@NonNull String format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    public void setPhraseId(String phraseId) {
        this.phraseId = phraseId;
    }

    public void setVocabularyId(String vocabularyId) {
        this.vocabularyId = vocabularyId;
    }

    public void setTranscriptionEnabled(boolean transcriptionEnabled) {
        this.transcriptionEnabled = transcriptionEnabled;
    }

    public void setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public void setTranslationEnabled(boolean translationEnabled) {
        this.translationEnabled = translationEnabled;
    }

    public void setTranslationLanguages(String[] translationLanguages) {
        this.translationLanguages = translationLanguages;
    }

    public void setSemanticPunctationEnabled(boolean semanticPunctationEnabled) {
        this.semanticPunctationEnabled = semanticPunctationEnabled;
    }

    public void setMaxEndSilence(Integer maxEndSilence) {
        this.maxEndSilence = maxEndSilence;
    }

    @Override
    public String toString() {
        return "TranslationRecognizerParam(disfluencyRemovalEnabled=" + this.isDisfluencyRemovalEnabled() + ", sampleRate=" + this.getSampleRate() + ", format=" + this.getFormat() + ", phraseId=" + this.getPhraseId() + ", vocabularyId=" + this.getVocabularyId() + ", transcriptionEnabled=" + this.isTranscriptionEnabled() + ", sourceLanguage=" + this.getSourceLanguage() + ", translationEnabled=" + this.isTranslationEnabled() + ", translationLanguages=" + Arrays.deepToString(this.getTranslationLanguages()) + ", semanticPunctationEnabled=" + this.isSemanticPunctationEnabled() + ", maxEndSilence=" + this.getMaxEndSilence() + ")";
    }

    private static final class TranslationRecognizerParamBuilderImpl
    extends TranslationRecognizerParamBuilder<TranslationRecognizerParam, TranslationRecognizerParamBuilderImpl> {
        private TranslationRecognizerParamBuilderImpl() {
        }

        @Override
        protected TranslationRecognizerParamBuilderImpl self() {
            return this;
        }

        @Override
        public TranslationRecognizerParam build() {
            return new TranslationRecognizerParam(this);
        }
    }

    public static abstract class TranslationRecognizerParamBuilder<C extends TranslationRecognizerParam, B extends TranslationRecognizerParamBuilder<C, B>>
    extends FullDuplexServiceParam.FullDuplexServiceParamBuilder<C, B> {
        private boolean disfluencyRemovalEnabled$set;
        private boolean disfluencyRemovalEnabled$value;
        private Integer sampleRate;
        private String format;
        private String phraseId;
        private String vocabularyId;
        private boolean transcriptionEnabled$set;
        private boolean transcriptionEnabled$value;
        private boolean sourceLanguage$set;
        private String sourceLanguage$value;
        private boolean translationEnabled$set;
        private boolean translationEnabled$value;
        private boolean translationLanguages$set;
        private String[] translationLanguages$value;
        private boolean semanticPunctationEnabled$set;
        private boolean semanticPunctationEnabled$value;
        private boolean maxEndSilence$set;
        private Integer maxEndSilence$value;

        public B disfluencyRemovalEnabled(boolean disfluencyRemovalEnabled) {
            this.disfluencyRemovalEnabled$value = disfluencyRemovalEnabled;
            this.disfluencyRemovalEnabled$set = true;
            return (B)this.self();
        }

        public B sampleRate(@NonNull Integer sampleRate) {
            if (sampleRate == null) {
                throw new NullPointerException("sampleRate is marked non-null but is null");
            }
            this.sampleRate = sampleRate;
            return (B)this.self();
        }

        public B format(@NonNull String format) {
            if (format == null) {
                throw new NullPointerException("format is marked non-null but is null");
            }
            this.format = format;
            return (B)this.self();
        }

        public B phraseId(String phraseId) {
            this.phraseId = phraseId;
            return (B)this.self();
        }

        public B vocabularyId(String vocabularyId) {
            this.vocabularyId = vocabularyId;
            return (B)this.self();
        }

        public B transcriptionEnabled(boolean transcriptionEnabled) {
            this.transcriptionEnabled$value = transcriptionEnabled;
            this.transcriptionEnabled$set = true;
            return (B)this.self();
        }

        public B sourceLanguage(String sourceLanguage) {
            this.sourceLanguage$value = sourceLanguage;
            this.sourceLanguage$set = true;
            return (B)this.self();
        }

        public B translationEnabled(boolean translationEnabled) {
            this.translationEnabled$value = translationEnabled;
            this.translationEnabled$set = true;
            return (B)this.self();
        }

        public B translationLanguages(String[] translationLanguages) {
            this.translationLanguages$value = translationLanguages;
            this.translationLanguages$set = true;
            return (B)this.self();
        }

        public B semanticPunctationEnabled(boolean semanticPunctationEnabled) {
            this.semanticPunctationEnabled$value = semanticPunctationEnabled;
            this.semanticPunctationEnabled$set = true;
            return (B)this.self();
        }

        public B maxEndSilence(Integer maxEndSilence) {
            this.maxEndSilence$value = maxEndSilence;
            this.maxEndSilence$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TranslationRecognizerParam.TranslationRecognizerParamBuilder(super=" + super.toString() + ", disfluencyRemovalEnabled$value=" + this.disfluencyRemovalEnabled$value + ", sampleRate=" + this.sampleRate + ", format=" + this.format + ", phraseId=" + this.phraseId + ", vocabularyId=" + this.vocabularyId + ", transcriptionEnabled$value=" + this.transcriptionEnabled$value + ", sourceLanguage$value=" + this.sourceLanguage$value + ", translationEnabled$value=" + this.translationEnabled$value + ", translationLanguages$value=" + Arrays.deepToString(this.translationLanguages$value) + ", semanticPunctationEnabled$value=" + this.semanticPunctationEnabled$value + ", maxEndSilence$value=" + this.maxEndSilence$value + ")";
        }
    }
}

