/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.omni;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;

public class OmniRealtimeParam {
    public static String baseWebsocketApiUrl = System.getenv().getOrDefault("DASHSCOPE_WEBSOCKET_OMNI_BASE_URL", String.format("wss://dashscope.aliyuncs.com/api-ws/v1/realtime", new Object[0]));
    @NonNull
    private String model;
    private String apikey;
    private String workspace;
    protected Map<String, Object> headers;
    private String url;

    public Map<String, String> getHeaders() {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue().toString();
            res.put(key, value);
        }
        return res;
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url + "?model=" + this.model;
        }
        return baseWebsocketApiUrl + "?model=" + this.model;
    }

    protected OmniRealtimeParam(OmniRealtimeParamBuilder<?, ?> b) {
        Map<Object, Object> headers;
        this.model = ((OmniRealtimeParamBuilder)b).model;
        if (this.model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.apikey = ((OmniRealtimeParamBuilder)b).apikey;
        this.workspace = ((OmniRealtimeParamBuilder)b).workspace;
        switch (((OmniRealtimeParamBuilder)b).headers$key == null ? 0 : ((OmniRealtimeParamBuilder)b).headers$key.size()) {
            case 0: {
                headers = Collections.emptyMap();
                break;
            }
            case 1: {
                headers = Collections.singletonMap(((OmniRealtimeParamBuilder)b).headers$key.get(0), ((OmniRealtimeParamBuilder)b).headers$value.get(0));
                break;
            }
            default: {
                headers = new LinkedHashMap(((OmniRealtimeParamBuilder)b).headers$key.size() < 0x40000000 ? 1 + ((OmniRealtimeParamBuilder)b).headers$key.size() + (((OmniRealtimeParamBuilder)b).headers$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < ((OmniRealtimeParamBuilder)b).headers$key.size(); ++$i) {
                    headers.put(((OmniRealtimeParamBuilder)b).headers$key.get($i), ((OmniRealtimeParamBuilder)b).headers$value.get($i));
                }
                headers = Collections.unmodifiableMap(headers);
            }
        }
        this.headers = headers;
        this.url = ((OmniRealtimeParamBuilder)b).url;
    }

    public static OmniRealtimeParamBuilder<?, ?> builder() {
        return new OmniRealtimeParamBuilderImpl();
    }

    public void setModel(@NonNull String model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.model = model;
    }

    public void setApikey(String apikey) {
        this.apikey = apikey;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OmniRealtimeParam)) {
            return false;
        }
        OmniRealtimeParam other = (OmniRealtimeParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$apikey = this.getApikey();
        String other$apikey = other.getApikey();
        if (this$apikey == null ? other$apikey != null : !this$apikey.equals(other$apikey)) {
            return false;
        }
        String this$workspace = this.getWorkspace();
        String other$workspace = other.getWorkspace();
        if (this$workspace == null ? other$workspace != null : !this$workspace.equals(other$workspace)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OmniRealtimeParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $apikey = this.getApikey();
        result = result * 59 + ($apikey == null ? 43 : $apikey.hashCode());
        String $workspace = this.getWorkspace();
        result = result * 59 + ($workspace == null ? 43 : $workspace.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public String toString() {
        return "OmniRealtimeParam(model=" + this.getModel() + ", apikey=" + this.getApikey() + ", workspace=" + this.getWorkspace() + ", headers=" + this.getHeaders() + ", url=" + this.getUrl() + ")";
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    public String getApikey() {
        return this.apikey;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    private static final class OmniRealtimeParamBuilderImpl
    extends OmniRealtimeParamBuilder<OmniRealtimeParam, OmniRealtimeParamBuilderImpl> {
        private OmniRealtimeParamBuilderImpl() {
        }

        @Override
        protected OmniRealtimeParamBuilderImpl self() {
            return this;
        }

        @Override
        public OmniRealtimeParam build() {
            return new OmniRealtimeParam(this);
        }
    }

    public static abstract class OmniRealtimeParamBuilder<C extends OmniRealtimeParam, B extends OmniRealtimeParamBuilder<C, B>> {
        private String model;
        private String apikey;
        private String workspace;
        private ArrayList<String> headers$key;
        private ArrayList<Object> headers$value;
        private String url;

        public B model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this.self();
        }

        public B apikey(String apikey) {
            this.apikey = apikey;
            return this.self();
        }

        public B workspace(String workspace) {
            this.workspace = workspace;
            return this.self();
        }

        public B header(String headerKey, Object headerValue) {
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            this.headers$key.add(headerKey);
            this.headers$value.add(headerValue);
            return this.self();
        }

        public B headers(Map<? extends String, ? extends Object> headers) {
            if (headers == null) {
                throw new NullPointerException("headers cannot be null");
            }
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : headers.entrySet()) {
                this.headers$key.add($lombokEntry.getKey());
                this.headers$value.add($lombokEntry.getValue());
            }
            return this.self();
        }

        public B clearHeaders() {
            if (this.headers$key != null) {
                this.headers$key.clear();
                this.headers$value.clear();
            }
            return this.self();
        }

        public B url(String url) {
            this.url = url;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "OmniRealtimeParam.OmniRealtimeParamBuilder(model=" + this.model + ", apikey=" + this.apikey + ", workspace=" + this.workspace + ", headers$key=" + this.headers$key + ", headers$value=" + this.headers$value + ", url=" + this.url + ")";
        }
    }
}

