/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.threads.messages;

import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.threads.messages.MessageParamBase;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class TextMessageParam
extends MessageParamBase {
    @NonNull
    String role;
    @NonNull
    String content;
    @SerializedName(value="file_ids")
    List<String> fileIds;
    @SerializedName(value="metadata")
    private Map<String, String> metadata;

    @Override
    public JsonObject getHttpBody() {
        JsonObject requestObject = new JsonObject();
        requestObject.addProperty("role", this.role);
        requestObject.addProperty("content", this.content);
        if (this.fileIds != null && !this.fileIds.isEmpty()) {
            requestObject.add("file_ids", (JsonElement)JsonUtils.toJsonArray(this.fileIds));
        }
        if (this.metadata != null && !this.metadata.isEmpty()) {
            requestObject.add("metadata", (JsonElement)JsonUtils.toJsonObject(this.metadata));
        }
        this.addExtraBody(requestObject);
        return requestObject;
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.role.equals("") || this.content.equals("") || !this.role.equals("user") && !this.role.equals("assistant")) {
            throw new InputRequiredException("role mast be set and mast one of[user|assistant]");
        }
    }

    private static Map<String, String> $default$metadata() {
        return null;
    }

    protected TextMessageParam(TextMessageParamBuilder<?, ?> b) {
        super((MessageParamBase.MessageParamBaseBuilder<?, ?>)b);
        this.role = ((TextMessageParamBuilder)b).role;
        if (this.role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.content = ((TextMessageParamBuilder)b).content;
        if (this.content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.fileIds = ((TextMessageParamBuilder)b).fileIds;
        this.metadata = ((TextMessageParamBuilder)b).metadata$set ? ((TextMessageParamBuilder)b).metadata$value : TextMessageParam.$default$metadata();
    }

    public static TextMessageParamBuilder<?, ?> builder() {
        return new TextMessageParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextMessageParam)) {
            return false;
        }
        TextMessageParam other = (TextMessageParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<String> this$fileIds = this.getFileIds();
        List<String> other$fileIds = other.getFileIds();
        if (this$fileIds == null ? other$fileIds != null : !((Object)this$fileIds).equals(other$fileIds)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextMessageParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<String> $fileIds = this.getFileIds();
        result = result * 59 + ($fileIds == null ? 43 : ((Object)$fileIds).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    @NonNull
    public String getRole() {
        return this.role;
    }

    @NonNull
    public String getContent() {
        return this.content;
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setRole(@NonNull String role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
    }

    public void setContent(@NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.content = content;
    }

    public void setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Override
    public String toString() {
        return "TextMessageParam(role=" + this.getRole() + ", content=" + this.getContent() + ", fileIds=" + this.getFileIds() + ", metadata=" + this.getMetadata() + ")";
    }

    private static final class TextMessageParamBuilderImpl
    extends TextMessageParamBuilder<TextMessageParam, TextMessageParamBuilderImpl> {
        private TextMessageParamBuilderImpl() {
        }

        @Override
        protected TextMessageParamBuilderImpl self() {
            return this;
        }

        @Override
        public TextMessageParam build() {
            return new TextMessageParam(this);
        }
    }

    public static abstract class TextMessageParamBuilder<C extends TextMessageParam, B extends TextMessageParamBuilder<C, B>>
    extends MessageParamBase.MessageParamBaseBuilder<C, B> {
        private String role;
        private String content;
        private List<String> fileIds;
        private boolean metadata$set;
        private Map<String, String> metadata$value;

        public B role(@NonNull String role) {
            if (role == null) {
                throw new NullPointerException("role is marked non-null but is null");
            }
            this.role = role;
            return (B)this.self();
        }

        public B content(@NonNull String content) {
            if (content == null) {
                throw new NullPointerException("content is marked non-null but is null");
            }
            this.content = content;
            return (B)this.self();
        }

        public B fileIds(List<String> fileIds) {
            this.fileIds = fileIds;
            return (B)this.self();
        }

        public B metadata(Map<String, String> metadata) {
            this.metadata$value = metadata;
            this.metadata$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TextMessageParam.TextMessageParamBuilder(super=" + super.toString() + ", role=" + this.role + ", content=" + this.content + ", fileIds=" + this.fileIds + ", metadata$value=" + this.metadata$value + ")";
        }
    }
}

