/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client.protocol.asr;

import com.alibaba.nls.client.protocol.NlsClient;
import com.alibaba.nls.client.protocol.SpeechReqProtocol;
import com.alibaba.nls.client.protocol.asr.SpeechRecognizer;
import com.alibaba.nls.client.protocol.asr.SpeechRecognizerListener;
import com.alibaba.nls.client.util.IdGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSpeechRecognizer
extends SpeechRecognizer {
    static Logger logger = LoggerFactory.getLogger(AsyncSpeechRecognizer.class);

    public AsyncSpeechRecognizer(NlsClient client, SpeechRecognizerListener listener) throws Exception {
        super(client, listener);
    }

    public AsyncSpeechRecognizer(NlsClient client, String token, SpeechRecognizerListener listener) throws Exception {
        super(client, token, listener);
    }

    @Override
    void markReady() {
        this.state = SpeechReqProtocol.State.STATE_REQUEST_CONFIRMED;
    }

    @Override
    void markComplete() {
        this.state = SpeechReqProtocol.State.STATE_COMPLETE;
    }

    @Override
    void markFail() {
        this.state = SpeechReqProtocol.State.STATE_FAIL;
    }

    @Override
    void markClosed() {
        this.state = SpeechReqProtocol.State.STATE_CLOSED;
    }

    @Override
    public void start() throws Exception {
        String taskId;
        this.state.checkStart();
        this.currentTaskId = taskId = IdGen.genId();
        this.setTaskId(taskId);
        this.conn.sendText(this.serialize());
        this.state = SpeechReqProtocol.State.STATE_REQUEST_SENT;
    }

    @Override
    public void stop() throws Exception {
        this.state.checkStop();
        SpeechReqProtocol req = new SpeechReqProtocol();
        req.setAppKey(this.getAppKey());
        req.header.put("namespace", "SpeechRecognizer");
        req.header.put("name", "StopRecognition");
        req.header.put("task_id", this.currentTaskId);
        this.conn.sendText(req.serialize());
        this.state = SpeechReqProtocol.State.STATE_STOP_SENT;
    }
}

