/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.common.logging;

import com.alibaba.polardbx.common.logging.Log;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jImpl
implements Log {
    private static final String callerFQCN = Log4jImpl.class.getName();
    private Logger log;

    public Log4jImpl(Logger log) {
        this.log = log;
    }

    public Log4jImpl(String loggerName) {
        this.log = Logger.getLogger((String)loggerName);
    }

    public Logger getLog() {
        return this.log;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public void debug(String s) {
        this.log.log(callerFQCN, (Priority)Level.DEBUG, (Object)s, null);
    }

    @Override
    public void debug(String s, Throwable e) {
        this.log.log(callerFQCN, (Priority)Level.DEBUG, (Object)s, e);
    }

    @Override
    public void info(String msg) {
        this.log.log(callerFQCN, (Priority)Level.INFO, (Object)msg, null);
    }

    @Override
    public void info(String s, Throwable e) {
        this.log.log(callerFQCN, (Priority)Level.INFO, (Object)s, e);
    }

    @Override
    public void warn(String s) {
        this.log.log(callerFQCN, (Priority)Level.WARN, (Object)s, null);
    }

    @Override
    public void warn(String s, Throwable e) {
        this.log.log(callerFQCN, (Priority)Level.WARN, (Object)s, e);
    }

    @Override
    public void error(String s, Throwable e) {
        this.log.log(callerFQCN, (Priority)Level.ERROR, (Object)s, e);
    }

    @Override
    public void error(String s) {
        this.log.log(callerFQCN, (Priority)Level.ERROR, (Object)s, null);
    }

    public String toString() {
        return this.log.toString();
    }
}

