/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.node.impl;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.common.model.metaserver.NotifyProvideDataChange;
import com.alipay.sofa.registry.common.model.metaserver.SessionNode;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.server.meta.bootstrap.MetaServerConfig;
import com.alipay.sofa.registry.server.meta.bootstrap.ServiceFactory;
import com.alipay.sofa.registry.server.meta.node.SessionNodeService;
import com.alipay.sofa.registry.server.meta.remoting.connection.NodeConnectManager;
import com.alipay.sofa.registry.server.meta.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.server.meta.store.StoreService;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionNodeServiceImpl
implements SessionNodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionNodeServiceImpl.class);
    @Autowired
    private NodeExchanger sessionNodeExchanger;
    @Autowired
    private StoreService sessionStoreService;
    @Autowired
    private MetaServerConfig metaServerConfig;
    @Autowired
    private AbstractServerHandler sessionConnectionHandler;

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.SESSION;
    }

    @Override
    public void pushSessions(final NodeChangeResult nodeChangeResult, Map<String, SessionNode> sessionNodes, String confirmNodeIp) {
        NodeConnectManager nodeConnectManager;
        Collection<InetSocketAddress> connections;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SessionNodeServiceImpl pushSessions sessionNodes:{}", (Object)nodeChangeResult);
        }
        if ((connections = (nodeConnectManager = this.getNodeConnectManager()).getConnections(null)).size() == 0) {
            LOGGER.warn("there are no client connected on session server port:{}", (Object)this.metaServerConfig.getSessionServerPort());
        }
        if (sessionNodes == null || sessionNodes.isEmpty()) {
            LOGGER.error("Push sessionNode list error! Input sessionNodes can't be null!");
            throw new RuntimeException("Push sessionNode list error! Input sessionNodes can't be null!");
        }
        for (final InetSocketAddress connection : connections) {
            if (!sessionNodes.keySet().contains(connection.getAddress().getHostAddress())) continue;
            try {
                Request<NodeChangeResult> nodeChangeRequest = new Request<NodeChangeResult>(){

                    public NodeChangeResult getRequestBody() {
                        return nodeChangeResult;
                    }

                    public URL getRequestUrl() {
                        return new URL(connection);
                    }
                };
                this.sessionNodeExchanger.request((Request)nodeChangeRequest);
                this.sessionStoreService.confirmNodeStatus(connection.getAddress().getHostAddress(), confirmNodeIp);
            }
            catch (RequestException e) {
                LOGGER.error("Push sessionNode list error! " + e.getRequestMessage(), (Throwable)e);
                throw new RuntimeException("SessionNodeService push sessionNode list error!");
            }
        }
    }

    @Override
    public void pushDataNodes(final NodeChangeResult nodeChangeResult) {
        NodeConnectManager nodeConnectManager = this.getNodeConnectManager();
        Collection<InetSocketAddress> connections = nodeConnectManager.getConnections(null);
        if (connections == null || connections.isEmpty()) {
            LOGGER.error("Push sessionNode list error! No session node connected!");
            throw new RuntimeException("Push sessionNode list error! No session node connected!");
        }
        StoreService storeService = ServiceFactory.getStoreService(Node.NodeType.SESSION);
        Map sessionNodes = storeService.getNodes();
        if (sessionNodes == null || sessionNodes.isEmpty()) {
            LOGGER.error("Push sessionNode list error! No session node registered!");
            throw new RuntimeException("Push sessionNode list error! No session node registered!");
        }
        for (final InetSocketAddress connection : connections) {
            if (!sessionNodes.keySet().contains(connection.getAddress().getHostAddress())) continue;
            try {
                Request<NodeChangeResult> nodeChangeRequestRequest = new Request<NodeChangeResult>(){

                    public NodeChangeResult getRequestBody() {
                        return nodeChangeResult;
                    }

                    public URL getRequestUrl() {
                        return new URL(connection);
                    }
                };
                this.sessionNodeExchanger.request((Request)nodeChangeRequestRequest);
            }
            catch (RequestException e) {
                LOGGER.error("Push sessionNode list error! " + e.getRequestMessage(), (Throwable)e);
                throw new RuntimeException("SessionNodeService push dataNode list error!");
            }
        }
    }

    @Override
    public void notifyProvideDataChange(final NotifyProvideDataChange notifyProvideDataChange) {
        NodeConnectManager nodeConnectManager = this.getNodeConnectManager();
        Collection<InetSocketAddress> connections = nodeConnectManager.getConnections(null);
        if (connections == null || connections.isEmpty()) {
            LOGGER.error("Push sessionNode list error! No session node connected!");
            throw new RuntimeException("Push sessionNode list error! No session node connected!");
        }
        StoreService storeService = ServiceFactory.getStoreService(Node.NodeType.SESSION);
        Map sessionNodes = storeService.getNodes();
        if (sessionNodes == null || sessionNodes.isEmpty()) {
            LOGGER.error("Push sessionNode list error! No session node registered!");
            throw new RuntimeException("Push sessionNode list error! No session node registered!");
        }
        for (final InetSocketAddress connection : connections) {
            if (!sessionNodes.keySet().contains(connection.getAddress().getHostAddress())) continue;
            try {
                Request<NotifyProvideDataChange> request = new Request<NotifyProvideDataChange>(){

                    public NotifyProvideDataChange getRequestBody() {
                        return notifyProvideDataChange;
                    }

                    public URL getRequestUrl() {
                        return new URL(connection);
                    }
                };
                this.sessionNodeExchanger.request((Request)request);
            }
            catch (RequestException e) {
                LOGGER.error("Notify provide data change error! " + e.getRequestMessage(), (Throwable)e);
                throw new RuntimeException("Notify provide data change error!");
            }
        }
    }

    private NodeConnectManager getNodeConnectManager() {
        if (!(this.sessionConnectionHandler instanceof NodeConnectManager)) {
            LOGGER.error("sessionConnectionHandler inject is not NodeConnectManager instance!");
            throw new RuntimeException("sessionConnectionHandler inject is not NodeConnectManager instance!");
        }
        return (NodeConnectManager)((Object)this.sessionConnectionHandler);
    }
}

