/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.remoting;

import com.alipay.sofa.jraft.CliService;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.core.CliServiceImpl;
import com.alipay.sofa.jraft.core.NodeImpl;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.CliOptions;
import com.alipay.sofa.jraft.rpc.impl.AbstractBoltClientService;
import com.alipay.sofa.registry.common.model.metaserver.MetaNode;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.jraft.bootstrap.RaftClient;
import com.alipay.sofa.registry.jraft.bootstrap.RaftServer;
import com.alipay.sofa.registry.jraft.bootstrap.RaftServerConfig;
import com.alipay.sofa.registry.jraft.processor.FollowerProcessListener;
import com.alipay.sofa.registry.jraft.processor.LeaderProcessListener;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.server.meta.bootstrap.MetaServerConfig;
import com.alipay.sofa.registry.server.meta.bootstrap.NodeConfig;
import com.alipay.sofa.registry.server.meta.executor.ExecutorManager;
import com.alipay.sofa.registry.server.meta.registry.Registry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class RaftExchanger {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftExchanger.class);
    private static final Logger METRICS_LOGGER = LoggerFactory.getLogger((String)"META-JRAFT-METRICS");
    @Autowired
    private MetaServerConfig metaServerConfig;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private Registry metaServerRegistry;
    private RaftServer raftServer;
    private RaftClient raftClient;
    private CliService cliService;
    private AtomicBoolean clientStart = new AtomicBoolean(false);
    private AtomicBoolean serverStart = new AtomicBoolean(false);
    private AtomicBoolean clsStart = new AtomicBoolean(false);

    public void startRaftServer(final ExecutorManager executorManager) {
        try {
            if (this.serverStart.compareAndSet(false, true)) {
                String serverId = NetUtil.genHost((String)NetUtil.getLocalAddress().getHostAddress(), (int)this.metaServerConfig.getRaftServerPort());
                String serverConf = this.getServerConfig();
                this.raftServer = new RaftServer(this.metaServerConfig.getRaftDataPath(), this.getGroup(), serverId, serverConf);
                this.raftServer.setLeaderProcessListener(new LeaderProcessListener(){

                    public void startProcess() {
                        LOGGER.info("Start leader process...");
                        executorManager.startScheduler();
                        LOGGER.info("Initialize server scheduler success!");
                        PeerId leader = new PeerId(NetUtil.getLocalAddress().getHostAddress(), RaftExchanger.this.metaServerConfig.getRaftServerPort());
                        RaftExchanger.this.raftServer.sendNotify(leader, "leader");
                        RaftExchanger.this.registerCurrentNode();
                    }

                    public void stopProcess() {
                        LOGGER.info("Stop leader process...");
                        executorManager.stopScheduler();
                        LOGGER.info("Stop server scheduler success!");
                        PeerId leader = new PeerId(NetUtil.getLocalAddress().getHostAddress(), RaftExchanger.this.metaServerConfig.getRaftServerPort());
                        RaftExchanger.this.raftServer.sendNotify(leader, "leader");
                    }
                });
                this.raftServer.setFollowerProcessListener(new FollowerProcessListener(){

                    public void startProcess(PeerId leader) {
                        LOGGER.info("Start follower process leader {}...", (Object)leader);
                        RaftExchanger.this.raftServer.sendNotify(leader, "follower");
                        RaftExchanger.this.registerCurrentNode();
                    }

                    public void stopProcess(PeerId leader) {
                        LOGGER.info("Stop follower process leader {}...", (Object)leader);
                        RaftExchanger.this.raftServer.sendNotify(leader, "follower");
                    }
                });
                RaftServerConfig raftServerConfig = new RaftServerConfig();
                raftServerConfig.setMetricsLogger(METRICS_LOGGER);
                raftServerConfig.setEnableMetrics(this.metaServerConfig.isEnableMetrics());
                this.raftServer.start(raftServerConfig);
            }
        }
        catch (Exception e) {
            this.serverStart.set(false);
            LOGGER.error("Start raft server error!", (Throwable)e);
            throw new RuntimeException("Start raft server error!", e);
        }
    }

    public void startRaftClient() {
        try {
            if (this.clientStart.compareAndSet(false, true)) {
                String serverConf = this.getServerConfig();
                this.raftClient = this.raftServer != null && this.raftServer.getNode() != null ? new RaftClient(this.getGroup(), serverConf, (AbstractBoltClientService)((NodeImpl)this.raftServer.getNode()).getRpcService()) : new RaftClient(this.getGroup(), serverConf);
                this.raftClient.start();
            }
        }
        catch (Exception e) {
            this.clientStart.set(false);
            LOGGER.error("Start raft client error!", (Throwable)e);
            throw new RuntimeException("Start raft client error!", e);
        }
    }

    public void startCliService() {
        if (this.clsStart.compareAndSet(false, true)) {
            try {
                this.cliService = new CliServiceImpl();
                this.cliService.init((Object)new CliOptions());
            }
            catch (Exception e) {
                LOGGER.error("Start raft cliService error!", (Throwable)e);
                throw new RuntimeException("Start raft cliService error!", e);
            }
        }
    }

    private void registerCurrentNode() {
        Map<String, Collection<String>> metaMap = this.nodeConfig.getMetaNodeIP();
        if (metaMap != null && metaMap.size() > 0) {
            Collection<String> metas = metaMap.get(this.nodeConfig.getLocalDataCenter());
            String ip = NetUtil.getLocalAddress().getHostAddress();
            if (metas != null && metas.contains(ip)) {
                this.metaServerRegistry.register(new MetaNode(new URL(ip, 0), this.nodeConfig.getLocalDataCenter()));
            } else {
                LOGGER.error("Register CurrentNode fail!meta node list config not contains current ip {}", (Object)ip);
                throw new RuntimeException("Register CurrentNode fail!meta node list config not contains current ip!");
            }
        }
    }

    public void changePeer(List<String> ipAddressList) {
        block5: {
            try {
                if (this.cliService != null) {
                    Configuration peersConf = new Configuration();
                    for (String ipAddress : ipAddressList) {
                        PeerId peer = new PeerId(ipAddress, this.metaServerConfig.getRaftServerPort());
                        peersConf.addPeer(peer);
                    }
                    Status status = this.cliService.changePeers(this.getGroup(), this.getCurrentConfiguration(), peersConf);
                    if (!status.isOk()) {
                        LOGGER.error("CliService change peer fail!error message {}", (Object)status.getErrorMsg());
                        throw new RuntimeException("CliService change peer fail!error message " + status.getErrorMsg());
                    }
                    break block5;
                }
                LOGGER.error("cliService can't be null,it must be init first!");
                throw new RuntimeException("cliService can't be null,it must be init first!");
            }
            catch (Exception e) {
                LOGGER.error("CliService change peer error!", (Throwable)e);
                throw new RuntimeException("CliService change peer error!", e);
            }
        }
    }

    public void resetPeer(List<String> ipAddressList) {
        block5: {
            try {
                if (this.cliService != null) {
                    Configuration peersConf = new Configuration();
                    for (String ipAddress : ipAddressList) {
                        PeerId peer = new PeerId(ipAddress, this.metaServerConfig.getRaftServerPort());
                        peersConf.addPeer(peer);
                    }
                    String ip = NetUtil.getLocalAddress().getHostAddress();
                    PeerId localPeer = new PeerId(ip, this.metaServerConfig.getRaftServerPort());
                    Status status = this.cliService.resetPeer(this.getGroup(), localPeer, peersConf);
                    if (!status.isOk()) {
                        LOGGER.error("CliService reset peer fail!error message {}", (Object)status.getErrorMsg());
                        throw new RuntimeException("CliService reset peer fail!error message " + status.getErrorMsg());
                    }
                    break block5;
                }
                LOGGER.error("cliService can't be null,it must be init first!");
                throw new RuntimeException("cliService can't be null,it must be init first!");
            }
            catch (Exception e) {
                LOGGER.error("CliService reset peer error!", (Throwable)e);
                throw new RuntimeException("CliService reset peer error!", e);
            }
        }
    }

    public void removePeer(String ipAddress) {
        block4: {
            try {
                if (this.cliService != null) {
                    PeerId peer = new PeerId(ipAddress, this.metaServerConfig.getRaftServerPort());
                    Status status = this.cliService.removePeer(this.getGroup(), this.getCurrentConfiguration(), peer);
                    if (!status.isOk()) {
                        LOGGER.error("CliService remove peer fail!error message {}", (Object)status.getErrorMsg());
                        throw new RuntimeException("CliService remove peer fail!error message " + status.getErrorMsg());
                    }
                    break block4;
                }
                LOGGER.error("cliService can't be null,it must be init first!");
                throw new RuntimeException("cliService can't be null,it must be init first!");
            }
            catch (Exception e) {
                LOGGER.error("CliService remove peer error!", (Throwable)e);
                throw new RuntimeException("CliService remove peer error!", e);
            }
        }
    }

    public List<PeerId> getPeers() {
        try {
            Configuration currentConf = this.getCurrentConfiguration();
            return currentConf.getPeers();
        }
        catch (Exception e) {
            String msg = "Get peers error:" + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    private Configuration getCurrentConfiguration() {
        return ((NodeImpl)this.raftServer.getNode()).getCurrentConf();
    }

    public void refreshRaftClient() {
        this.raftClient.refreshLeader();
    }

    public void shutdown() {
        if (this.raftServer != null) {
            this.raftServer.shutdown();
        }
        if (this.raftClient != null) {
            this.raftClient.shutdown();
        }
        if (this.cliService != null) {
            this.cliService.shutdown();
        }
    }

    private String getServerConfig() {
        String ret = "";
        Set<String> ips = this.nodeConfig.getDataCenterMetaServers(this.nodeConfig.getLocalDataCenter());
        if (ips != null && !ips.isEmpty()) {
            ret = ips.stream().map(ip -> ip + ":" + this.metaServerConfig.getRaftServerPort()).collect(Collectors.joining(","));
        }
        if (ret.isEmpty()) {
            throw new IllegalArgumentException("Init raft server config error!");
        }
        return ret;
    }

    private String getGroup() {
        return this.metaServerConfig.getRaftGroup() + "_" + this.nodeConfig.getLocalDataCenter();
    }

    public RaftClient getRaftClient() {
        return this.raftClient;
    }

    public AtomicBoolean getClientStart() {
        return this.clientStart;
    }

    public AtomicBoolean getServerStart() {
        return this.serverStart;
    }

    public AtomicBoolean getClsStart() {
        return this.clsStart;
    }
}

