/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.store;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.metaserver.DataCenterNodes;
import com.alipay.sofa.registry.common.model.metaserver.DataNode;
import com.alipay.sofa.registry.common.model.metaserver.DataOperator;
import com.alipay.sofa.registry.common.model.metaserver.GetChangeListRequest;
import com.alipay.sofa.registry.common.model.metaserver.NodeChangeResult;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.meta.bootstrap.NodeConfig;
import com.alipay.sofa.registry.server.meta.bootstrap.ServiceFactory;
import com.alipay.sofa.registry.server.meta.node.MetaNodeService;
import com.alipay.sofa.registry.server.meta.node.NodeOperator;
import com.alipay.sofa.registry.server.meta.repository.NodeConfirmStatusService;
import com.alipay.sofa.registry.server.meta.repository.NodeRepository;
import com.alipay.sofa.registry.server.meta.repository.RepositoryService;
import com.alipay.sofa.registry.server.meta.store.RenewDecorate;
import com.alipay.sofa.registry.server.meta.store.StoreService;
import com.alipay.sofa.registry.store.api.annotation.RaftReference;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class DataStoreService
implements StoreService<DataNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataStoreService.class);
    private static final Logger TASK_LOGGER = LoggerFactory.getLogger(DataStoreService.class, (String)"[Task]");
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private TaskListenerManager taskListenerManager;
    @RaftReference(uniqueId="dataServer")
    private RepositoryService<String, RenewDecorate<DataNode>> dataRepositoryService;
    @RaftReference(uniqueId="dataServer")
    private NodeConfirmStatusService<DataNode> dataConfirmStatusService;
    private AtomicLong localDataCenterInitVersion = new AtomicLong(-1L);
    private static final long COMPARE_TIME_COST = 1000L;

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.DATA;
    }

    @Override
    public NodeChangeResult setNodes(List<DataNode> nodes) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeChangeResult addNode(DataNode dataNode) {
        NodeChangeResult nodeChangeResult;
        String ipAddress = dataNode.getNodeUrl().getIpAddress();
        long startAll = System.currentTimeMillis();
        this.write.lock();
        try {
            this.dataRepositoryService.put(ipAddress, new RenewDecorate<DataNode>(dataNode, 15L));
            this.reNew(dataNode, 30);
            nodeChangeResult = this.getNodeChangeResult();
            this.dataConfirmStatusService.putConfirmNode(dataNode, DataOperator.ADD);
        }
        finally {
            this.write.unlock();
        }
        long cost = System.currentTimeMillis() - startAll;
        if (cost >= 1000L) {
            LOGGER.info("dataRepositoryService.addNode cost:{} ", (Object)cost);
        }
        return nodeChangeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNode(String ipAddress) {
        this.write.lock();
        try {
            RenewDecorate<DataNode> dataNode = this.dataRepositoryService.remove(ipAddress);
            if (dataNode != null) {
                this.dataConfirmStatusService.putConfirmNode((DataNode)((Node)dataNode.getRenewal()), DataOperator.REMOVE);
                LOGGER.info("Remove single node {} success!", (Object)dataNode.getRenewal());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodes(Collection<DataNode> nodes) {
        this.write.lock();
        try {
            if (nodes != null && !nodes.isEmpty()) {
                for (DataNode dataNode : nodes) {
                    String ipAddress = dataNode.getNodeUrl().getIpAddress();
                    RenewDecorate<DataNode> dataNodeRemove = this.dataRepositoryService.remove(ipAddress);
                    if (dataNodeRemove == null) continue;
                    this.dataConfirmStatusService.putConfirmNode(dataNode, DataOperator.REMOVE);
                    LOGGER.info("Remove node {} success!", (Object)dataNodeRemove.getRenewal());
                }
            }
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reNew(DataNode dataNode, int duration) {
        long startAll = System.currentTimeMillis();
        this.write.lock();
        try {
            String ipAddress = dataNode.getNodeUrl().getIpAddress();
            RenewDecorate<DataNode> reNewer = this.dataRepositoryService.get(ipAddress);
            if (reNewer == null) {
                LOGGER.warn("Renew Data node with ipAddress:" + ipAddress + " has not existed!It will be registered again!");
                this.addNode(dataNode);
            } else if (duration > 0) {
                this.dataRepositoryService.replace(ipAddress, new RenewDecorate<DataNode>(dataNode, duration));
            } else {
                this.dataRepositoryService.replace(ipAddress, new RenewDecorate<DataNode>(dataNode, 15L));
            }
            long cost = System.currentTimeMillis() - startAll;
            if (cost >= 1000L) {
                LOGGER.info("dataRepositoryService.renew.all cost:{} ", (Object)cost);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public Collection<DataNode> getExpired() {
        ArrayList<DataNode> reNewerList = new ArrayList<DataNode>();
        this.read.lock();
        try {
            Map<String, RenewDecorate<DataNode>> dataMap = this.dataRepositoryService.getAllData();
            dataMap.forEach((ip, dataNode) -> {
                String dataCenter = ((DataNode)dataNode.getRenewal()).getDataCenter();
                if (dataCenter.equals(this.nodeConfig.getLocalDataCenter()) && dataNode.isExpired()) {
                    reNewerList.add((DataNode)dataNode.getRenewal());
                }
            });
        }
        finally {
            this.read.unlock();
        }
        return reNewerList;
    }

    @Override
    public Map<String, DataNode> getNodes() {
        Map<String, Map<String, DataNode>> map = this.getRunTime();
        HashMap<String, DataNode> ret = new HashMap<String, DataNode>();
        if (map != null && !map.isEmpty()) {
            map.forEach((dataCenter, dataNodes) -> ret.putAll((Map<String, DataNode>)dataNodes));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeChangeResult getNodeChangeResult() {
        NodeChangeResult nodeChangeResult = new NodeChangeResult(Node.NodeType.DATA);
        this.read.lock();
        try {
            String localDataCenter = this.nodeConfig.getLocalDataCenter();
            Map<String, NodeRepository> dataNodeRepositoryMap = this.dataRepositoryService.getNodeRepositories();
            ConcurrentHashMap pushNodes = new ConcurrentHashMap();
            ConcurrentHashMap versionMap = new ConcurrentHashMap();
            dataNodeRepositoryMap.forEach((dataCenter, dataNodeRepository) -> {
                if (localDataCenter.equalsIgnoreCase((String)dataCenter)) {
                    nodeChangeResult.setVersion(dataNodeRepository.getVersion());
                }
                versionMap.put(dataCenter, dataNodeRepository.getVersion());
                Map dataMap = dataNodeRepository.getNodeMap();
                ConcurrentHashMap newMap = new ConcurrentHashMap();
                dataMap.forEach((ip, dataNode) -> {
                    DataNode cfr_ignored_0 = (DataNode)newMap.put(ip, dataNode.getRenewal());
                });
                pushNodes.put(dataCenter, newMap);
            });
            nodeChangeResult.setNodes(pushNodes);
            nodeChangeResult.setDataCenterListVersions(versionMap);
            nodeChangeResult.setLocalDataCenter(localDataCenter);
        }
        finally {
            this.read.unlock();
        }
        return nodeChangeResult;
    }

    @Override
    public void pushNodeListChange() {
        NodeOperator<DataNode> fireNode = this.dataConfirmStatusService.peekConfirmNode();
        if (fireNode != null) {
            LOGGER.info("Now:type {},node {},Push queue:{}", new Object[]{fireNode.getNodeOperate(), fireNode.getNode().getNodeUrl().getIpAddress(), this.dataConfirmStatusService.getAllConfirmNodes()});
            NodeChangeResult nodeChangeResult = this.getNodeChangeResult();
            Map map = nodeChangeResult.getNodes();
            Map addNodes = (Map)map.get(this.nodeConfig.getLocalDataCenter());
            if (addNodes != null) {
                LOGGER.info("addNodes:{}", addNodes.keySet());
                Map<String, DataNode> previousNodes = this.dataConfirmStatusService.putExpectNodes(fireNode.getNode(), addNodes);
                if (!previousNodes.isEmpty()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("push Type:{},peek:{},list{}", new Object[]{fireNode.getNodeOperate(), fireNode.getNode().getNodeUrl().getIpAddress(), previousNodes.keySet()});
                    }
                    this.firePushDataListTask(fireNode, nodeChangeResult, previousNodes, true);
                }
            }
            this.firePushSessionListTask(nodeChangeResult, fireNode.getNodeOperate().toString());
        }
    }

    @Override
    public void confirmNodeStatus(String ipAddress, String confirmNodeIp) {
        NodeOperator<DataNode> fireNode = this.dataConfirmStatusService.peekConfirmNode();
        if (fireNode != null) {
            String fireNodeIp = fireNode.getNode().getIp();
            if (fireNodeIp != null && !fireNodeIp.equals(confirmNodeIp)) {
                LOGGER.info("Confirm node already be remove from queue!Receive ip:{},expect confirm ip:{},now peek ip:{}", new Object[]{ipAddress, confirmNodeIp, fireNodeIp});
                return;
            }
            Map<String, DataNode> waitNotifyNodes = this.dataConfirmStatusService.getExpectNodes(fireNode.getNode());
            if (waitNotifyNodes != null) {
                LOGGER.info("Peek node:{} oper:{},waitNotifyNodes:{},confirm ip:{}", new Object[]{fireNode.getNode().getNodeUrl().getIpAddress(), fireNode.getNodeOperate(), waitNotifyNodes.keySet(), ipAddress});
                Set<String> removeIp = this.getRemoveIp(waitNotifyNodes.keySet());
                removeIp.add(ipAddress);
                waitNotifyNodes = this.dataConfirmStatusService.removeExpectConfirmNodes(fireNode.getNode(), removeIp);
                if (waitNotifyNodes.isEmpty()) {
                    try {
                        if (null != this.dataConfirmStatusService.removeExpectNodes(this.dataConfirmStatusService.pollConfirmNode().getNode())) {
                            if (fireNode.getNodeOperate() == DataOperator.ADD) {
                                this.notifyConfirm(fireNode.getNode());
                            }
                            LOGGER.info("Data node {} operator {} be confirm,Dump queue:{}", new Object[]{fireNode.getNode().getNodeUrl().getIpAddress(), fireNode.getNodeOperate(), this.dataConfirmStatusService.getAllConfirmNodes()});
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Notify expect confirm status node {} interrupted!", (Object)fireNode.getNode());
                    }
                }
            } else {
                try {
                    this.dataConfirmStatusService.pollConfirmNode();
                    LOGGER.info("Data node {} operator {} poll!not other node need be notify!Confirm ip {},Dump queue:{}", new Object[]{fireNode.getNode().getNodeUrl().getIpAddress(), fireNode.getNodeOperate(), ipAddress, this.dataConfirmStatusService.getAllConfirmNodes()});
                }
                catch (InterruptedException e) {
                    LOGGER.error("Notify expect confirm status node " + fireNode.getNode() + " interrupted!", (Throwable)e);
                }
            }
        }
    }

    private Set<String> getRemoveIp(Set<String> waitNotifyNodes) {
        Map<String, Map<String, DataNode>> map = this.getRunTime();
        Map<String, DataNode> addNodes = map.get(this.nodeConfig.getLocalDataCenter());
        if (addNodes != null && !addNodes.isEmpty()) {
            return waitNotifyNodes.stream().filter(ip -> !addNodes.keySet().contains(ip)).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    private void firePushDataListTask(NodeOperator<DataNode> confirmNode, NodeChangeResult nodeChangeResult, Map<String, DataNode> targetNodes, boolean confirm) {
        String nodeOperate;
        String ip = "";
        if (confirmNode != null) {
            ip = confirmNode.getNode().getIp();
            nodeOperate = confirmNode.getNodeOperate().toString();
        } else {
            nodeOperate = "OtherDataCenter update";
        }
        TaskEvent taskEvent = new TaskEvent((Object)nodeChangeResult, TaskEvent.TaskType.DATA_NODE_CHANGE_PUSH_TASK);
        taskEvent.setAttribute("NEED_CONFIRM", (Object)confirm);
        taskEvent.setAttribute("PUSH_TARGET_DATA_NODE", targetNodes);
        taskEvent.setAttribute("PUSH_TARGET_TYPE", (Object)Node.NodeType.DATA);
        taskEvent.setAttribute("PUSH_TARGET_OPERATOR_TYPE", (Object)nodeOperate);
        taskEvent.setAttribute("PUSH_TARGET_CONFIRM_NODE", (Object)ip);
        TASK_LOGGER.info("send " + taskEvent.getTaskType() + " NodeType:" + Node.NodeType.DATA + " Operator:" + nodeOperate + " confirmNode:" + ip);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    private void firePushSessionListTask(NodeChangeResult nodeChangeResult, String nodeOperate) {
        TaskEvent taskEvent = new TaskEvent((Object)nodeChangeResult, TaskEvent.TaskType.DATA_NODE_CHANGE_PUSH_TASK);
        taskEvent.setAttribute("PUSH_TARGET_TYPE", (Object)Node.NodeType.SESSION);
        taskEvent.setAttribute("PUSH_TARGET_OPERATOR_TYPE", (Object)nodeOperate);
        TASK_LOGGER.info("send " + taskEvent.getTaskType() + " NodeType:" + Node.NodeType.SESSION + " Operator:" + nodeOperate);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    private void notifyConfirm(DataNode node) {
        TaskEvent taskEvent = new TaskEvent((Object)node, TaskEvent.TaskType.RECEIVE_STATUS_CONFIRM_NOTIFY_TASK);
        TASK_LOGGER.info("send " + taskEvent.getTaskType() + " DataNode:" + node);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, DataNode>> getRunTime() {
        this.read.lock();
        try {
            ConcurrentHashMap<String, Map<String, DataNode>> pushNodes = new ConcurrentHashMap<String, Map<String, DataNode>>();
            Map<String, Map<String, RenewDecorate<DataNode>>> dataCenterMap = this.dataRepositoryService.getAllDataMap();
            dataCenterMap.forEach((dataCenter, dataMap) -> {
                ConcurrentHashMap newMap = new ConcurrentHashMap();
                dataMap.forEach((ip, dataNode) -> {
                    DataNode cfr_ignored_0 = (DataNode)newMap.put(ip, dataNode.getRenewal());
                });
                pushNodes.put((String)dataCenter, newMap);
            });
            ConcurrentHashMap<String, Map<String, DataNode>> concurrentHashMap = pushNodes;
            return concurrentHashMap;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public void getOtherDataCenterNodeAndUpdate() {
        MetaNodeService metaNodeService = (MetaNodeService)ServiceFactory.getNodeService(Node.NodeType.META);
        Map<String, Collection<String>> metaMap = this.nodeConfig.getMetaNodeIP();
        if (metaMap != null && metaMap.size() > 0) {
            for (String dataCenter : metaMap.keySet()) {
                if (this.nodeConfig.getLocalDataCenter().equals(dataCenter)) continue;
                GetChangeListRequest getChangeListRequest = new GetChangeListRequest(Node.NodeType.DATA, dataCenter);
                DataCenterNodes getDataCenterNodes = metaNodeService.getDataCenterNodes(getChangeListRequest);
                if (getDataCenterNodes != null) {
                    String dataCenterGet = getDataCenterNodes.getDataCenterId();
                    Long version = getDataCenterNodes.getVersion();
                    if (version == null) {
                        LOGGER.error("Request message version cant not be null!");
                        return;
                    }
                    boolean result = this.dataRepositoryService.checkVersion(dataCenterGet, version);
                    if (!result) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("DataCenter {} data list version {} has not updated!", (Object)dataCenter, (Object)version);
                        }
                        return;
                    }
                    this.updateOtherDataCenterNodes((DataCenterNodes<DataNode>)getDataCenterNodes);
                    continue;
                }
                LOGGER.error("Get DataCenter data nodes change error!null");
                throw new RuntimeException("Get null DataCenter data nodes change!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOtherDataCenterNodes(DataCenterNodes<DataNode> dataCenterNodes) {
        this.write.lock();
        try {
            String dataCenter = dataCenterNodes.getDataCenterId();
            Long version = dataCenterNodes.getVersion();
            if (version == null) {
                LOGGER.error("Request message version cant not be null!");
                return;
            }
            Map dataCenterNodesMap = dataCenterNodes.getNodes();
            LOGGER.info("update version {} Other DataCenter {} Nodes {}", new Object[]{version, dataCenter, dataCenterNodesMap});
            ConcurrentHashMap dataCenterNodesMapTemp = new ConcurrentHashMap();
            dataCenterNodesMap.forEach((ipAddress, dataNode) -> dataCenterNodesMapTemp.put(ipAddress, new RenewDecorate<DataNode>((DataNode)dataNode, 15L)));
            this.dataRepositoryService.replaceAll(dataCenter, dataCenterNodesMapTemp, version);
            if (version.longValue() == this.localDataCenterInitVersion.get()) {
                LOGGER.info("DataCenter {} first start up,No data node change to notify!Init version {}", (Object)dataCenter, (Object)version);
                return;
            }
            NodeChangeResult nodeChangeResult = this.getNodeChangeResult();
            this.firePushDataListTask(null, nodeChangeResult, null, false);
            this.firePushSessionListTask(nodeChangeResult, "OtherDataCenterUpdate");
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataCenterNodes getDataCenterNodes() {
        this.read.lock();
        try {
            String localDataCenter = this.nodeConfig.getLocalDataCenter();
            Map<String, NodeRepository> dataNodeRepositoryMap = this.dataRepositoryService.getNodeRepositories();
            NodeRepository dataNodeRepository = dataNodeRepositoryMap.get(localDataCenter);
            if (dataNodeRepository == null) {
                DataCenterNodes dataCenterNodes = new DataCenterNodes(Node.NodeType.DATA, Long.valueOf(this.localDataCenterInitVersion.get()), localDataCenter);
                dataCenterNodes.setNodes(new ConcurrentHashMap());
                DataCenterNodes dataCenterNodes2 = dataCenterNodes;
                return dataCenterNodes2;
            }
            DataCenterNodes dataCenterNodes = new DataCenterNodes(Node.NodeType.DATA, dataNodeRepository.getVersion(), localDataCenter);
            Map dataMap = dataNodeRepository.getNodeMap();
            ConcurrentHashMap newMap = new ConcurrentHashMap();
            dataMap.forEach((ip, dataNode) -> {
                DataNode cfr_ignored_0 = (DataNode)newMap.put(ip, dataNode.getRenewal());
            });
            dataCenterNodes.setNodes(newMap);
            DataCenterNodes dataCenterNodes3 = dataCenterNodes;
            return dataCenterNodes3;
        }
        finally {
            this.read.unlock();
        }
    }

    public void setNodeConfig(NodeConfig nodeConfig) {
        this.nodeConfig = nodeConfig;
    }

    public void setTaskListenerManager(TaskListenerManager taskListenerManager) {
        this.taskListenerManager = taskListenerManager;
    }

    public void setDataRepositoryService(RepositoryService<String, RenewDecorate<DataNode>> dataRepositoryService) {
        this.dataRepositoryService = dataRepositoryService;
    }

    public void setDataConfirmStatusService(NodeConfirmStatusService<DataNode> dataConfirmStatusService) {
        this.dataConfirmStatusService = dataConfirmStatusService;
    }
}

