/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot;

import com.alipay.sofa.infra.log.space.SofaBootLogSpaceIsolationInit;
import com.alipay.sofa.rpc.boot.common.SofaBootRpcRuntimeException;
import com.alipay.sofa.rpc.boot.container.SpringBridge;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class SofaBootRpcInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        SpringBridge.setApplicationContext((ApplicationContext)applicationContext);
        this.checkAppName(applicationContext.getEnvironment().getProperty("spring.application.name"));
        this.initStarterLog((Environment)applicationContext.getEnvironment());
        this.initRpcCoreLog((Environment)applicationContext.getEnvironment());
    }

    private void checkAppName(String appName) {
        if (!StringUtils.hasText((String)appName)) {
            throw new SofaBootRpcRuntimeException("Please add 'spring.application.name' in application.properties");
        }
    }

    private void initStarterLog(Environment environment) {
        String logLevelKey = "logging.level.com.alipay.sofa.rpc.boot";
        SofaBootLogSpaceIsolationInit.initSofaBootLogger((Environment)environment, (String)logLevelKey);
    }

    private void initRpcCoreLog(Environment environment) {
        String logLevelKey = "logging.level.com.alipay.sofa.rpc";
        SofaBootLogSpaceIsolationInit.initSofaBootLogger((Environment)environment, (String)logLevelKey);
    }
}

