/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.health;

import com.alipay.sofa.boot.actuator.health.HealthCheckException;
import com.alipay.sofa.boot.actuator.health.HealthCheckerProcessor;
import com.alipay.sofa.boot.actuator.health.HealthIndicatorProcessor;
import com.alipay.sofa.boot.actuator.health.ReadinessCheckCallbackProcessor;
import com.alipay.sofa.boot.log.ErrorCode;
import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.boot.startup.BaseStat;
import com.alipay.sofa.boot.startup.ChildrenStat;
import com.alipay.sofa.boot.startup.StartupReporter;
import com.alipay.sofa.boot.startup.StartupReporterAware;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.boot.availability.AvailabilityChangeEvent;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.boot.availability.ReadinessState;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public class ReadinessCheckListener
implements ApplicationContextAware,
Ordered,
GenericApplicationListener,
StartupReporterAware {
    private static final Logger logger = SofaBootLoggerFactory.getLogger(ReadinessCheckListener.class);
    public static final String READINESS_CHECK_STAGE = "ReadinessCheckStage";
    public static final String READINESS_HEALTH_CHECK_EXECUTOR_BEAN_NAME = "readinessHealthCheckExecutor";
    public static final String HEALTH_CHECK_NOT_READY_KEY = "HEALTH-CHECK-NOT-READY";
    public static final String HEALTH_CHECK_NOT_READY_MSG = "App is still in startup process, please try later!";
    private final HealthCheckerProcessor healthCheckerProcessor;
    private final HealthIndicatorProcessor healthIndicatorProcessor;
    private final ReadinessCheckCallbackProcessor readinessCheckCallbackProcessor;
    private boolean healthCheckerStatus = true;
    private final Map<String, Health> healthCheckerDetails = new ConcurrentHashMap<String, Health>();
    private boolean healthIndicatorStatus = true;
    private final Map<String, Health> healthIndicatorDetails = new ConcurrentHashMap<String, Health>();
    private boolean healthCallbackStatus = true;
    private final Map<String, Health> healthCallbackDetails = new ConcurrentHashMap<String, Health>();
    private final AtomicBoolean readinessCallbackTriggered = new AtomicBoolean(false);
    private boolean readinessCheckFinish = false;
    private ReadinessState readinessState;
    private ApplicationContext applicationContext;
    private StartupReporter startupReporter;
    private boolean skipAll = false;
    private boolean skipHealthChecker = false;
    private boolean skipHealthIndicator = false;
    private boolean manualReadinessCallback = false;
    private boolean throwExceptionWhenHealthCheckFailed = false;
    private ExecutorService executorService;

    public ReadinessCheckListener(HealthCheckerProcessor healthCheckerProcessor, HealthIndicatorProcessor healthIndicatorProcessor, ReadinessCheckCallbackProcessor afterReadinessCheckCallbackProcessor) {
        this.healthCheckerProcessor = healthCheckerProcessor;
        this.healthIndicatorProcessor = healthIndicatorProcessor;
        this.readinessCheckCallbackProcessor = afterReadinessCheckCallbackProcessor;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setStartupReporter(StartupReporter startupReporter) throws BeansException {
        this.startupReporter = startupReporter;
    }

    public boolean supportsEventType(ResolvableType eventType) {
        Class eventClass = eventType.getRawClass();
        if (eventClass == null) {
            return false;
        }
        return ContextRefreshedEvent.class.isAssignableFrom(eventClass) || AvailabilityChangeEvent.class.isAssignableFrom(eventClass);
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.onContextRefreshedEvent((ContextRefreshedEvent)event);
        } else if (event instanceof AvailabilityChangeEvent) {
            this.onAvailabilityChangeEvent((AvailabilityChangeEvent)event);
        }
    }

    public void onContextRefreshedEvent(ContextRefreshedEvent event) {
        if (this.applicationContext.equals(event.getApplicationContext())) {
            this.healthCheckerProcessor.init();
            this.healthIndicatorProcessor.init();
            this.readinessCheckCallbackProcessor.init();
            ChildrenStat stat = new ChildrenStat();
            stat.setName(READINESS_CHECK_STAGE);
            stat.setStartTime(System.currentTimeMillis());
            this.readinessHealthCheck();
            stat.setEndTime(System.currentTimeMillis());
            ArrayList<BaseStat> baseStatList = new ArrayList<BaseStat>();
            List<BaseStat> healthCheckerStats = this.healthCheckerProcessor.getHealthCheckerStartupStatList();
            baseStatList.addAll(healthCheckerStats);
            healthCheckerStats.clear();
            List<BaseStat> healthIndicatorStats = this.healthIndicatorProcessor.getHealthIndicatorStartupStatList();
            baseStatList.addAll(healthIndicatorStats);
            healthIndicatorStats.clear();
            List<BaseStat> readinessCheckCallbackStartupStats = this.readinessCheckCallbackProcessor.getReadinessCheckCallbackStartupStatList();
            baseStatList.addAll(readinessCheckCallbackStartupStats);
            readinessCheckCallbackStartupStats.clear();
            stat.setChildren(baseStatList);
            if (this.startupReporter != null) {
                this.startupReporter.addCommonStartupStat((BaseStat)stat);
            }
            this.executorService.shutdown();
        }
    }

    public void onAvailabilityChangeEvent(AvailabilityChangeEvent<?> event) {
        Object payload;
        if (this.isReadinessCheckFinish() && (payload = event.getPayload()) instanceof ReadinessState && payload != this.readinessState) {
            if (this.readinessState == null) {
                AvailabilityChangeEvent.publish((ApplicationContext)this.applicationContext, (AvailabilityState)ReadinessState.REFUSING_TRAFFIC);
            } else {
                AvailabilityChangeEvent.publish((ApplicationContext)this.applicationContext, (AvailabilityState)this.readinessState);
            }
        }
    }

    public void readinessHealthCheck() {
        Assert.notNull((Object)this.applicationContext, () -> "Application must not be null");
        if (this.isSkipAll()) {
            logger.warn("Skip all readiness health check.");
        } else {
            if (this.isSkipHealthChecker()) {
                logger.warn("Skip HealthChecker health check.");
            } else {
                this.healthCheckerStatus = this.healthCheckerProcessor.readinessHealthCheck(this.healthCheckerDetails);
            }
            if (this.isSkipHealthIndicator()) {
                logger.warn("Skip HealthIndicator health check.");
            } else {
                this.healthIndicatorStatus = this.healthIndicatorProcessor.readinessHealthCheck(this.healthIndicatorDetails);
            }
        }
        if (this.manualReadinessCallback) {
            logger.info("Manual readiness callback is set to true, skip normal readiness callback. You can trigger all readiness callbacks through URL: actuator/triggerReadinessCallback");
        } else if (this.healthCheckerStatus && this.healthIndicatorStatus) {
            this.readinessCallbackTriggered.set(true);
            logger.info("Invoking all readiness check callbacks...");
            this.healthCallbackStatus = this.readinessCheckCallbackProcessor.readinessCheckCallback(this.healthCallbackDetails);
        }
        this.determineReadinessState();
        this.readinessCheckFinish = true;
    }

    public ManualReadinessCallbackResult triggerReadinessCallback() {
        if (this.healthCheckerStatus && this.healthIndicatorStatus) {
            if (this.readinessCallbackTriggered.compareAndSet(false, true)) {
                logger.info("Invoking all readiness callbacks...");
                this.healthCallbackStatus = this.readinessCheckCallbackProcessor.readinessCheckCallback(this.healthCallbackDetails);
                this.determineReadinessState();
                return new ManualReadinessCallbackResult(true, "Readiness callbacks invoked successfully with result: " + this.healthCallbackStatus);
            }
            logger.warn("Readiness callbacks are already triggered! Action skipped.");
            return ManualReadinessCallbackResult.SKIPPED;
        }
        logger.warn("Health checker or indicator failed, skip all readiness callbacks!");
        return ManualReadinessCallbackResult.STAGE_ONE_FAILED;
    }

    private void determineReadinessState() {
        if (this.healthCheckerStatus && this.healthIndicatorStatus && this.healthCallbackStatus) {
            this.readinessState = ReadinessState.ACCEPTING_TRAFFIC;
            logger.info("Readiness check result: success");
        } else {
            this.readinessState = ReadinessState.REFUSING_TRAFFIC;
            logger.error(ErrorCode.convert((String)"01-20000"));
            if (this.throwExceptionWhenHealthCheckFailed) {
                throw new HealthCheckException("Application health check is failed and health check insulator switch is turned on!");
            }
        }
        AvailabilityChangeEvent.publish((ApplicationContext)this.applicationContext, (AvailabilityState)this.readinessState);
    }

    public Health aggregateReadinessHealth() {
        if (!this.isReadinessCheckFinish()) {
            return Health.unknown().withDetail(HEALTH_CHECK_NOT_READY_KEY, (Object)HEALTH_CHECK_NOT_READY_MSG).build();
        }
        HashMap<String, Health> healths = new HashMap<String, Health>();
        boolean healthCheckerStatus = this.getHealthCheckerStatus();
        Health healthCheckerResult = healthCheckerStatus ? Health.up().withDetails(this.getHealthCheckerDetails()).build() : Health.down().withDetails(this.getHealthCheckerDetails()).build();
        healths.put("HealthCheckerInfo", healthCheckerResult);
        boolean healthIndicatorStatus = this.getHealthIndicatorStatus();
        Health healthIndicatorResult = healthIndicatorStatus ? Health.up().withDetails(this.getHealthIndicatorDetails()).build() : Health.down().withDetails(this.getHealthIndicatorDetails()).build();
        healths.put("HealthIndicatorInfo", healthIndicatorResult);
        boolean healthCallBackStatus = this.getHealthCallbackStatus();
        Health healthCallBackResult = healthCallBackStatus ? Health.up().withDetails(this.getHealthCallbackDetails()).build() : Health.down().withDetails(this.getHealthCheckerDetails()).build();
        healths.put("HealthCallBackInfo", healthCallBackResult);
        Status overallStatus = StatusAggregator.getDefault().getAggregateStatus(healths.values().stream().map(Health::getStatus).collect(Collectors.toSet()));
        return new Health.Builder(overallStatus, healths).build();
    }

    public boolean getHealthCheckerStatus() {
        return this.healthCheckerStatus;
    }

    public Map<String, Health> getHealthCheckerDetails() {
        return this.healthCheckerDetails;
    }

    public boolean getHealthIndicatorStatus() {
        return this.healthIndicatorStatus;
    }

    public Map<String, Health> getHealthIndicatorDetails() {
        return this.healthIndicatorDetails;
    }

    public boolean getHealthCallbackStatus() {
        return this.healthCallbackStatus;
    }

    public Map<String, Health> getHealthCallbackDetails() {
        return this.healthCallbackDetails;
    }

    public boolean isReadinessCheckFinish() {
        return this.readinessCheckFinish;
    }

    public AtomicBoolean getReadinessCallbackTriggered() {
        return this.readinessCallbackTriggered;
    }

    public boolean isSkipAll() {
        return this.skipAll;
    }

    public void setSkipAll(boolean skipAll) {
        this.skipAll = skipAll;
    }

    public boolean isSkipHealthChecker() {
        return this.skipHealthChecker;
    }

    public void setSkipHealthChecker(boolean skipHealthChecker) {
        this.skipHealthChecker = skipHealthChecker;
    }

    public boolean isSkipHealthIndicator() {
        return this.skipHealthIndicator;
    }

    public void setSkipHealthIndicator(boolean skipHealthIndicator) {
        this.skipHealthIndicator = skipHealthIndicator;
    }

    public boolean isManualReadinessCallback() {
        return this.manualReadinessCallback;
    }

    public void setManualReadinessCallback(boolean manualReadinessCallback) {
        this.manualReadinessCallback = manualReadinessCallback;
    }

    public boolean isThrowExceptionWhenHealthCheckFailed() {
        return this.throwExceptionWhenHealthCheckFailed;
    }

    public void setThrowExceptionWhenHealthCheckFailed(boolean throwExceptionWhenHealthCheckFailed) {
        this.throwExceptionWhenHealthCheckFailed = throwExceptionWhenHealthCheckFailed;
    }

    public boolean isHealthCheckerStatus() {
        return this.healthCheckerStatus;
    }

    public boolean isHealthIndicatorStatus() {
        return this.healthIndicatorStatus;
    }

    public boolean isHealthCallbackStatus() {
        return this.healthCallbackStatus;
    }

    public ReadinessState getReadinessState() {
        return this.readinessState;
    }

    public void setHealthCheckExecutor(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public static class ManualReadinessCallbackResult {
        public static ManualReadinessCallbackResult STAGE_ONE_FAILED = new ManualReadinessCallbackResult(false, "Health checker or indicator failed.");
        public static ManualReadinessCallbackResult SKIPPED = new ManualReadinessCallbackResult(false, "Readiness callbacks are already triggered.");
        private boolean success;
        private String details;

        public ManualReadinessCallbackResult() {
        }

        public ManualReadinessCallbackResult(boolean success, String details) {
            this.success = success;
            this.details = details;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getDetails() {
            return this.details;
        }

        public void setDetails(String details) {
            this.details = details;
        }
    }
}

