/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.threadpool;

import com.alipay.sofa.common.thread.ThreadPoolConfig;
import com.alipay.sofa.common.thread.ThreadPoolGovernor;
import com.alipay.sofa.common.thread.ThreadPoolMonitorWrapper;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="threadpool")
public class ThreadPoolEndpoint {
    private final ThreadPoolGovernor threadPoolGovernor;

    public ThreadPoolEndpoint(ThreadPoolGovernor threadPoolGovernor) {
        this.threadPoolGovernor = threadPoolGovernor;
    }

    @ReadOperation
    public ThreadPoolsDescriptor threadPools() {
        Collection threadPoolWrappers = this.threadPoolGovernor.getAllThreadPoolWrappers();
        List<ThreadPoolInfo> threadPoolInfoList = threadPoolWrappers.stream().map(this::convertToThreadPoolInfo).toList();
        return new ThreadPoolsDescriptor(threadPoolInfoList);
    }

    private ThreadPoolInfo convertToThreadPoolInfo(ThreadPoolMonitorWrapper wrapper) {
        ThreadPoolConfig threadPoolConfig = wrapper.getThreadPoolConfig();
        String threadPoolName = threadPoolConfig.getThreadPoolName();
        String spaceName = threadPoolConfig.getSpaceName();
        long period = threadPoolConfig.getPeriod();
        long taskTimeout = threadPoolConfig.getTaskTimeoutMilli();
        ThreadPoolExecutor threadPoolExecutor = wrapper.getThreadPoolExecutor();
        String threadPoolClassName = threadPoolExecutor.getClass().getName();
        int coreSize = threadPoolExecutor.getCorePoolSize();
        int maxSize = threadPoolExecutor.getMaximumPoolSize();
        int queueSize = threadPoolExecutor.getQueue().size();
        int queueRemainingCapacity = threadPoolExecutor.getQueue().remainingCapacity();
        String queueClassName = threadPoolExecutor.getQueue().getClass().getName();
        return new ThreadPoolInfo(threadPoolName, spaceName, threadPoolClassName, coreSize, maxSize, queueClassName, queueSize, queueRemainingCapacity, period, taskTimeout);
    }

    public record ThreadPoolsDescriptor(List<ThreadPoolInfo> threadPoolInfoList) implements OperationResponseBody
    {
    }

    public record ThreadPoolInfo(String threadPoolName, String spaceName, String threadPoolClassName, int coreSize, int maxSize, String queueClassName, int queueSize, int queueRemainingCapacity, long monitorPeriod, long taskTimeout) {
    }
}

