/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.httpclient;

import com.alipay.common.tracer.core.appender.builder.JsonStringBuilder;
import com.alipay.common.tracer.core.appender.file.LoadTestAwareAppender;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.appender.self.Timestamp;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.reporter.stat.model.StatMapKey;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.TracerUtils;
import java.util.Map;

public class HttpClientStatJsonReporter
extends AbstractSofaTracerStatisticReporter {
    private static JsonStringBuilder jsonBuffer = new JsonStringBuilder();

    public HttpClientStatJsonReporter(String statTracerName, String rollingPolicy, String logReserveConfig) {
        super(statTracerName, rollingPolicy, logReserveConfig);
    }

    public void doReportStat(SofaTracerSpan sofaTracerSpan) {
        Map tagsWithStr = sofaTracerSpan.getTagsWithStr();
        StatMapKey statKey = new StatMapKey();
        statKey.addKey("local.app", (String)tagsWithStr.get("local.app"));
        statKey.addKey("request.url", (String)tagsWithStr.get("request.url"));
        statKey.addKey("method", (String)tagsWithStr.get("method"));
        statKey.setLoadTest(TracerUtils.isLoadTest((SofaTracerSpan)sofaTracerSpan));
        String resultCode = (String)tagsWithStr.get("result.code");
        boolean success = resultCode != null && resultCode.length() > 0 && this.isHttpOrMvcSuccess(resultCode);
        statKey.setResult(success ? "true" : "false");
        statKey.setEnd(TracerUtils.getLoadTestMark((SofaTracerSpan)sofaTracerSpan));
        long duration = sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime();
        long[] values = new long[]{1L, duration};
        this.addStat((StatKey)statKey, values);
    }

    public void print(StatKey statKey, long[] values) {
        if (this.isClosePrint.get()) {
            return;
        }
        if (!(statKey instanceof StatMapKey)) {
            return;
        }
        StatMapKey statMapKey = (StatMapKey)statKey;
        try {
            jsonBuffer.reset();
            jsonBuffer.appendBegin();
            jsonBuffer.append("time", (Object)Timestamp.currentTime());
            jsonBuffer.append("stat.key", (Object)this.statKeySplit(statMapKey));
            jsonBuffer.append("count", (Object)values[0]);
            jsonBuffer.append("total.cost.milliseconds", (Object)values[1]);
            jsonBuffer.append("success", (Object)statMapKey.getResult());
            jsonBuffer.appendEnd("load.test", (Object)statMapKey.getEnd());
            if (this.appender instanceof LoadTestAwareAppender) {
                ((LoadTestAwareAppender)this.appender).append(jsonBuffer.toString(), statMapKey.isLoadTest());
            } else {
                this.appender.append(jsonBuffer.toString());
            }
            this.appender.flush();
        }
        catch (Throwable t) {
            SelfLog.error((String)("Stat log <" + this.statTracerName + "> error!"), (Throwable)t);
        }
    }

    private String statKeySplit(StatMapKey statKey) {
        JsonStringBuilder jsonBufferKey = new JsonStringBuilder();
        Map keyMap = statKey.getKeyMap();
        jsonBufferKey.appendBegin();
        for (Map.Entry entry : keyMap.entrySet()) {
            jsonBufferKey.append((String)entry.getKey(), entry.getValue());
        }
        jsonBufferKey.appendEnd(false);
        return jsonBufferKey.toString();
    }
}

