/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.httpclient;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractClientTracer;
import com.alipay.sofa.tracer.plugins.httpclient.HttpClientDigestJsonEncoder;
import com.alipay.sofa.tracer.plugins.httpclient.HttpClientLogEnum;
import com.alipay.sofa.tracer.plugins.httpclient.HttpClientStatJsonReporter;

public class HttpClientTracer
extends AbstractClientTracer {
    private static volatile HttpClientTracer httpClientTracer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpClientTracer getHttpClientTracerSingleton() {
        if (httpClientTracer != null) return httpClientTracer;
        Class<HttpClientTracer> clazz = HttpClientTracer.class;
        synchronized (HttpClientTracer.class) {
            if (httpClientTracer != null) return httpClientTracer;
            httpClientTracer = new HttpClientTracer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClientTracer;
        }
    }

    protected HttpClientTracer() {
        super("httpclient");
    }

    protected String getClientDigestReporterLogName() {
        return HttpClientLogEnum.HTTP_CLIENT_DIGEST.getDefaultLogName();
    }

    protected String getClientDigestReporterRollingKey() {
        return HttpClientLogEnum.HTTP_CLIENT_DIGEST.getRollingKey();
    }

    protected String getClientDigestReporterLogNameKey() {
        return HttpClientLogEnum.HTTP_CLIENT_DIGEST.getLogNameKey();
    }

    protected SpanEncoder<SofaTracerSpan> getClientDigestEncoder() {
        return new HttpClientDigestJsonEncoder();
    }

    protected AbstractSofaTracerStatisticReporter generateClientStatReporter() {
        HttpClientLogEnum httpClientLogEnum = HttpClientLogEnum.HTTP_CLIENT_STAT;
        String statLog = httpClientLogEnum.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)httpClientLogEnum.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)httpClientLogEnum.getLogNameKey());
        return this.getHttpClientStatReporter(statLog, statRollingPolicy, statLogReserveConfig);
    }

    protected AbstractSofaTracerStatisticReporter getHttpClientStatReporter(String statTracerName, String statRollingPolicy, String statLogReserveConfig) {
        return new HttpClientStatJsonReporter(statTracerName, statRollingPolicy, statLogReserveConfig);
    }
}

