/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.httpclient.interceptor;

import com.alipay.common.tracer.core.SofaTracer;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.registry.ExtendFormat;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractTracer;
import com.alipay.sofa.tracer.plugins.httpclient.HttpClientRequestCarrier;
import io.opentracing.SpanContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.HttpRequestWrapper;

public abstract class AbstractHttpRequestInterceptor {
    protected static final String CURRENT_ASYNC_HTTP_SPAN_KEY = "httpclient.async.span.key";
    protected AbstractTracer httpClientTracer;
    protected String appName = null;
    protected String targetAppName = null;

    public AbstractHttpRequestInterceptor(AbstractTracer httpClientTracer, String appName, String targetAppName) {
        this.httpClientTracer = httpClientTracer;
        this.appName = appName;
        this.targetAppName = targetAppName;
    }

    public void appendHttpClientRequestSpanTags(HttpRequest httpRequest, SofaTracerSpan httpClientSpan) {
        if (httpClientSpan == null) {
            return;
        }
        if (this.appName == null) {
            this.appName = SofaTracerConfiguration.getProperty((String)"spring.application.name", (String)"");
        }
        RequestLine requestLine = httpRequest.getRequestLine();
        String methodName = requestLine.getMethod();
        httpClientSpan.setTag("local.app", this.appName == null ? "" : this.appName);
        httpClientSpan.setTag("remote.app", this.targetAppName == null ? "" : this.targetAppName);
        if (httpRequest instanceof HttpRequestWrapper) {
            HttpRequestWrapper httpRequestWrapper = (HttpRequestWrapper)httpRequest;
            httpClientSpan.setTag("request.url", httpRequestWrapper.getOriginal().getRequestLine().getUri());
        } else {
            httpClientSpan.setTag("request.url", requestLine.getUri());
        }
        httpClientSpan.setTag("method", methodName);
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)httpRequest;
            HttpEntity httpEntity = httpEntityEnclosingRequest.getEntity();
            httpClientSpan.setTag("req.size.bytes", (Number)(httpEntity == null ? -1L : httpEntity.getContentLength()));
        }
        this.processHttpClientRequestCarrier(httpRequest, httpClientSpan);
    }

    public void appendHttpClientResponseSpanTags(HttpResponse httpResponse, SofaTracerSpan httpClientSpan) {
        if (httpClientSpan != null) {
            HttpEntity httpEntity = httpResponse.getEntity();
            long contentLength = httpEntity == null ? -1L : httpEntity.getContentLength();
            httpClientSpan.setTag("resp.size.bytes", (Number)contentLength);
            httpClientSpan.setTag("current.thread.name", Thread.currentThread().getName());
        }
    }

    public void processHttpClientRequestCarrier(HttpRequest httpRequest, SofaTracerSpan currentSpan) {
        SofaTracer sofaTracer = this.httpClientTracer.getSofaTracer();
        sofaTracer.inject((SpanContext)currentSpan.getSofaTracerSpanContext(), ExtendFormat.Builtin.B3_HTTP_HEADERS, (Object)new HttpClientRequestCarrier(httpRequest));
    }
}

