/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ocr_api20210707.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.io.InputStream;
import java.util.List;

public class RecognizeGeneralStructureRequest
extends Request {
    @Query
    @NameInMap(value="Keys")
    private List<String> keys;
    @Query
    @NameInMap(value="Url")
    @Validation(maxLength=2048)
    private String url;
    @Body
    @NameInMap(value="body")
    private InputStream body;

    private RecognizeGeneralStructureRequest(Builder builder) {
        super((Request.Builder)builder);
        this.keys = builder.keys;
        this.url = builder.url;
        this.body = builder.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RecognizeGeneralStructureRequest create() {
        return RecognizeGeneralStructureRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public String getUrl() {
        return this.url;
    }

    public InputStream getBody() {
        return this.body;
    }

    public static final class Builder
    extends Request.Builder<RecognizeGeneralStructureRequest, Builder> {
        private List<String> keys;
        private String url;
        private InputStream body;

        private Builder() {
        }

        private Builder(RecognizeGeneralStructureRequest request) {
            super((Request)request);
            this.keys = request.keys;
            this.url = request.url;
            this.body = request.body;
        }

        public Builder keys(List<String> keys) {
            String keysShrink = this.shrink(keys, "Keys", "simple");
            this.putQueryParameter("Keys", keysShrink);
            this.keys = keys;
            return this;
        }

        public Builder url(String url) {
            this.putQueryParameter("Url", url);
            this.url = url;
            return this;
        }

        public Builder body(InputStream body) {
            this.putBodyParameter("body", body);
            this.body = body;
            return this;
        }

        public RecognizeGeneralStructureRequest build() {
            return new RecognizeGeneralStructureRequest(this);
        }
    }
}

