/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.alink.linksdk.cmp.core.base;

import com.aliyun.alink.linksdk.cmp.core.base.AConnectConfig;
import com.aliyun.alink.linksdk.cmp.core.base.AConnectInfo;
import com.aliyun.alink.linksdk.cmp.core.base.AConnectOption;
import com.aliyun.alink.linksdk.cmp.core.base.ARequest;
import com.aliyun.alink.linksdk.cmp.core.base.CmpError;
import com.aliyun.alink.linksdk.cmp.core.base.ConnectState;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectInitListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectNotifyListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectRrpcListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectSendListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectSubscribeListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectUnscribeListener;

public abstract class AConnect {
    protected String connectId = null;
    protected ConnectState connectState;
    protected AConnectOption connectOption;
    protected AConnectInfo connectInfo;
    protected IConnectNotifyListener notifyListener;

    public String getConnectId() {
        return this.connectId;
    }

    public void setConnectId(String connectId) {
        this.connectId = connectId;
    }

    public ConnectState getConnectState() {
        return this.connectState;
    }

    public void updateConnectState(ConnectState state) {
        this.connectState = state;
        if (this.notifyListener != null) {
            this.notifyListener.onConnectStateChange(this.connectId, this.connectState);
        }
    }

    public abstract void init(AConnectConfig var1, IConnectInitListener var2);

    public void updateConnectOption(AConnectOption option) {
        this.connectOption = option;
    }

    public AConnectInfo getConnectInfo() {
        return this.connectInfo;
    }

    public abstract void onDestroy();

    public abstract void send(ARequest var1, IConnectSendListener var2);

    public abstract void subscribe(ARequest var1, IConnectSubscribeListener var2);

    public abstract void unsubscribe(ARequest var1, IConnectUnscribeListener var2);

    @Deprecated
    public void subscribeRrpc(ARequest request, IConnectRrpcListener rrpcListener) {
        if (rrpcListener != null) {
            rrpcListener.onSubscribeFailed(request, CmpError.PARAMS_ERROR());
        }
    }

    public void setNotifyListener(IConnectNotifyListener notifyListener) {
        this.notifyListener = notifyListener;
    }
}

