/*
 * longpeng.zlp<longpeng.zlp@alibaba-inc.com>
 * This is implementation of DRCNET java client.
 * 
 */
package alibaba.drcnet.buffer;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import alibaba.drcnet.config.DRCNetConfig;
import alibaba.drcnet.util.MessageBox;

public class CacheBuff {
	
	private static final Logger log = LoggerFactory.getLogger(CacheBuff.class);
	
	public enum BufStatus {
		AVAILABLE,
		WORKING,
		FULL,
	};

	public class BatchBuf {
		
		public Lock lock = null;
		
		public Condition cond = null;
		
		public int totalLen = 0;
		
		public volatile int leftLen = 0;
		public volatile int readPos = 0;
		public volatile int writePos = 0;
		public byte[] buff = null;
		public volatile BufStatus bufStat = BufStatus.AVAILABLE;

		void init(int length) {
			lock = new ReentrantLock();
			cond = lock.newCondition();
			totalLen = length;
			leftLen = length;
			readPos = 0;
			writePos = 0;
			log.warn("cache buf size is: " + length);
			buff = new byte[length];
			bufStat = BufStatus.AVAILABLE;
		}
		
		void reinitBatchBuf() {
			leftLen = totalLen;
			readPos = 0;
			writePos = 0;
			bufStat = BufStatus.AVAILABLE;
		}
		
	}
	public CacheBuff(MessageBox msgBox) {
		messageBox = msgBox;
	}
	BatchBuf[] cacheBuf = null;
	
	public BatchBuf  writeBuf = null;
	public BatchBuf readBuf = null;
	
	int readIndex = 0;
	int writeIndex = 0;
	MessageBox messageBox = null;
	private volatile boolean stoped = false;
	
	public void setStop() {
		stoped = true;
	}
	
	public void initBuf(int length) {
		cacheBuf = new BatchBuf[2];
		cacheBuf[0] = new BatchBuf();
		cacheBuf[0].init(length);
		cacheBuf[1] = new BatchBuf(); 
		cacheBuf[1].init(length);
		writeBuf = cacheBuf[0];
		readBuf = cacheBuf[0];
		
		readIndex = 0;
		writeIndex = 0;
		
		stoped = false;
	}
	
	static final int waitSlot = 1000000;  //ns
	
	public int detectWriteable(int len) {
		if(stoped == true) {
			return -1;
		}
		if(writeBuf.leftLen >= len) {
			return writeBuf.writePos;
		} else {
//			System.out.println("write buf is going to switch, old index:" + writeIndex);
			writeBuf.bufStat = BufStatus.FULL;
			int nextBufIndex = writeIndex ^ 1;
			while(true) {
				if(stoped == true) {
					return -1;
				}
				messageBox.Signal();
				//TODO:使用wait代替 while waitNanos
				cacheBuf[nextBufIndex].lock.lock();
				if(cacheBuf[nextBufIndex].bufStat != BufStatus.AVAILABLE) {
					try {
						cacheBuf[nextBufIndex].cond.awaitNanos(waitSlot);
					} catch (InterruptedException e) {
					}
					cacheBuf[nextBufIndex].lock.unlock();
				} else {
					cacheBuf[nextBufIndex].bufStat = BufStatus.WORKING;
					cacheBuf[nextBufIndex].lock.unlock();
					break;
				}
			}
			writeBuf = cacheBuf[nextBufIndex];
			cacheBuf[writeIndex].lock.lock();
			cacheBuf[writeIndex].cond.signal();
			cacheBuf[writeIndex].lock.unlock();
			writeIndex = nextBufIndex;
//			System.out.println("write buf has switched, new index:" + writeIndex);
			return writeBuf.writePos;
		}
	}
	
	public void putData(int len) {
		writeBuf.writePos += len;
		writeBuf.leftLen -= len;
		messageBox.Signal();
	}
	
	public int readData(byte[] buf, int len) {
		while(true) {

			int leftData = readBuf.writePos - readBuf.readPos;
			if(leftData >= len) {
				System.arraycopy(readBuf.buff, readBuf.readPos, buf, 0, len);
				readBuf.readPos += len;
				return len;
			} else {
				if(leftData != 0) {
//					System.out.println("wrong ceck");
					return -1;
				} else {
//					System.out.println("readbuf going to siwtch " + readBuf.writePos + ":" + readBuf.readPos);
					if(readBuf.bufStat == BufStatus.FULL && readBuf.writePos == readBuf.readPos) {
//						System.out.println("read buf going to changed");
						readBuf.lock.lock();
						readBuf.reinitBatchBuf();
						readBuf.lock.unlock();
						int nextIndex = readIndex ^ 1;
						while(true) {
							if(stoped) {
								return -1;
							}
							cacheBuf[nextIndex].lock.lock();
							if(cacheBuf[nextIndex].bufStat == BufStatus.AVAILABLE) {
								try {
									cacheBuf[nextIndex].cond.awaitNanos(waitSlot);
								} catch (InterruptedException e) {
								}
								cacheBuf[nextIndex].lock.unlock();
							} else {
								readBuf = cacheBuf[nextIndex];
								cacheBuf[nextIndex].lock.unlock();
								break;
							}			
						}
						cacheBuf[readIndex].lock.lock();
						cacheBuf[readIndex].cond.signal();
						cacheBuf[readIndex].lock.unlock();
						readIndex = nextIndex;
//						System.out.println("read buf changed");
						continue;
					} else {
						return 0;
					}
				}
			}
		}
	}
	
	
}


