package alibaba.drcnet.buffer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * 单个buffer用来存取固定的长度的数据，就是对buf， offset，和leftlen的简单封装
 */
public class TempBuf {
	private static final Logger log = LoggerFactory.getLogger(TempBuf.class);
	public byte[] recvDataBuffer = null;
	public int currentWriteIndex = 0;
	public int bufLen = 0;
	public int leftDataLen = 0;
	
	public TempBuf() {
	}
	public int initTempBuf(int bufferLen) {
		bufLen = bufferLen;
		leftDataLen = bufLen;
		recvDataBuffer = new byte[bufLen];
		if(recvDataBuffer == null) {
			log.error("get meme failed");
			return -1;
		}
		currentWriteIndex = 0;
		return 0;
	} 
	public void moveIndex(int len) {
		leftDataLen -= len;
		currentWriteIndex += len;
	}
	public void reiniSingleRecvBuf() {
		currentWriteIndex = 0;
		leftDataLen = bufLen;
	}
	
}
