/*
 * longpeng.zlp<longpeng.zlp@alibaba-inc.com>
 * This is implementation of DRCNET java client.
 * 
 */
package alibaba.drcnet.connection;
import alibaba.drcnet.config.DRCNetConfig;
import alibaba.drcnet.config.UserConfig;
import alibaba.drcnet.util.DRCNetMessageInfo;
import alibaba.drcnet.util.MessageBox;
import alibaba.drcnet.util.SyncState;

public interface Connection {
	public static final int SINGLECONN = 4;
	public static final int MULTICONN = 5;
	
	public int writeData(DRCNetMessageInfo msgInfo);
	public int readData(DRCNetMessageInfo msgInfo, boolean usingMessageId);
	/**
	 * 启动连接
	 * @param ip  server ip
	 * @param port server port
	 * @param userConfig 用户要发送的数据
	 * @param netConfig  drcnet的config，当使用加密模式的时候需要特殊设置一些内容
	 * @param state      连接握手的信息
	 * @param ConnectionTimeOut  连接超时的信息
	 * @return
	 */
	public int startConnection(String ip, String port, UserConfig userConfig, DRCNetConfig netConfig, SyncState state,  int ConnectionTimeOut);
	public void stopConnection();
	public MessageBox getMessageBox();
	public void setSyncOK();
}
