/*
 * longpeng.zlp<longpeng.zlp@alibaba-inc.com>
 * This is implementation of DRCNET java client.
 * 
 */
package alibaba.drcnet.connection;


import java.io.ObjectInputStream.GetField;
import java.security.GeneralSecurityException;
import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.Attribute;
import io.netty.util.Timer;
import alibaba.drcnet.buffer.CacheBuff;
import alibaba.drcnet.config.DRCNetConfig;
import alibaba.drcnet.config.UserConfig;
import alibaba.drcnet.reactor.DRCNetReactor;
import alibaba.drcnet.util.DRCNetMessageInfo;
import alibaba.drcnet.util.Constant;
import alibaba.drcnet.util.MessageBox;
import alibaba.drcnet.util.MessageV1;
import alibaba.drcnet.util.SyncState;

public class SingleDecomressConnection implements Connection{
	private static final Logger log = LoggerFactory.getLogger(SingleDecomressConnection.class);
	private Bootstrap bootstrap = null;
    private EventLoopGroup workerGroup = null;   
    private UserConfig userConfig = null;   
    private ChannelFuture channelFuture = null;
    private Channel channel = null;
    private String ip = null;    
    private String port = null;
    private CacheBuff cacheBuff = null;
    private SyncState syncState = null;
    private DRCNetConfig drcnetConfig = null;
    private volatile boolean stopped = false;
    private  byte[] headerBuff = new byte[4];
    private  byte[]  messageIDBuff = new byte[4];
    private  byte[] bigmsgLenBuff = new byte[4];
    private  byte isBigMsg = 0;
    private  	long msgLen = 0;
    private  long orgmsgLen = 0;
    private volatile boolean syncOK = false;
    private int connectionTimeOut = 120;
    private DRCNetReactor reactor = null;
    MessageBox messageBox = null;
	public UserConfig getUserConfig() {
		return userConfig;
	}

	public void setUserConfig(UserConfig userConfig) {
		this.userConfig = userConfig;
	}
	
	public void setSyncOK() {
		syncOK = true;
	}
	
	public int writeData(DRCNetMessageInfo msgInfo) {
		return 0;
	}
	public MessageBox getMessageBox() {
		return messageBox;
	}
	//this method should be invoked after startService
	public int readData(DRCNetMessageInfo msgInfo,  boolean usingMessageId) {
		int ret = -1;
		while(!stopped) {
			ret = cacheBuff.readData(headerBuff, 4);
			if(ret == 4) {
				break;
			} else {
				if(ret == 0) {
//					try {
//						//TODO use singal to replace this sleep
//						Thread.sleep(1);
//					} catch (InterruptedException e) {
//						log.error("sleep interrupt" + e);
//					}
					messageBox.Wait();
				} else {
					log.error("read buf failed");
					return -1;
				}
			}
		} 
		if(stopped) {
			return -1;
		}
		if (true == usingMessageId) {
			//读取消息的messageid
			ret = cacheBuff.readData(messageIDBuff, 4);
			if (ret != 4) {
				log.error("read len buf failed");
				return -1;
			}
			msgInfo.messageID = MessageV1.getInt32(messageIDBuff, 0);
		}
		isBigMsg = headerBuff[0];
		msgLen = MessageV1.getHeaderLen(headerBuff);
		msgInfo.type = isBigMsg;
		if(!MessageV1.isBigMsg(isBigMsg)) {
			msgInfo.isBigMsg = false;
			msgInfo.orgLen = msgLen;
		} else {
			//big msg occured
			msgInfo.isBigMsg = true;
			ret = cacheBuff.readData(bigmsgLenBuff, 4);
			if(ret != 4) {
				log.error("read len buf failed");
				return -1;
			}
			msgInfo.orgLen = MessageV1.getInt32(bigmsgLenBuff, 0);
		}
		byte[] retBuf = new byte[(int) msgLen];
		msgInfo.bufLen = cacheBuff.readData(retBuf, (int)msgLen);
		msgInfo.buf = retBuf;
		return 0;
	}

	public int handleWriteData() {
		return 0;
	}

	public int handleReadData() {
		return 0;
	}

	public int startConnection(String ip, String port, UserConfig userConfig, DRCNetConfig netConfig, SyncState syncState, int ConncitonTimeOut) {
		bootstrap = new Bootstrap();
		workerGroup = new NioEventLoopGroup();
		messageBox = new MessageBox();
		cacheBuff = new CacheBuff(messageBox);
		reactor = new DRCNetReactor();
		if(workerGroup == null  || cacheBuff == null || headerBuff == null || reactor == null) {
			log.error("get work group failed");
			return -1;
		}
		this.userConfig = userConfig;
//		cacheBuff.initBuf();
		
		if(ip == null || port == null || syncState == null || null == netConfig) {
			log.error("ip or port or syncState or netconfig missing");
			return -1;
		}
		this.syncState = syncState;
		this.drcnetConfig = netConfig;
		this.ip = ip;
		this.port= port;
		bootstrap.group(workerGroup);
		bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, true);
 //       bootstrap.option(ChannelOption.SO_TIMEOUT, socketTimeOut);
        bootstrap.option(ChannelOption.TCP_NODELAY, true);
        bootstrap.option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT); 
        connectionTimeOut = ConncitonTimeOut;
        log.warn("drcnet client read timeout: " + connectionTimeOut);
        bootstrap.handler(new ChannelInitializer<SocketChannel>() {
			@Override
			protected void initChannel(SocketChannel ch) throws Exception {
				ch.pipeline().addLast("readTimeoutHandler", new ReadTimeoutHandler(connectionTimeOut));
				ch.pipeline().addLast(reactor);
			}
		});
        return connectDrcNet();
	}
	
	private int connectDrcNet() {
		if(ip == null || port == null) {
			log.error("connect error: ip or port missed");
			return -1;
		}
        channelFuture = bootstrap.connect(ip, Integer.parseInt(port));
        channel = channelFuture.channel();
        ChannelFuture closeFuture = channel.closeFuture();
        closeFuture.addListener(new ChannelFutureListener() {		
			@Override
			public void operationComplete(ChannelFuture future) throws Exception {
				log.warn("connection closed");
				Thread.sleep(2000);
				stopConnection();			
			}
		});

        Attribute attribute = channelFuture.channel().attr(Constant.configKey);
        attribute.set(userConfig);
        attribute = channelFuture.channel().attr(Constant.cacheBuffer);
        attribute.set(cacheBuff);
        attribute = channelFuture.channel().attr(Constant.syncState);
        attribute.set(syncState);
        attribute = channelFuture.channel().attr(Constant.connection);
        attribute.set(this);
        attribute = channelFuture.channel().attr(Constant.drcnetConfig);
        attribute.set(drcnetConfig);
        reactor.setInitOK();
        channelFuture.syncUninterruptibly();
        //最多同步等待10s
        int retryTime = 10;
        while(syncOK == false && stopped == false && 0 < retryTime--) {
        	try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				log.error("thread interrupt");
			}
        }
        if (false == syncOK || true == stopped) {
        	log.error("drcnet error: sync with server timeout");
        	return -1;
        } else {
        	return 0;
        }
	}


	public void stopConnection() {
		try {
			channelFuture.channel().close();
			if(cacheBuff != null) {
				log.warn("drcnet stopping...,drcnet recv buffer is set stopped, ignore data from netty");
				cacheBuff.setStop();
			}
			channelFuture.channel().closeFuture().sync();
		} catch (Exception e) {
			log.error("close connection interrupted: " + e);
		}finally {
			try {
				workerGroup.shutdownGracefully();
			} catch (Exception e) {
				log.error("shutdown netty workgroup failed, cause " + e.toString());
			}
			log.warn("connection is stopped");
			stopped = true;
			messageBox.Signal();
		}
	}

}
