/*
 * longpeng.zlp<longpeng.zlp@alibaba-inc.com>
 * This is implementation of DRCNET java client.
 * 
 */
package alibaba.drcnet.decoder;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import alibaba.drcnet.util.AesCrypto;


public class lz4Decoder implements Decoder {
	
	private static final Logger log = LoggerFactory.getLogger(lz4Decoder.class);
	private LZ4Factory lz4Factory = null;
	LZ4FastDecompressor lz4Decompressor = null;
	LZ4Compressor compressor = null;
	public int initDecoder(){
		lz4Factory = LZ4Factory.fastestInstance();
		if(lz4Factory == null) {
			log.error("get lz4 factory failed");
			return -1;
		}
		lz4Decompressor = lz4Factory.fastDecompressor();
		if(lz4Decompressor == null) {
			log.error("get lz4 decompressor failed");
			return -1;
		}
		compressor = lz4Factory.fastCompressor();
		return 0;
	}
	
	public int decoder(byte[] srcBuf, int srcBufOffset, byte[] dstBuf, int dstBufOffset,
			int totalLen) {
		System.arraycopy(srcBuf, srcBufOffset, dstBuf, dstBufOffset, totalLen);
		return totalLen;
	}

	public int decoderWithCompress(byte[] srcBuf,int srcBufOffset, byte[] dstBuf,
			int dstBufOffset, int totalLen, int orgLen) {
		int decompressRet =  lz4Decompressor.decompress(srcBuf, srcBufOffset, dstBuf, dstBufOffset, orgLen);
		if(decompressRet != totalLen) {
			log.error("decomprss failed, orglen: " + orgLen + ", decompress size len: " + totalLen 
					+ ", decomress ret: " + decompressRet);
			return -1;
		}
		return orgLen;
	}

	public int decoderWithDecrypt(byte[] srcBuf, int srcBufOffset, byte[] dstBuf, int dstBufOffset,
			int totalLen, AesCrypto aesCrypto) {
		int decryptRet = aesCrypto.decrypt(srcBuf, srcBufOffset, totalLen);
		if(decryptRet != 0) {
			log.error("aes decrypt failed");
			return -1;
		}
		System.arraycopy(srcBuf, srcBufOffset, dstBuf, dstBufOffset, totalLen);
		return totalLen;
	}
	
	public int decoderWithCompressAndDecrypt(byte[] srcBuf,int srcBufOffset, byte[] dstBuf,
			int dstBufOffset, int totalLen, int orgLen, AesCrypto aesCrypto) {
		int decryptRet = aesCrypto.decrypt(srcBuf, srcBufOffset, totalLen);
		if(decryptRet != 0) {
			log.error("aes decrypt failed");
			return -1;
		}
		int decompressRet =  lz4Decompressor.decompress(srcBuf, srcBufOffset, dstBuf, dstBufOffset, orgLen);
		if(decompressRet != totalLen) {
			log.error("decomprss failed, orglen: " + orgLen + ", decompress size len: " + totalLen 
					+ ", decomress ret: " + decompressRet);
			return -1;
		}
		return orgLen;
	}
	
	public int maxDecoderSize(int len) {
		if(compressor == null)
			return len * 2;
		else  {
			return compressor.maxCompressedLength(len);
		}
	}
	
	
}
