/*
 * longpeng.zlp<longpeng.zlp@alibaba-inc.com>
 * This is implementation of DRCNET java client. 
 */
package alibaba.drcnet.impl;

import java.util.Iterator;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import alibaba.drcnet.config.DRCNetConfig;
import alibaba.drcnet.config.UserConfig;
import alibaba.drcnet.connection.Connection;
import alibaba.drcnet.connection.SingleDecomressConnection;
import alibaba.drcnet.enums.ConnType;
import alibaba.drcnet.processer.DRCNetProcesser;
import alibaba.drcnet.util.DRCNetMessageInfo;
import alibaba.drcnet.util.MessageIDUtil;
import alibaba.drcnet.util.MessageV1;
import alibaba.drcnet.util.SyncState;

public class DRCNETClientImpl {
	private static final Logger log = LoggerFactory.getLogger(DRCNETClientImpl.class);

	private Connection connection = null;
	private SyncState syncState = null;
	private UserConfig userConfig = null;
	private MessageIDUtil messageIDUtil = null;
	private boolean useId = false;
	private String ip;
	private String port;
	private boolean stopped = false;
	private int initSyncState(ConnType connType) {
		syncState = new SyncState(false);
		if (null == syncState) {
			log.error("get meme failed");
			return -1;
		}
		int ret = 0;
		syncState.setConnType(connType);
		switch (connType) {
		case SINGLE_NOID_ENCRYPT_CONN: {
			syncState.setIDidenRequired(false);
			syncState.setForceEncrypt(true);
			syncState.setUseOldConnecionSyncWay(false);
			break;
		}
		case SINGLE_NOID_NOENCRYPT_CONN: {
			syncState.setIDidenRequired(false);
			syncState.setForceEncrypt(false);
			syncState.setUseOldConnecionSyncWay(false);
			break;
		}
		case SINGLE_WITHID_ENCRYPT_CONN: {
			syncState.setIDidenRequired(true);
			syncState.setForceEncrypt(true);
			syncState.setUseOldConnecionSyncWay(false);
			useId = true;
			break;
		}
		case SINGLE_WITHID_NOENCRYPT_CONN: {
			syncState.setIDidenRequired(true);
			syncState.setForceEncrypt(false);
			syncState.setUseOldConnecionSyncWay(false);
			useId = true;
			break;
		}
		case OLD_WAY_CONN: {
			syncState.setUseOldConnecionSyncWay(true);
			break;
		}
		default: {
			log.error("unkown msg type");
			ret = -1;
		}
		}
		return ret;
	}
	private int initDrcNet(ConnType connType) {		
		if(connType != ConnType.UNKONWN_TYPE) {	
			if (0 != initSyncState(connType)) {
				log.error("init sync state failed");
				return -1;
			}
			connection = new SingleDecomressConnection();
			if(syncState == null || connection == null) {
				log.error("get meme failed");
				return -1;
			}
			return 0;
		} else {
			log.error("multi conn not support yet");
			return -1;
		}
	}
	private int preCheck(ConnType connType, DRCNetConfig drcnetConfig) {
		if (ConnType.SINGLE_WITHID_ENCRYPT_CONN == connType || ConnType.SINGLE_NOID_ENCRYPT_CONN == connType) {
			if (null == drcnetConfig.getClientAuthString() || null == drcnetConfig.serverTokenAuthTool) {
				log.error("drcnet error: encrypt mode required, but auth string and auth interface not set");
				return -1;
			}
		}
		return 0;
	}
	public int startDRCNet(String ip, String port, ConnType connType, DRCNetConfig drcnetConfig, Map<String, String> userConfigMap, int connectionTimeOut) {
		try {
			if (0 > preCheck(connType, drcnetConfig)) {
				return -1;
			}
			if(initDrcNet(connType) < 0) {
				log.error("init drcnet failed");
				return -1;
			}
			stopped = false;
			userConfig = new UserConfig();
			Iterator iter = userConfigMap.entrySet().iterator();
			while(iter.hasNext()) {
				Map.Entry<String, String> entry = (Map.Entry<String, String>)iter.next();
				userConfig.putConfig(entry.getKey(), entry.getValue());
			}
			if(connection.startConnection(ip, port, userConfig, drcnetConfig, syncState,  connectionTimeOut) < 0) {
				log.error("start conn failed");
				stopped = true;
				return -1;
			}
			if (true == useId) {
				if (0 >= syncState.getMaxMessageID()) {
					log.error("start with id failed");
					stopped = true;
					return -1;
				}							
			}
			messageIDUtil = new MessageIDUtil(syncState.getMaxMessageID());
			return 0;
		} catch(Exception e) {
			log.error("start drcnet failed");
			stopped = true;
			return -1;
		}
	}
	
	public void stopDRCNet() {
		connection.stopConnection();
		stopped = true;
	}
	
	//default read whole msg, that will return the total msg what server write in one time
	//big msg will be rebuild to user
	public int readMsg(DRCNetMessageInfo msgInfo) {
		int readRet = connection.readData(msgInfo, useId);
		//checkmessage id
		if (true == useId) {
			long nextMessageId = messageIDUtil.getNextMessageID();
			if (msgInfo.messageID != nextMessageId) {
				log.error(" message id don't math  from begin");
				return -1;
			}
		}
		//big message, read until all slice has collected
		if(msgInfo.isBigMsg) {
			if(readRet < 0) {
				log.error("read msg error");
				return -1;
			}
			if(!MessageV1.isBigMsgBegin(msgInfo.type)) {
				log.error("big msg begin not match");
				return -1;
			}
			int arrIndex = 0;
			DRCNetMessageInfo retMsgInfo = new DRCNetMessageInfo();
			retMsgInfo.orgLen = msgInfo.orgLen;
			retMsgInfo.isBigMsg = true;
			retMsgInfo.buf = new byte[(int) msgInfo.orgLen];
			retMsgInfo.bufLen = msgInfo.orgLen;
			do{
				System.arraycopy(msgInfo.buf, 0, retMsgInfo.buf, arrIndex, (int) msgInfo.bufLen);
				arrIndex += msgInfo.bufLen;
				readRet = connection.readData(msgInfo, useId);
				if(readRet < 0) {
					log.error("read big msg more error");
					return -1;
				}
				//checkmessage id
				if (true == useId) {
					long nextMessageId = messageIDUtil.getNextMessageID();
					if (msgInfo.messageID != nextMessageId) {
						log.error(" message id don't math  from begin");
						return -1;
					}
				}
			}while(MessageV1.isBigMsgMore(msgInfo.type));
			if(!MessageV1.isBigMsgEnd(msgInfo.type)) {
				log.error("read big msg end failed");
				return -1;
			}
			System.arraycopy(msgInfo.buf, 0, retMsgInfo.buf, arrIndex, (int) msgInfo.bufLen);
			arrIndex += msgInfo.bufLen;
			if(arrIndex != retMsgInfo.orgLen) {
				log.error("big msg length check failed");
				return -1;
			}
			msgInfo.buf = retMsgInfo.buf;
			msgInfo.bufLen = retMsgInfo.bufLen;
			return readRet;
			
		} else {
			return readRet;
		}
	}
	//return single msg this method may read part of message , which should be dealed by user
	//and should not use hybride with readMsg
	public int readSingleMsg(DRCNetMessageInfo mesInfo) {
		return connection.readData(mesInfo, useId);
	}
	
}
