/*
 * longpeng.zlp<longpeng.zlp@alibaba-inc.com>
 * This is implementation of DRCNET java client. 
 */
package alibaba.drcnet.processer;


import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import alibaba.drcnet.buffer.CacheBuff;
import alibaba.drcnet.buffer.TempBuf;
import alibaba.drcnet.config.DRCNetConfig;
import alibaba.drcnet.config.UserConfig;
import alibaba.drcnet.connection.Connection;
import alibaba.drcnet.decoder.Decoder;
import alibaba.drcnet.decoder.lz4Decoder;
import alibaba.drcnet.enums.DRCNetCompressState;
import alibaba.drcnet.enums.DataProcessState;
import alibaba.drcnet.util.AesCrypto;
import alibaba.drcnet.util.Constant;
import alibaba.drcnet.util.MessageV1;
import alibaba.drcnet.util.RandomByte;
import alibaba.drcnet.util.RsaCrypto;
import alibaba.drcnet.util.ServerTokenAuthTool;
import alibaba.drcnet.util.SyncState;
import static alibaba.drcnet.enums.DRCNetCompressState.*;
import static alibaba.drcnet.enums.DataProcessState.*;


public class DRCNetProcesser implements NetDataProcesser{

    private static final Logger log = LoggerFactory.getLogger(DRCNetProcesser.class);
    private static final int MAGIC_NUMBER_SIZE = 25;
    private static final String MAGIC_NUMBER_STR = "kjnkjabhbanc283ubcsbhdc72";
    private static final String SYNC_DONE_STRING = "done";
    private static final byte ASK_ID = 1;
    private static final byte START_CONNECTION = 2;
    private static final byte SINGLE_CONNECTION = 4;
    private static final byte MULTI_CONNECTION = 5;
    //新的协议使用新的标志来开始协议交互
    //在获得了连接的id以后开始使用下面的协议控制帧来进行协议交互
    //sync begin msg 标示正式协议约定开始，新协议各个情况都需要经过这个环节，这个环境会交换客户端和server的subversion
    //并且确认server端是否强制使用加密
    //sync continue msg,使用加密的时候需要使用这个，协商生成最终的秘钥
    //sync end msg,在协商完成以后开始启动协议，注意，如果server端强制加密，客户端会隐晦的使用加密功能，即使没有声明使用加密的方式
    private static final byte SYNC_BEGIN_MSG = 9;
    private static final byte SYNC_CONTINUE_MSG = 10;
    private static final byte SYNC_END_MSG = 11;
    //sync的子类型，目前只定义了sync_encrty的内容
    private static final byte SYNC_ENCRYPT_MSG = 0;
    private static final byte ACCEPT_CONNECTION = 'a';
    private DRCNetCompressState state = MAGIC_NUMBER;
    private DataProcessState dataProcessState = READ_HEAD;
 //   private RecvBuf recvBuf = null;
    private Decoder decoder = null;
    private long id;
    
    private enum RecvBufState {
    	//等待server返回认证信息的长度
    	RECVING_SERVER_TOKEN_LEN,
    	//
    	//等待server返回RSA认证信息的长度
    	RECVING_RSA_PUBLIC_KEY_LEN,
    	//等待server 返回加密字符串的长度
    	RECVING_SERVER_ENCRYPT_STRING_LEN,
    	//等待server返回ok信息的长度
    	RECVING_SERVER_OK_STRING_LEN,
    };
    
    private long serverVersion = 0;
    public static final long maxCtlMsgLen = 5000;
    //将要处理的格式
    private static final short compressFlag = 129;
    private static final short uncompressFlag = 130;
    private static final short compressAndEncryptFlag = 131;
    private static final short uncompressAndEncryptFlag = 132;
    //解压缩的信息
    private short compressIndicate = 0;
    private long compressSize = 0;
    private long orglenLen = 0;
    //防止一次读取authstring补全，暂存
    private TempBuf tempAuthStringBuf = null;
    //防止一次读取int可能不全，暂存
    private TempBuf tempIntBuf = null;
    private TempBuf encryptBuf = null;
//    private SingleRecvBuf singleRecvBuf = null;
    //每次读取压缩首部的前5个字节, |1字节标示是否压缩|4字节标示后面的长度|，如果是压缩的话，那么会再从后面的内容抽取4个字节作为压缩的原始长度
    private byte[] compressHeader = null;
    private int compressHeaderIndex = 0;
    //接受来自网络的压缩包
    private int contentBufferSize = 0;
    private byte[] contetnBuffer = null;
    private int contentBufferOffset = 0;
    private long contentLen = 0;
    private long recvServerBufSize = 0;
    private long leftData = 5;
    //aes解密组件，如果使用加密算法的话
    private AesCrypto aesCrypto = null;
    //rsa加密
    private RsaCrypto rsaCrypto = null;
    
    private long rsaPublicKeyLength = 0;
    private long serverTokenLength = 0;
    private long serverEncryptLen = 0;
    private long serverOkLen = 0;
    //随机挑选两个字符串进行加密
    private int randomIndex1 = -1;
    private int randomIndex2 = -1;

    public boolean process(ChannelHandlerContext ctx, ByteBuf byteBuf, UserConfig userConfig, DRCNetConfig drcnetConfig, CacheBuff buf, SyncState syncState, Connection conn) throws Exception {
        while (byteBuf.isReadable()) {
            switch (state) {
                case MAGIC_NUMBER: {
                	//处理handshake的信息
                	processHandShake(byteBuf);             
                    break;
                }
                case SERVER_VERSION: {
                	//处理server version的信息
                	processServerVersion(ctx, byteBuf, userConfig, syncState);                       
                    break;
                }                
                case GET_IDENTIFY:  {
                	//处理获取id相关的操作
                	processGetId(ctx, byteBuf, userConfig,drcnetConfig, buf, syncState, conn);
                    break;
                }
                case GET_SUBVERSION_MSG_ENCRYPT_INFO: {
                	//处理serversubversion的相关信息
                	processServerSubVersionMsg(ctx, byteBuf, userConfig, drcnetConfig, syncState, conn);
                	break;
                }
                case ENCRYPT_AUTH_SERVER_TOKEN_LEN: {
                	//获取Token认证的长度
                	processEncryptRecvLen(byteBuf, RecvBufState.RECVING_SERVER_TOKEN_LEN);
                	break;
                }
                case ENCRYPT_AUTH_SERVER_TOKEN: {
                	//处理获取的token
                	processServerToken(byteBuf, drcnetConfig);
                	break;
                }
                case ENCRYPT_AUTH_RSA_PUBLIC_KEY_LEN: {
                	//获取rsa公钥的长度
                	processEncryptRecvLen(byteBuf, RecvBufState.RECVING_RSA_PUBLIC_KEY_LEN);
                	break;
                }
                
                case ENCRYPT_AUTH_RSA_PUBLIC_KEY: {
                	//收到public rsakey，进行处理
                	processRsaKey(ctx, byteBuf, drcnetConfig);
                	break;
                }
                
                case ENCRYPT_AUTH_SERVER_AES_ENCRYPT_LEN: {
                	processEncryptRecvLen(byteBuf, RecvBufState.RECVING_SERVER_ENCRYPT_STRING_LEN);
                	break;
                }
                
                case ENCRYPT_AUTH_SERVER_AES_ENCRYPT_CONTENT: {
                	//收到aes加密的数据进行处理
                	processAesEncryptInfo(ctx, byteBuf);
                	break;
                }                
                case ENCRYPT_AUTH_SERVER_OK_LEN: {
                	processEncryptRecvLen(byteBuf, RecvBufState.RECVING_SERVER_OK_STRING_LEN);
                	break;
                }   
                case ENCRYPT_AUTH_SERVER_OK_CONTENT: {
                	//处理结束标志
                	processSyncDoneInfo(ctx, byteBuf, userConfig, syncState, conn);
                	break;
                }
                case GET_HANDSHAKE:  {
                	//处理连接结束
                	processOKMsg(byteBuf);
                    break;
                }
                case READ_COMPRESS_HEADER: {
                	int readableSize = byteBuf.readableBytes();
                	//拿到所有的信息，进行更新
                	if(readableSize >= leftData) {
                		byteBuf.readBytes(compressHeader, compressHeaderIndex, (int)leftData);
                		compressIndicate = (short) (compressHeader[0] & 0x00FF);
                		leftData = MessageV1.getInt32(compressHeader, 1);
                		contentLen = leftData;
                		compressHeaderIndex = 0;
                		state = READ_NET_RAW_DATA;	
                	} else {
                		//暂存这些信息
                		byteBuf.readBytes(compressHeader, compressHeaderIndex, readableSize);
                		compressHeaderIndex += readableSize;
                		leftData -= readableSize;
                	}
                	break;
                }
                case READ_NET_RAW_DATA: {
                	int readableDataSize = byteBuf.readableBytes();
                	//如果长度够了，那么就进行处理，这个处理可能是堵塞的，如果用户消费比较慢
                	if(readableDataSize >= leftData) {
                		byteBuf.readBytes(contetnBuffer, contentBufferOffset, (int)leftData);
                		if(compressIndicate == compressFlag || compressIndicate == compressAndEncryptFlag) {
            				orglenLen = MessageV1.getInt32(contetnBuffer, 0);
            				compressSize = contentLen - 4;
            			} else if(compressIndicate == uncompressFlag || compressIndicate == uncompressAndEncryptFlag){
            				orglenLen = compressSize = contentLen;
            			} else {
            				throw new Exception("read compress flag error");
            			}
                		//进行解压缩
                		porcessCompressContent(buf);
                		//进行变量初始化
                		contentBufferOffset = 0;
                		leftData = 5;
                		state = READ_COMPRESS_HEADER;
                	} else {
                		byteBuf.readBytes(contetnBuffer, contentBufferOffset, readableDataSize);
                		contentBufferOffset += readableDataSize;
                		leftData -= readableDataSize;            		
                	}
                	break;
                }        
            }
        }
        return true;
    }
    
    public void processSyncDoneInfo(ChannelHandlerContext ctx, ByteBuf byteBuf, UserConfig userConfig,  SyncState syncState, Connection conn) throws Exception {
    	int readableSize = byteBuf.readableBytes();
    	//拿到所有的信息，进行更新
    	if(readableSize >= encryptBuf.leftDataLen) {
    		byteBuf.readBytes(encryptBuf.recvDataBuffer, encryptBuf.currentWriteIndex, encryptBuf.leftDataLen);
    		if (!SYNC_DONE_STRING.equals(new String(encryptBuf.recvDataBuffer))) {
    			throw new Exception("drcnet error: sync done compare failed");
    		}
			//交互完成，发送userinfo，等待完成
    		ByteBuf temp = Unpooled.buffer();
    		conn.setSyncOK();
			sendUserParam(temp, ctx, userConfig, syncState, true, true);
			state = GET_HANDSHAKE;
    	} else {
    		log.warn("drcnet, sync recv half server content lenth, recv size " + readableSize);
        	byteBuf.readBytes(encryptBuf.recvDataBuffer, encryptBuf.currentWriteIndex, readableSize);
        	encryptBuf.moveIndex(readableSize);
    	}
    }
    
    private void processAesEncryptInfo(ChannelHandlerContext ctx,ByteBuf byteBuf) throws Exception {
    	int readableSize = byteBuf.readableBytes();
    	//拿到所有的信息，进行更新
    	if(readableSize >= encryptBuf.leftDataLen) {
    		byteBuf.readBytes(encryptBuf.recvDataBuffer, encryptBuf.currentWriteIndex, encryptBuf.leftDataLen);
    		//使用aes进行解密
    		if (0 > aesCrypto.decrypt(encryptBuf.recvDataBuffer, 0, encryptBuf.bufLen)) {
    			throw new Exception("drcnet error: aes drscrypt failed");
    		}
    		byte[] authBytes1 = Constant.exchangeString[randomIndex1].getBytes();
    		byte[] authBytes2 = Constant.exchangeString[randomIndex2].getBytes();
    		byte[] compareBytes = new byte[authBytes1.length + authBytes2.length];
    		System.arraycopy(authBytes1, 0, compareBytes, 0, authBytes1.length);
    		System.arraycopy(authBytes2, 0, compareBytes, authBytes1.length, authBytes2.length);
    		if (false == RandomByte.byteArrayCompare(compareBytes, encryptBuf.recvDataBuffer)) {
    			throw new Exception("drcnet error: server encrypt byte comapre failed");
    		}
    		//通过对比，发送加密以后的串给server，等待回执
    		if (0 > aesCrypto.encrypt(compareBytes, 0, compareBytes.length)) {
    			throw new Exception("drcnet error: encrypt sync string failed");
    		}
    		ByteBuf temp = Unpooled.buffer();
    		byte[] sendBuf = new byte[4];
    		//同时注意构造交互协议的首部
			MessageV1.putInt32(sendBuf, 0, compareBytes.length);
			temp.writeBytes(sendBuf);
			temp.writeBytes(compareBytes);
			ctx.channel().writeAndFlush(temp);
			state = DRCNetCompressState.ENCRYPT_AUTH_SERVER_OK_LEN;
    	} else {
    		log.warn("drcnet, sync recv half server content lenth, recv size " + readableSize);
        	byteBuf.readBytes(encryptBuf.recvDataBuffer, encryptBuf.currentWriteIndex, readableSize);
        	encryptBuf.moveIndex(readableSize);
    	}
    } 
    
    private void processRsaKey(ChannelHandlerContext ctx,ByteBuf byteBuf, DRCNetConfig drcnetConfig) throws Exception {
    	int readableSize = byteBuf.readableBytes();
    	//拿到所有的信息，进行更新
    	if(readableSize >= encryptBuf.leftDataLen) {
    		byteBuf.readBytes(encryptBuf.recvDataBuffer, encryptBuf.currentWriteIndex, encryptBuf.leftDataLen);
    		//这里开始生成ase的初始秘钥信息给server。
    		if(rsaCrypto.initEncryptCompt(encryptBuf.recvDataBuffer, null) < 0) {
        		log.error("drcnet: init rsa failed");
        		throw new Exception("drcnet error: init rsa failed");
        	}
    		//生成AES的初始秘钥和iv
    		byte[] aesPrivateKey = RandomByte.getRandomBytes(AesCrypto.AES_KEY_LEN);
        	byte[] aesIV = RandomByte.getRandomBytes(AesCrypto.AES_IV_LEN);
        	//生成随机挑选加密的字符串
        	randomIndex1 = RandomByte.nextInt(Constant.exchangeStringSize);
        	randomIndex2 = RandomByte.nextInt(Constant.exchangeStringSize);
        	//将要加密的字符串为|aeskeylen|aeskey|aevivlen|aesiv|randomindex1|randomindex2|extendstringlen|extendstring(if exits)|
        	byte[] toEncryptBuf = new byte[4 + AesCrypto.AES_KEY_LEN + 4 + AesCrypto.AES_IV_LEN + 4 + 4 + 4 + drcnetConfig.getExtendStringLen()];
    		MessageV1.putInt32(toEncryptBuf, 0, AesCrypto.AES_KEY_LEN);
    		System.arraycopy(aesPrivateKey, 0, toEncryptBuf, 4, AesCrypto.AES_KEY_LEN);
    		MessageV1.putInt32(toEncryptBuf, 20, AesCrypto.AES_IV_LEN);
    		System.arraycopy(aesIV, 0, toEncryptBuf, 24, AesCrypto.AES_IV_LEN);
    		MessageV1.putInt32(toEncryptBuf, 40, randomIndex1);
    		MessageV1.putInt32(toEncryptBuf, 44, randomIndex2);
    		MessageV1.putInt32(toEncryptBuf, 48, drcnetConfig.extendStringLen);
    		if (null != drcnetConfig.getExtendString())
    			System.arraycopy(drcnetConfig.getExtendString(), 0, toEncryptBuf, 52, drcnetConfig.getExtendStringLen());
    		//将字符串加密，然后发送这个字符串
    		byte[] toSendEncryptedbuff = rsaCrypto.encrypt(toEncryptBuf);
    		ByteBuf temp = Unpooled.buffer();
    		byte[] sendBuf = new byte[2 + 4];
    		//同时注意构造交互协议的首部
			sendBuf[0] = SYNC_CONTINUE_MSG;
			sendBuf[1] = SYNC_ENCRYPT_MSG;
			MessageV1.putInt32(sendBuf, 2, toSendEncryptedbuff.length);
			temp.writeBytes(sendBuf);
			temp.writeBytes(toSendEncryptedbuff);
			ctx.channel().writeAndFlush(temp);
			//发送完成以后，构造aes加密的秘钥，并且加工已经存在的字符串来进行校验
			//shuffle aes的key和iv
			RandomByte.shuffleByte(aesPrivateKey, AesCrypto.AES_IV_LEN);
			RandomByte.shuffleByte(aesIV, AesCrypto.AES_IV_LEN);
			if (0 > aesCrypto.initEncryptCompt(aesPrivateKey, aesIV)) {
				throw new Exception("drcnet error: ase crypto failed");
			}
			
			state = DRCNetCompressState.ENCRYPT_AUTH_SERVER_AES_ENCRYPT_LEN;
    	} else {
    		log.warn("drcnet, sync recv half server rsa lenth, recv size " + readableSize);
        	byteBuf.readBytes(encryptBuf.recvDataBuffer, encryptBuf.currentWriteIndex, readableSize);
        	encryptBuf.moveIndex(readableSize);
    	}
    }
    
    private void processServerToken(ByteBuf byteBuf, DRCNetConfig drcnetConfig) throws Exception {
    	int readableSize = byteBuf.readableBytes();
    	//拿到所有的信息，进行更新
    	if(readableSize >= encryptBuf.leftDataLen) {
    		byteBuf.readBytes(encryptBuf.recvDataBuffer, encryptBuf.currentWriteIndex, encryptBuf.leftDataLen);
    		//这里开始验证server的token是否可信
    		ServerTokenAuthTool serverAuthFunc = drcnetConfig.getServerTokenAuthTool();
    		if (false == serverAuthFunc.authServerToken(encryptBuf.recvDataBuffer, encryptBuf.bufLen)) {
    			throw new Exception("auth server failed, token is " + (new String(encryptBuf.recvDataBuffer)));
    		} else {
    			//初始化tempIntBuf,读取rsa的长度
    			state = ENCRYPT_AUTH_RSA_PUBLIC_KEY_LEN;
    		}
    		
    	} else {
    		log.warn("drcnet, sync recv half server rsa lenth, recv size " + readableSize);
        	byteBuf.readBytes(encryptBuf.recvDataBuffer, encryptBuf.currentWriteIndex, readableSize);
        	encryptBuf.moveIndex(readableSize);
    	}
    }
    
    private void processEncryptRecvLen(ByteBuf byteBuf, RecvBufState recv_state) throws Exception {
    	//获取server端rsa的长度
    	int readableSize = byteBuf.readableBytes();
    	//拿到所有的信息，进行更新
    	if(readableSize >= tempIntBuf.leftDataLen) {
    		byteBuf.readBytes(tempIntBuf.recvDataBuffer, tempIntBuf.currentWriteIndex, tempIntBuf.leftDataLen);
    		switch(recv_state) {
    		case RECVING_SERVER_TOKEN_LEN: {
    			serverTokenLength = MessageV1.getInt32(tempIntBuf.recvDataBuffer, 0);
    			state = DRCNetCompressState.ENCRYPT_AUTH_SERVER_TOKEN;
    			break;
    		}
    		case RECVING_RSA_PUBLIC_KEY_LEN: {
    			rsaPublicKeyLength = MessageV1.getInt32(tempIntBuf.recvDataBuffer, 0);
    			state = DRCNetCompressState.ENCRYPT_AUTH_RSA_PUBLIC_KEY;
    			break;
    		}
    		case RECVING_SERVER_ENCRYPT_STRING_LEN: {
    			serverEncryptLen = MessageV1.getInt32(tempIntBuf.recvDataBuffer, 0);
    			state = DRCNetCompressState.ENCRYPT_AUTH_SERVER_AES_ENCRYPT_CONTENT;
    			break;
    		}
    		case RECVING_SERVER_OK_STRING_LEN: {
    			serverOkLen = MessageV1.getInt32(tempIntBuf.recvDataBuffer, 0);
    			state = DRCNetCompressState.ENCRYPT_AUTH_SERVER_OK_CONTENT;
    			break;
    		}
    		default: {
    			throw new Exception("drcnet error: unknow len type");
    		}
    		}		
    		//重新初始化两种缓存buffer
    		long toRecvBufLen = MessageV1.getInt32(tempIntBuf.recvDataBuffer, 0);
    		checkPackLen(toRecvBufLen);
    		encryptBuf.initTempBuf((int)toRecvBufLen);
    		tempIntBuf.initTempBuf(4);
    	} else {
    		log.warn("drcnet, sync recv half server rsa lenth, recv size " + readableSize);
        	byteBuf.readBytes(tempIntBuf.recvDataBuffer, tempIntBuf.currentWriteIndex, readableSize);
        	tempIntBuf.moveIndex(readableSize);
    	}
    }
    
    private void processServerSubVersionMsg(ChannelHandlerContext ctx, ByteBuf byteBuf, UserConfig userConfig, DRCNetConfig drcnetConfig, SyncState syncState, Connection conn) throws Exception {
    	//处理server返回的信息，格式为|server subversion|server max messageid |force encrypt|
    	int readableSize = byteBuf.readableBytes();
    	if (readableSize >= encryptBuf.leftDataLen) {
    		byteBuf.readBytes(encryptBuf.recvDataBuffer, encryptBuf.currentWriteIndex, encryptBuf.leftDataLen);
    		long serverSubVersion = MessageV1.getInt32(encryptBuf.recvDataBuffer, 0);
    		long serverMaxMessageID = MessageV1.getInt32(encryptBuf.recvDataBuffer, 4);
    		long serverCircleSize = MessageV1.getInt32(encryptBuf.recvDataBuffer, 8);
    		boolean forceEncrypt = encryptBuf.recvDataBuffer[12] == 0 ? false : true;
    		//设置强制加密
    		if (true == forceEncrypt) {
    			syncState.setForceEncrypt(true);
    		}
    		//校验server的subversion,应该高于client
    		if (DRCNetConfig.subClientVerion > serverSubVersion) {
    			log.error("sub version , client:" + DRCNetConfig.subClientVerion  
    					+ " should smaller than server: " + serverSubVersion);
    			throw new Exception("drcnet error: sub version check failed");
    		}
    		if (0 >= serverMaxMessageID) {
    			log.error("invalid message id: " + serverMaxMessageID);
    			throw new Exception("drcnet error: invliad message id " + serverMaxMessageID);
    		}              			 
    		syncState.setMaxMessageID(serverMaxMessageID);
    		log.info("New Sync: using id " + syncState.isIDidenRequired()
    				+ ", using encrypt " + syncState.isForceEncrypt()
    				+ ", max message id from server " + syncState.getMaxMessageID());
    		ByteBuf temp = Unpooled.buffer();
    		if (false == syncState.isForceEncrypt()) {
    			//直接发送SYNC_END+connTYPE+USERDATA 
    			conn.setSyncOK();
    			sendUserParam(temp, ctx, userConfig, syncState, true, false);
    			state = GET_HANDSHAKE;
    		} else {
    			//需要进行加密相关的认证，发送client的token到server，并且接受server的token认证，和rsa公钥
    			if (null == drcnetConfig.getClientAuthString() 
    				|| null == drcnetConfig.getServerTokenAuthTool()
    				|| 0 >= drcnetConfig.getClientAuthStringLen()) {
    				throw new Exception("client auth string is null or server auth tool is null");
    			}
    			//|syncmsg|subsync(encryptmsg)|clienttokenlen|clienttoken|
    			byte[] sendBuf = new byte[2 + 4];
    			sendBuf[0] = SYNC_CONTINUE_MSG;
    			sendBuf[1] = SYNC_ENCRYPT_MSG;
    			MessageV1.putInt32(sendBuf, 2, drcnetConfig.getClientAuthStringLen());
    			temp.writeBytes(sendBuf);
    			temp.writeBytes(drcnetConfig.getClientAuthString());
    			ctx.channel().writeAndFlush(temp);
    			//复用这个tempIntBuf
                tempIntBuf.initTempBuf(4);
    			state = ENCRYPT_AUTH_SERVER_TOKEN_LEN;
    		}             		
    	} else {
    		log.warn("drcnet, sync recv half server subversion, recv size " + readableSize);
        	byteBuf.readBytes(encryptBuf.recvDataBuffer, encryptBuf.currentWriteIndex, readableSize);
        	encryptBuf.moveIndex(readableSize);
    	}
    }
    
    private void processOKMsg(ByteBuf byteBuf) throws Exception {
    	 if (byteBuf.readByte() == ACCEPT_CONNECTION) {
             log.info("accept");
             state = READ_COMPRESS_HEADER;
         } else {
             throw new Exception("drcnet: recv hand shake failed");
         }
    }
    
    private void processGetId(ChannelHandlerContext ctx, ByteBuf byteBuf,  UserConfig userConfig, DRCNetConfig drcnetConfig, CacheBuff buf, SyncState syncState, Connection conn) throws Exception {
    	if(syncState.hasId == true || syncState.id != -1) {
    		syncState.releaseLock();
    		log.error("get id dumpliacted");
    		throw new Exception("get id dumpliacted");
    	}
    	int readableSize = byteBuf.readableBytes();
        if (readableSize >= tempIntBuf.leftDataLen) {
        	byteBuf.readBytes(tempIntBuf.recvDataBuffer, tempIntBuf.currentWriteIndex, tempIntBuf.leftDataLen);
        	id = MessageV1.getInt32(tempIntBuf.recvDataBuffer, 0); 
        	if(serverVersion == 2) {
        		recvServerBufSize = MessageV1.getInt32(tempIntBuf.recvDataBuffer, 4);
        	} else if(serverVersion == 1) {
        		recvServerBufSize = 1024 * 1024 * 32;
        	}
        	log.info("alloc id=" + id + ", server buf size: " + recvServerBufSize);
        	syncState.id = id;
        	syncState.hasId = true;
        	syncState.releaseLock();
        	//if version == 2, then the server is using shrink memory to send this message
            //the receive buffer may use smaller size
        	drcnetConfig.setBufSize((int)recvServerBufSize);
        	//获取最大的压缩长度
        	LZ4Factory factory = LZ4Factory.fastestInstance();
			LZ4Compressor compressor = factory.fastCompressor();
			contentBufferSize = (int)((compressor.maxCompressedLength(drcnetConfig.getBufSize()) + 1023 + 9) / 1024) * 1024;
			contetnBuffer = new byte[contentBufferSize];
			log.warn("recv buf size is:" + contentBufferSize);
            if(buf == null) {
            	throw new Exception("drcnet error: parent buffer can't be null");
            }
            buf.initBuf(drcnetConfig.getBufSize());
            if(conn == null) {
            	throw new Exception("drcnet error: parent connection is null");
            } 
            
            //如果使用老的方式，直接走老的方式来连接，如果server设置了强制加密的模式，那么这么做是会失败的
            //连接会被断掉
            if (syncState.isUseOldConnecionSyncWay()) {
            	//老版本已经到这里sync完成了，等待的线程可以继续运行了
            	conn.setSyncOK();
            	ByteBuf temp = Unpooled.buffer();
            	sendUserParam(temp, ctx, userConfig, syncState, false, false);
            	state = GET_HANDSHAKE;
            } else {
            	//新的方式，发送syncbegin到对端,同时带上自己的subversion,格式|syncbeginmsg|clientsubversion|
            	//等待server返回 |serversubversion|servermaxmessageid|serverqueuesize(for multli conn use)|isforceencrypt|
            	//新的还要继续
            	byte[] sendBuf = new byte[5];
            	sendBuf[0] = SYNC_BEGIN_MSG;
            	MessageV1.putInt32(sendBuf, 1, DRCNetConfig.subClientVerion); 
            	ByteBuf temp = Unpooled.buffer();
            	temp.writeBytes(sendBuf);
                ctx.channel().writeAndFlush(temp);
                state = GET_SUBVERSION_MSG_ENCRYPT_INFO;
            }
        } else {
        	byteBuf.readBytes(tempIntBuf.recvDataBuffer, tempIntBuf.currentWriteIndex, readableSize);
            tempIntBuf.moveIndex(readableSize);
        }
    }
    
    private void processServerVersion(ChannelHandlerContext ctx, ByteBuf byteBuf,  UserConfig userConfig, SyncState syncState) throws Exception {
    	int readableSize = byteBuf.readableBytes();
        if(readableSize >= tempIntBuf.leftDataLen) {
        	byteBuf.readBytes(tempIntBuf.recvDataBuffer, tempIntBuf.currentWriteIndex, tempIntBuf.leftDataLen);
        	serverVersion = MessageV1.getInt32(tempIntBuf.recvDataBuffer, 0);
        	log.info("get server version " + serverVersion);
        	
            syncState.getLock();
            ByteBuf temp = Unpooled.buffer();
            if(syncState.hasId == false) {           	
            	temp.writeByte(ASK_ID);
                ctx.channel().writeAndFlush(temp);
                state = GET_IDENTIFY;
            } else {
            	sendUserParam(temp, ctx, userConfig, syncState, false, false);
                state = GET_HANDSHAKE;
                syncState.releaseLock();
            }
            //version为2的时候会带有server端使用的buffer大小，多出4个字节
            if(serverVersion == 2) {
            	tempIntBuf.initTempBuf(8);
            } else if(serverVersion == 1){
            	tempIntBuf.reiniSingleRecvBuf();
            } else {
            	throw new Exception("drcnet server version not match: " + serverVersion);
            }
        } else {
        	log.warn("drcnet, sync recv half server version, recv size " + readableSize);
        	byteBuf.readBytes(tempIntBuf.recvDataBuffer, tempIntBuf.currentWriteIndex, readableSize);
        	tempIntBuf.moveIndex(readableSize);
        }     
    }
    
    private void processHandShake(ByteBuf byteBuf) throws Exception {
    	int readAbleSize = byteBuf.readableBytes();
    	//比较握手的字符串
    	if(readAbleSize >= tempAuthStringBuf.leftDataLen) {
    		byteBuf.readBytes(tempAuthStringBuf.recvDataBuffer, tempAuthStringBuf.currentWriteIndex, tempAuthStringBuf.leftDataLen);
    		String magicNumber = new String(tempAuthStringBuf.recvDataBuffer);	
    		if (!magicNumber.equals(MAGIC_NUMBER_STR)) {
                throw new Exception("magic number compare failed, drcnet sync failed:" + magicNumber);
            }
    		state = SERVER_VERSION;
    	} else {
    		log.warn("drc net sync recv half magic number, recv size " + readAbleSize);
    		byteBuf.readBytes(tempAuthStringBuf.recvDataBuffer, tempAuthStringBuf.currentWriteIndex, readAbleSize);
    		tempAuthStringBuf.moveIndex(readAbleSize);
    	}              
    }
    //当一段压缩数据接受完成一户进行解压缩操作，这个操作可能是阻塞的，如果用户的buffer没有足够的空间容纳新解压后的数据
    private void porcessCompressContent(CacheBuff buf) throws Exception{
    	//this method is blocked when user buffer has no enough buffer to hold the new incoming data
		int writeIndex = buf.detectWriteable((int)orglenLen);
		if(writeIndex < 0) {
			throw new Exception("put buf failed, client may have stopped");
		}
		int moveIndex = 0;
		switch(compressIndicate) {
		case compressFlag: {
			moveIndex = decoder.decoderWithCompress(contetnBuffer, 4
					, buf.writeBuf.buff, buf.writeBuf.writePos, (int)compressSize, (int)orglenLen);
			break;
		}
		case compressAndEncryptFlag: {
			moveIndex = decoder.decoderWithCompressAndDecrypt(contetnBuffer, 4
					, buf.writeBuf.buff, buf.writeBuf.writePos, (int)compressSize, (int)orglenLen, aesCrypto);
			break;
		}
		case uncompressFlag: {
			moveIndex = decoder.decoder(contetnBuffer, 0,
					buf.writeBuf.buff, buf.writeBuf.writePos, (int)orglenLen);
			break;
		}
		case uncompressAndEncryptFlag: {
			moveIndex = decoder.decoderWithDecrypt(contetnBuffer, 0
					, buf.writeBuf.buff, buf.writeBuf.writePos, (int)orglenLen, aesCrypto);
			break;
		}
		default: {
			throw new Exception("drcnet exception: read unkonw type flag");
		}
		}
		if(moveIndex < 0) {
			throw new Exception("drcnet error: drcnet decoder failed");
		}
		buf.putData(moveIndex);
	
    }
    
    private void sendUserParam(ByteBuf temp, ChannelHandlerContext ctx, UserConfig userConfig, SyncState syncState, boolean isNewSync, boolean needEncrypt) throws Exception {
        
        if (true == isNewSync) {
        	temp.writeByte(SYNC_END_MSG);
        	temp.writeInt(syncState.getConnType().getConnType());
        } else {
        	temp.writeByte(START_CONNECTION);
        }
        if (syncState.isMultiConn) {
 //           temp.writeByte(MULTI_CONNECTION);
            log.warn("multi conn started, not support");
            throw new Exception("multi conn started");
        } else {
            temp.writeByte(SINGLE_CONNECTION);
            log.warn("single conn start");
        }
        temp.writeInt((int) id);
        String urlString = userConfig.toUrlString();
        byte[] data = urlString.getBytes();
        if (true == needEncrypt) {
        	if (0 > aesCrypto.encrypt(data, 0, data.length)) {
        		throw new Exception("drcnet error: encrypt user data failed");
        	}
        }
        temp.writeInt(data.length);
        temp.writeBytes(data);
        ctx.channel().writeAndFlush(temp);
    }

    private void checkPackLen(long len) throws Exception {
    	if (len > maxCtlMsgLen) {
    		throw new Exception("drcnet error: read unreasonable length");
    	}
    }
    
    
	public int initProcesser() {
 //   	recvBuf = new RecvBuf();
    	decoder = new lz4Decoder();
    	tempIntBuf = new TempBuf();
    	tempAuthStringBuf = new TempBuf();
    	encryptBuf = new TempBuf();
    	compressHeader = new byte[5];
    	compressHeaderIndex = 0;
    	aesCrypto = new AesCrypto();
    	rsaCrypto = new RsaCrypto();
    	if(decoder == null || compressHeader == null
    	|| null == rsaCrypto || null == aesCrypto) {
    		return -1;
    	}
    	
    	state = MAGIC_NUMBER;
    	dataProcessState = READ_HEAD;
    	contentLen = 0;
        orglenLen = 0;
        leftData = 5;
    	return decoder.initDecoder() + tempIntBuf.initTempBuf(4) + tempAuthStringBuf.initTempBuf(MAGIC_NUMBER_SIZE) + encryptBuf.initTempBuf(13);
	}
}

