/*
 * longpeng.zlp<longpeng.zlp@alibaba-inc.com>
 * This is implementation of DRCNET java client. 
 */
package alibaba.drcnet.processer;

import alibaba.drcnet.buffer.CacheBuff;
import alibaba.drcnet.config.DRCNetConfig;
import alibaba.drcnet.config.UserConfig;
import alibaba.drcnet.connection.Connection;
import alibaba.drcnet.util.SyncState;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public interface NetDataProcesser {
	public int initProcesser();
	/**
	 * @param ctx   netty上下文
	 * @param byteBuf  netty的发送和接受buffer
	 * @param userConfig  用户要发送的配置
	 * @param drcnetConfig  drcnet内部的配置
	 * @param buffer      用户接受数据的缓冲区
	 * @param sync       交互协议的状态
	 * @param conn      连接信息
	 * @return
	 * @throws Exception
	 */
	
	public boolean process(ChannelHandlerContext ctx, ByteBuf byteBuf, UserConfig userConfig, DRCNetConfig drcnetConfig, CacheBuff buffer, SyncState sync, Connection conn) throws Exception;
}
