/*
 * longpeng.zlp<longpeng.zlp@alibaba-inc.com>
 * This is implementation of DRCNET java client. 
 */
package alibaba.drcnet.reactor;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Attribute;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;





import alibaba.drcnet.buffer.CacheBuff;
import alibaba.drcnet.config.DRCNetConfig;
import alibaba.drcnet.config.UserConfig;
import alibaba.drcnet.connection.Connection;
import alibaba.drcnet.processer.DRCNetProcesser;
import alibaba.drcnet.processer.NetDataProcesser;
import alibaba.drcnet.util.Constant;
import alibaba.drcnet.util.SyncState;

public class DRCNetReactor extends ChannelInboundHandlerAdapter  {
	private static final Logger log = LoggerFactory.getLogger(DRCNetReactor.class);
	    
	CacheBuff sink = null;
	UserConfig userConfig = null;
	SyncState syncState = null;
	NetDataProcesser dataProcesser = null;
	Connection connection = null;
	DRCNetConfig drcnetConfig = null;
	private volatile boolean parentInitOK = false;
	//这个函数会由父类告诉底层，已经初始化ok了，防止channelActive过早的调用
	public  void setInitOK() {
		parentInitOK  = true;
	}
	
	@Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf byteBuf = ((ByteBuf) msg);
        dataProcesser.process(ctx, byteBuf, userConfig, drcnetConfig, sink, syncState, connection);
        byteBuf.release();
    }
	@Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
		//在这里将会至多等待父类5s初始化完成，超过5s认为会有异常产生
		int waitCount = 0;
		while(!parentInitOK && waitCount++ < 10) {
			Thread.sleep(500);
		}
		if(!parentInitOK) {
			log.error("drc net: parent connection init too long, restart");
        	throw new Exception("drc net: parent connection init too long, restart");
		}
    	Attribute attr = ctx.channel().attr(Constant.configKey);
        userConfig = (UserConfig) attr.get();
        attr = ctx.channel().attr(Constant.cacheBuffer);
        sink = (CacheBuff)attr.get();
        attr = ctx.channel().attr(Constant.syncState);
        syncState = (SyncState)attr.get();
        attr = ctx.channel().attr(Constant.connection);
        connection = (Connection)attr.get();
        attr = ctx.channel().attr(Constant.drcnetConfig);
        drcnetConfig = (DRCNetConfig)attr.get();
        if(connection == null || sink == null || syncState == null || userConfig == null || null == drcnetConfig) {
        	log.error("parent atttribute not found");
        	throw new Exception("parent atttribute not found");
        }
        
        if(syncState.isMultiConn == false) {
        	dataProcesser = new DRCNetProcesser();
        } else {
        	log.warn("mulit thread not supported now");
        	dataProcesser = new DRCNetProcesser();
        }
        if(dataProcesser.initProcesser() < 0) {
        	log.error("init process failed");
        	throw new Exception("init process failed");
        }
        ctx.fireChannelActive();
    }
	@Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause)
            throws Exception {
        log.error(cause.getMessage(), cause);
        ctx.channel().close();
        connection.stopConnection();
    }
	 
	
	    

}
