/**
 * aes加密方式
 * longxuan longpeng.zlp@alibaba-inc.com
 */
package alibaba.drcnet.util;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesCrypto {
	private static final Logger log = LoggerFactory.getLogger(AesCrypto.class);
	public static final int AES_KEY_LEN = 16;
	public static final int AES_IV_LEN = 16;
	private byte[] aesPiravteKey = null;
	private byte[] aesIv = null;
	private Cipher aesDecryptor = null;
	private Cipher aesEncryptor = null;
	public int initEncryptCompt(byte[] privateKey, byte[] iv) {
		IvParameterSpec ips = new IvParameterSpec(iv);
		SecretKeySpec aeskeySpec = new SecretKeySpec(privateKey, "AES");
		try {
			aesDecryptor = Cipher.getInstance("AES/CTR/NoPadding");
			aesEncryptor = Cipher.getInstance("AES/CTR/NoPadding");
	        aesDecryptor.init(Cipher.DECRYPT_MODE, aeskeySpec, ips);
	        aesEncryptor.init(Cipher.ENCRYPT_MODE, aeskeySpec, ips);
	        return 0;
		} catch (Exception e) {
			log.error("init aes failed" + e);
			return -1;
		}      
	}
	
	public int encrypt(byte[] src, int offset, int length) {
		try {
			aesEncryptor.update(src, offset, length, src, offset);
			return 0;
		} catch (Exception e) {
			log.error("encrypt failed" + e);
			return -1;
		}
	}
	public int decrypt(byte[] src, int offset, int length) {
		try {
			aesDecryptor.update(src, offset, length, src, offset);
			return 0;
		} catch (Exception e) {
			log.error("decrypt failed" + e);
			return -1;
		}
	}
}
