/*
 * longpeng.zlp<longpeng.zlp@alibaba-inc.com>
 * This is implementation of DRCNET java client. 
 */
package alibaba.drcnet.util;

public class DRCNetMessageInfo {
	public byte[] buf = null;
	public long bufLen = 0;
	public long messageID = 0;
	public byte type = 0;
	public boolean isBigMsg = false;
	public long orgLen = 0;
	public int processOffset = 0;
	public int randomAccessOffset = 0;
	
	public DRCNetMessageInfo() {
		processOffset = 0;
		randomAccessOffset = 0;
	}
	public int readUnsignedByte() {
		return  (int)(buf[processOffset++] & 0x00FF);
		
	}
	public int readUnsignedShort() {
		int ret =  ((buf[processOffset]& 0x00FF) | ((buf[processOffset + 1] & 0x00FF) << 8)) & 0x0FFFF;	
		processOffset += 2;
		return ret;
	}
	
	public int readUnsignedInt() {
		int ret = ((buf[processOffset] & 0x00FF) | ((buf[processOffset + 1] & 0x00FF) << 8) |
				((buf[processOffset + 2] & 0x00FF)<< 16) | ((buf[processOffset + 3]&  0x00FF)<< 24)) & 0x0FFFFFFFF;
		processOffset += 4;
		return ret;
	}
	
	public void setRandomOffset(int offset) {
		randomAccessOffset = offset;
	}
	
	public long readLong() {
		long ret = ((buf[processOffset] & 0x00FF) | ((buf[processOffset + 1] & 0x00FF) << 8) |
					((buf[processOffset + 2] & 0x00FF) << 16) | ((buf[processOffset + 3] & 0x00FF) << 24) |
					((buf[processOffset + 4] & 0x00FF) << 32) | ((buf[processOffset + 5] & 0x00FF) << 40) |
					((buf[processOffset + 6] & 0x00FF) << 48) | ((buf[processOffset + 7] & 0x00FF) << 56));
		processOffset += 8;
		return ret;
	}
	
	
	public int readUnsignedByteA() {
		return  (int)(buf[randomAccessOffset++] & 0x00FF);		
	}
	
	public byte readByteA() {
		return  (byte)(buf[randomAccessOffset++] & 0x00FF);		
	}
	
	public int readUnsignedShortA() {
		int ret =  ((buf[randomAccessOffset]& 0x00FF) | ((buf[randomAccessOffset + 1] & 0x00FF) << 8)) & 0x0FFFF;	
		randomAccessOffset += 2;
		return ret;
	}
	
	public int readUnsignedIntA() {
		int ret = ((buf[randomAccessOffset] & 0x00FF) | ((buf[randomAccessOffset + 1] & 0x00FF) << 8) |
				((buf[randomAccessOffset + 2] & 0x00FF)<< 16) | ((buf[randomAccessOffset + 3]&  0x00FF)<< 24)) & 0x0FFFFFFFF;
		randomAccessOffset += 4;
		return ret;
	}
	
	public long readLongA() {
		long ret = ((buf[randomAccessOffset] & 0x00FF) | ((buf[randomAccessOffset + 1] & 0x00FF) << 8) |
					((buf[randomAccessOffset + 2] & 0x00FF) << 16) | ((buf[randomAccessOffset + 3] & 0x00FF) << 24) |
					((buf[randomAccessOffset + 4] & 0x00FF) << 32) | ((buf[randomAccessOffset + 5] & 0x00FF) << 40) |
					((buf[randomAccessOffset + 6] & 0x00FF) << 48) | ((buf[randomAccessOffset + 7] & 0x00FF) << 56));
		randomAccessOffset += 8;
		return ret;
	}

	
	@Override
	public String toString() {
		return "DRCNetMessageInfo [header coding:"+ MessageV1.getInt32LittleIdian(buf, 0) +  "bufLen=" + bufLen + ", type=" + type
				+ ", isBigMsg=" + isBigMsg + ", orgLen=" + orgLen + "]";
	}
	
}
