package alibaba.drcnet.util;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
/*
 * 同步的一种实现，暂时使用信号量
 */
public class MessageBox {
	private ReentrantLock lock = null;
	private Condition condition = null;
	private static long waitSleepNons = 1000000000L;
	public MessageBox() {
		lock = new ReentrantLock();
		condition = lock.newCondition();
	}
	
	public void Wait() {
		lock.lock();
		try {		
			condition.awaitNanos(waitSleepNons);
		} catch(Exception e) {
			e.printStackTrace();
		} finally {
			lock.unlock();
		}
	}
	
	public void Signal() {
		lock.lock();
		condition.signal();
		lock.unlock();
	}
}
