/*
 * longpeng.zlp<longpeng.zlp@alibaba-inc.com>
 * This is implementation of DRCNET java client. 
 */
package alibaba.drcnet.util;

public class MessageV1 {

	public static boolean isBigMsg(byte x) {
        return (((short)x & 0xFF) >> 7) == 1;
    }

    public static boolean isBigMsgBegin(byte x) {
    	return (((short)x & 0xFF) >> 4) == 0x09;
    }
    
    public static boolean isBigMsgMore(byte x) {
    	return (((short)x & 0xFF) >> 4) == 0x0a;
    }
    
    public static boolean isBigMsgEnd(byte x) {
    	return (((short)x &0xFF) >> 4) == 0x0b;
    }

    public static int getHeaderLen(byte[] dstBuf) {
        int value = 0;
        value |= (dstBuf[0] & 0x0000000F) << 24;
        value |= (dstBuf[1] & 0x000000FF) << 16;
        value |= (dstBuf[2] & 0x000000FF) << 8;
        value |= (dstBuf[3] & 0x000000FF);
        return value;
    }

    public static long getInt32(byte[] dstBuf, int offset) {
        long value = 0;
        value |= (dstBuf[offset] & 0x00000000FF) << 24;
        value |= (dstBuf[offset + 1] & 0x000000FF) << 16;
        value |= (dstBuf[offset + 2] & 0x000000FF) << 8;
        value |= (dstBuf[offset + 3] & 0x000000FF);
        return value;
    }
    
    
    public static long getInt32LittleIdian(byte[] dstBuf, int offset) {
        long value = 0;
        value |= (dstBuf[offset] & 0x00000000FF);
        value |= (dstBuf[offset + 1] & 0x000000FF) << 8;
        value |= (dstBuf[offset + 2] & 0x000000FF) << 16;
        value |= (dstBuf[offset + 3] & 0x000000FF) << 24;
        return value;
    }
    
    public static void putInt32(byte buf[], int value) {
	    buf[0] = (byte) (value >> 24 & 0xFF);
	    buf[1] = (byte) (value >> 16 & 0xFF);
	    buf[2] = (byte) (value >> 8 & 0xFF);
	    buf[3] = (byte) (value & 0xFF);
	}
    public static void putInt32(byte buf[], int offset, int value) {
	    buf[offset] = (byte) (value >> 24 & 0xFF);
	    buf[offset + 1] = (byte) (value >> 16 & 0xFF);
	    buf[offset + 2] = (byte) (value >> 8 & 0xFF);
	    buf[offset + 3] = (byte) (value & 0xFF);
	}
    
}
