package alibaba.drcnet.util;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;

import javax.crypto.Cipher;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
/*
 * longpeng.zlp@alibaba-inc.com
 * rsa加密
 */
public class RsaCrypto {
	private static final Logger log = LoggerFactory.getLogger(RsaCrypto.class);
	private static int RSA_MAX_KEYLEN = 2048;
	private Cipher encryptCipher = null;
	private Cipher decryptCipher = null;
	private PublicKey rsaPublicKey = null;
	private PrivateKey rsaPrivateKey = null;
	public int initAll() {
		try {
			KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
			SecureRandom secureRandom = new SecureRandom(new Date().toString().getBytes());
		    keyPairGenerator.initialize(RSA_MAX_KEYLEN, secureRandom);
		    KeyPair keyPair = keyPairGenerator.genKeyPair();
		    rsaPrivateKey = keyPair.getPrivate();
		    rsaPublicKey = keyPair.getPublic();
		    encryptCipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING");
		    decryptCipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING");
		    encryptCipher.init(Cipher.ENCRYPT_MODE, rsaPublicKey);
		    decryptCipher.init(Cipher.DECRYPT_MODE, rsaPrivateKey);
		} catch (Exception e) {			
			log.error(e.toString());
			return -1;
		} 
		
		return 0;
	}
	
	
	
	public int initEncryptCompt(byte[] publicKey, byte[] privateKey) {
		try {
			if(publicKey != null) {
				KeyFactory publicKeyFactory = KeyFactory.getInstance("RSA");
				X509EncodedKeySpec publicSpec = new X509EncodedKeySpec(publicKey);
				rsaPublicKey = publicKeyFactory.generatePublic(publicSpec);
				encryptCipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING");
				encryptCipher.init(Cipher.ENCRYPT_MODE, rsaPublicKey);
			}
			if(privateKey != null) {
				KeyFactory privateKeyFactory = KeyFactory.getInstance("RSA");
				PKCS8EncodedKeySpec privateSpec = new PKCS8EncodedKeySpec(privateKey);
				rsaPrivateKey = privateKeyFactory.generatePrivate(privateSpec);
				decryptCipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING");
				decryptCipher.init(Cipher.DECRYPT_MODE, rsaPrivateKey);
			}
		} catch (Exception e) {
			log.error(e.toString());
			return -1;
		}       
		return 0;
	}
	
	public byte[] encrypt(byte[] src) {
		if(encryptCipher == null) {
			log.error("encryptor componet is null, please init that");
			return null;
		}
		try {
			byte[] ret = encryptCipher.doFinal(src);
			return ret;
		} catch (Exception e) {
			log.error(e.toString());
			return null;
		}
	}
	public byte[] decrypt(byte[] src) {
		if(decryptCipher == null) {
			log.error("decryptor componet is null, please init that");
			return null;
		}
		try {
			byte[] ret = decryptCipher.doFinal(src);
			return ret;
		} catch (Exception e) {
			log.error(e.toString());
			return null;
		}
	}
}
