/*
 * longpeng.zlp<longpeng.zlp@alibaba-inc.com>
 * This is implementation of DRCNET java client. 
 * 记录协商过程中从server获得的一些信息，以及将要认证的一些信息
 */
package alibaba.drcnet.util;

import java.util.concurrent.locks.ReentrantLock;

import alibaba.drcnet.enums.ConnType;

public class SyncState {
	public long id = -1;
	public boolean hasId = false;
	public boolean isMultiConn = false;
	//是否需要加密
	public boolean isForceEncrypt = false;
	//是否连接需要id
	public boolean isIDidenRequired = false;
	//
	public volatile long maxMessageID = -1;
	
	public ConnType connType;
	public ConnType getConnType() {
		return connType;
	}

	public void setConnType(ConnType connType) {
		this.connType = connType;
	}

	public long getMaxMessageID() {
		return maxMessageID;
	}

	public void setMaxMessageID(long maxMessageID) {
		this.maxMessageID = maxMessageID;
	}

	//是否是使用老的方式连接
	public boolean useOldConnecionSyncWay = true;
	private ReentrantLock lock = null;
	
	public SyncState(boolean isMultiConn) {
		id = -1;
		hasId = false;
		this.isMultiConn = isMultiConn;
		lock = new ReentrantLock();
	}
	
	public boolean isForceEncrypt() {
		return isForceEncrypt;
	}

	public void setForceEncrypt(boolean isForceEncrypt) {
		this.isForceEncrypt = isForceEncrypt;
	}

	public boolean isIDidenRequired() {
		return isIDidenRequired;
	}

	public void setIDidenRequired(boolean isIDidenRequired) {
		this.isIDidenRequired = isIDidenRequired;
	}

	public boolean isUseOldConnecionSyncWay() {
		return useOldConnecionSyncWay;
	}

	public void setUseOldConnecionSyncWay(boolean useOldConnecionSyncWay) {
		this.useOldConnecionSyncWay = useOldConnecionSyncWay;
	}

	public void getLock() {
		lock.lock();
	}
	
	public void releaseLock() {
		lock.unlock();
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public boolean isHasId() {
		return hasId;
	}

	public void setHasId(boolean hasId) {
		this.hasId = hasId;
	}
	
	
	
}
