/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.check;

import com.aliyun.dts.subscribe.clients.ConsumerContext;
import com.aliyun.dts.subscribe.clients.check.CheckResult;
import com.aliyun.dts.subscribe.clients.check.SubscribeChecker;
import com.aliyun.dts.subscribe.clients.check.util.NetUtil;
import com.aliyun.dts.subscribe.clients.check.util.NodeCommandClient;
import com.aliyun.dts.subscribe.clients.check.util.NodeCommandClientConfig;
import com.aliyun.dts.subscribe.clients.common.RetryUtil;
import com.aliyun.dts.subscribe.clients.common.Util;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.requests.MetadataResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeAuthChecker
implements SubscribeChecker {
    private static final Logger LOG = LoggerFactory.getLogger(SubscribeAuthChecker.class);
    private ConsumerContext consumerContext;
    private Properties subscribeProperties;
    private NodeCommandClient.CommandClient commandClient;
    private RetryUtil retryUtil;

    public SubscribeAuthChecker(ConsumerContext consumerContext) {
        this.consumerContext = consumerContext;
        this.subscribeProperties = consumerContext.getKafkaProperties();
        this.retryUtil = new RetryUtil(4, TimeUnit.SECONDS, 15, e -> true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CheckResult check() {
        boolean isOk = true;
        String errMsg = null;
        Properties consumerConfig = new Properties();
        Util.mergeSourceKafkaProperties(this.subscribeProperties, consumerConfig);
        try {
            String proxyUrl = this.consumerContext.getBrokerUrl();
            NodeCommandClientConfig nodeCommandClientConfig = new NodeCommandClientConfig(consumerConfig);
            NodeCommandClient.CommandClientConfig config = NodeCommandClient.CommandClientConfig.fromNodeCommandClientConfig(nodeCommandClientConfig);
            this.commandClient = new NodeCommandClient.CommandClient(config);
            MetadataResponse metadataResponse = this.retryUtil.callFunctionWithRetry(() -> this.commandClient.fetchMetadata());
            Collection nodes = metadataResponse.brokers();
            for (Node node : nodes) {
                if (!proxyUrl.equalsIgnoreCase(node.host() + ":" + node.port())) {
                    LOG.info("Real broker node : " + node);
                }
                try {
                    this.retryUtil.callFunctionWithRetry(() -> NetUtil.testSocket(node.host(), node.port()));
                }
                catch (Exception e) {
                    isOk = false;
                    errMsg = "telnet real node " + node.toString() + " failed, please check the network";
                    return new CheckResult(isOk, errMsg);
                }
            }
        }
        catch (Exception e) {
            isOk = false;
            errMsg = "build kafka consumer failed, error: " + e + ", probably the user name or password is wrong";
            return new CheckResult(isOk, errMsg);
        }
    }
}

