/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.common;

import com.aliyun.dts.subscribe.clients.common.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.LinkedList;
import java.util.List;

public class AtomicFileStore {
    private final String fileName;

    public AtomicFileStore(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<String> getContent() {
        LinkedList<String> ret = new LinkedList<String>();
        if (!Util.checkFileExists(this.fileName)) {
            return ret;
        }
        FileReader readFile = null;
        BufferedReader bufferedReader = null;
        try {
            readFile = new FileReader(this.fileName);
            bufferedReader = new BufferedReader(readFile);
            String s = null;
            while ((s = bufferedReader.readLine()) != null) {
                ret.add(s);
            }
        }
        catch (Exception exception) {
            Util.swallowErrorClose(readFile);
            Util.swallowErrorClose(bufferedReader);
            catch (Throwable throwable) {
                Util.swallowErrorClose(readFile);
                Util.swallowErrorClose(bufferedReader);
                throw throwable;
            }
        }
        Util.swallowErrorClose(readFile);
        Util.swallowErrorClose(bufferedReader);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateContent(List<String> newContent) {
        AtomicFileStore atomicFileStore = this;
        synchronized (atomicFileStore) {
            String tmpFileName = this.fileName + ".tmp";
            if (Util.checkFileExists(tmpFileName)) {
                Util.deleteFile(tmpFileName);
            }
            boolean writeSuccess = true;
            FileWriter fileWriter = null;
            BufferedWriter bufferedWriter = null;
            try {
                fileWriter = new FileWriter(tmpFileName);
                bufferedWriter = new BufferedWriter(fileWriter);
                for (String content : newContent) {
                    bufferedWriter.write(content);
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
            }
            catch (Exception e) {
                try {
                    writeSuccess = false;
                }
                catch (Throwable throwable) {
                    Util.swallowErrorClose(fileWriter);
                    Util.swallowErrorClose(bufferedWriter);
                    throw throwable;
                }
                Util.swallowErrorClose(fileWriter);
                Util.swallowErrorClose(bufferedWriter);
            }
            Util.swallowErrorClose(fileWriter);
            Util.swallowErrorClose(bufferedWriter);
            return writeSuccess ? new File(tmpFileName).renameTo(new File(this.fileName)) : false;
        }
    }

    public void remove() {
        Util.deleteFile(this.fileName);
    }
}

