/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.record;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.dts.subscribe.clients.exception.DTSBaseException;
import com.aliyun.dts.subscribe.clients.formats.avro.DefaultValueDeserializer;
import com.aliyun.dts.subscribe.clients.formats.avro.Field;
import com.aliyun.dts.subscribe.clients.formats.avro.Operation;
import com.aliyun.dts.subscribe.clients.formats.avro.Record;
import com.aliyun.dts.subscribe.clients.formats.util.ObjectNameUtils;
import com.aliyun.dts.subscribe.clients.record.DatabaseInfo;
import com.aliyun.dts.subscribe.clients.record.DefaultRecordSchema;
import com.aliyun.dts.subscribe.clients.record.OperationType;
import com.aliyun.dts.subscribe.clients.record.RecordField;
import com.aliyun.dts.subscribe.clients.record.RecordIndexInfo;
import com.aliyun.dts.subscribe.clients.record.RecordSchema;
import com.aliyun.dts.subscribe.clients.record.RowImage;
import com.aliyun.dts.subscribe.clients.record.SimplifiedRecordField;
import com.aliyun.dts.subscribe.clients.record.impl.DefaultRowImage;
import com.aliyun.dts.subscribe.clients.record.value.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class AvroRecordParser {
    public static OperationType getOperationType(Record avroRecord) {
        switch (avroRecord.getOperation()) {
            case INSERT: {
                return OperationType.INSERT;
            }
            case UPDATE: {
                return OperationType.UPDATE;
            }
            case DELETE: {
                return OperationType.DELETE;
            }
            case DDL: {
                return OperationType.DDL;
            }
            case HEARTBEAT: {
                return OperationType.HEARTBEAT;
            }
            case CHECKPOINT: {
                return OperationType.CHECKPOINT;
            }
            case BEGIN: {
                return OperationType.BEGIN;
            }
            case COMMIT: {
                return OperationType.COMMIT;
            }
        }
        return OperationType.UNKNOWN;
    }

    private static Triple<String, String, String> getNames(String mixedNames) {
        String dbName = null;
        String schemaName = null;
        String tableName = null;
        String[] dbPair = ObjectNameUtils.uncompressionObjectName(mixedNames);
        if (dbPair != null) {
            if (dbPair.length == 2) {
                dbName = dbPair[0];
                tableName = dbPair[1];
                schemaName = dbPair[0];
            } else if (dbPair.length == 3) {
                dbName = dbPair[0];
                schemaName = dbPair[1];
                tableName = dbPair[2];
            } else if (dbPair.length == 1) {
                dbName = dbPair[0];
            } else {
                throw new DTSBaseException("Invalid db table name pair for mixed [" + mixedNames + "]");
            }
        }
        return Triple.of(dbName, schemaName, tableName);
    }

    private static Pair<Set<String>, List<Set<String>>> getPrimaryAndUniqueKeyNames(Record avroRecord) {
        TreeSet<String> pkNameSet = new TreeSet<String>();
        LinkedList ukNameList = new LinkedList();
        String pkUkInfoStr = avroRecord.getTags().get("pk_uk_info");
        if (!StringUtils.isEmpty((CharSequence)pkUkInfoStr)) {
            JSONObject jsonObject = JSON.parseObject((String)pkUkInfoStr);
            for (Map.Entry entry : jsonObject.entrySet()) {
                String key = (String)entry.getKey();
                JSONArray jsonArray = (JSONArray)entry.getValue();
                if (StringUtils.equals((CharSequence)"PRIMARY", (CharSequence)key)) {
                    for (Object value : jsonArray) {
                        pkNameSet.add(String.valueOf(value));
                    }
                    continue;
                }
                TreeSet<String> ukNameSet = new TreeSet<String>();
                for (Object value : jsonArray) {
                    ukNameSet.add(String.valueOf(value));
                }
                ukNameList.add(ukNameSet);
            }
        }
        return Pair.of(pkNameSet, ukNameList);
    }

    private static List<Field> getAvroRecordFields(Record avroRecord) {
        List<Field> fields = (List<Field>)avroRecord.getFields();
        if (null == fields && Operation.DDL == avroRecord.getOperation()) {
            Field fakeField = new Field();
            fakeField.setName("ddl");
            fakeField.setDataTypeNumber(0);
            fields = Arrays.asList(fakeField);
        }
        if (null == fields) {
            fields = Collections.emptyList();
        }
        return fields;
    }

    private static Pair<List<RecordField>, RecordIndexInfo> getRecordFields(Record avroRecord, Set<String> pkNames, Set<String> ukNames) {
        List<Field> fields = AvroRecordParser.getAvroRecordFields(avroRecord);
        ArrayList<SimplifiedRecordField> recordFields = new ArrayList<SimplifiedRecordField>(fields.size());
        RecordIndexInfo pkOrUkIndexInfo = new RecordIndexInfo(RecordIndexInfo.IndexType.PrimaryKey);
        int fieldPosition = 0;
        for (Field field : fields) {
            String filedName = field.getName();
            SimplifiedRecordField recordField = new SimplifiedRecordField(filedName, field.getDataTypeNumber());
            boolean pkOrUk = recordField.setPrimary(pkNames.contains(filedName));
            recordField.setUnique(ukNames.contains(filedName));
            if (pkOrUk) {
                pkOrUkIndexInfo.addField(recordField);
            }
            recordField.setFieldPosition(fieldPosition);
            recordFields.add(recordField);
            ++fieldPosition;
        }
        return Pair.of(recordFields, (Object)pkOrUkIndexInfo);
    }

    public static RecordSchema getRecordSchema(Record avroRecord) {
        Triple<String, String, String> names = AvroRecordParser.getNames(avroRecord.getObjectName());
        Pair<Set<String>, List<Set<String>>> keyNamePair = AvroRecordParser.getPrimaryAndUniqueKeyNames(avroRecord);
        Set pkNames = (Set)keyNamePair.getLeft();
        Set<String> allUkNames = ((List)keyNamePair.getRight()).stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Pair<List<RecordField>, RecordIndexInfo> recordFieldAndIndexInfo = AvroRecordParser.getRecordFields(avroRecord, pkNames, allUkNames);
        String schemaId = names.toString();
        List recordFields = (List)recordFieldAndIndexInfo.getLeft();
        RecordIndexInfo pkOrUkIndexInfo = (RecordIndexInfo)recordFieldAndIndexInfo.getRight();
        DefaultRecordSchema recordSchema = new DefaultRecordSchema(schemaId, (String)names.getLeft(), (String)names.getRight(), recordFields);
        recordSchema.setDatabaseInfo(new DatabaseInfo(avroRecord.getSource().getSourceType().name(), avroRecord.getSource().getVersion()));
        if (!pkOrUkIndexInfo.getIndexFields().isEmpty()) {
            recordSchema.setPrimaryIndexInfo(pkOrUkIndexInfo);
        }
        for (Set ukNameSet : (List)keyNamePair.getRight()) {
            RecordIndexInfo recordIndexInfo = new RecordIndexInfo(RecordIndexInfo.IndexType.UniqueKey);
            for (String ukFieldName : ukNameSet) {
                recordIndexInfo.addField(recordSchema.getField(ukFieldName).orElseThrow(() -> new RuntimeException(ukFieldName + " not found in record [" + (Object)((Object)avroRecord) + "]")));
            }
            recordSchema.addUniqueIndexInfo(recordIndexInfo);
        }
        return recordSchema;
    }

    public static RowImage getRowImage(RecordSchema recordSchema, Record avroRecord, boolean isBefore) {
        Object avroRowImage;
        Object rowImage = isBefore ? (List<Object>)avroRecord.getBeforeImages() : (null == (avroRowImage = avroRecord.getAfterImages()) ? null : (avroRowImage instanceof String ? Arrays.asList(avroRowImage.toString()) : (List)avroRecord.getAfterImages()));
        DefaultRowImage rs = null;
        if (rowImage != null && !rowImage.isEmpty()) {
            rs = new DefaultRowImage(recordSchema);
            int index = 0;
            Iterator<Object> iterator = rowImage.iterator();
            while (iterator.hasNext()) {
                Object rowValue = iterator.next();
                Value value = DefaultValueDeserializer.deserialize(rowValue);
                rs.setValue(index, value);
                ++index;
            }
        }
        return rs;
    }
}

