/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.record;

import com.aliyun.dts.subscribe.clients.record.RecordField;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RecordIndexInfo {
    private IndexType indexType;
    private List<RecordField> indexFields;
    private long cardinality;
    private boolean nullable = true;
    private boolean isFirstUniqueIndex = false;
    private String name;

    public RecordIndexInfo(IndexType type) {
        this.indexType = type;
        this.indexFields = new ArrayList<RecordField>();
    }

    public void addField(RecordField recordField) {
        for (RecordField field : this.indexFields) {
            if (!StringUtils.equals((CharSequence)field.getFieldName(), (CharSequence)recordField.getFieldName())) continue;
            return;
        }
        this.indexFields.add(recordField);
    }

    public void removeField(RecordField recordField) {
        this.indexFields.remove(recordField);
    }

    public synchronized List<RecordField> getIndexFields() {
        return this.indexFields;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public boolean isPrimaryKeyIndex() {
        return IndexType.PrimaryKey == this.indexType;
    }

    public boolean isUniqueKeyIndex() {
        return IndexType.UniqueKey == this.indexType;
    }

    public boolean isNormalIndex() {
        return IndexType.NormalIndex == this.indexType;
    }

    public long getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(long cardinality) {
        this.cardinality = cardinality;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isFirstUniqueIndex() {
        return this.isFirstUniqueIndex;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFirstUniqueIndex(boolean firstUniqueIndex) {
        this.isFirstUniqueIndex = firstUniqueIndex;
    }

    public String toString() {
        return "[indexType=" + (Object)((Object)this.indexType) + ", indexFields=" + this.indexFields + ", cardinality=" + this.cardinality + ", nullable=" + this.nullable + ", isFirstUniqueIndex=" + this.isFirstUniqueIndex + ", name=" + this.name + "]";
    }

    public static enum IndexType {
        PrimaryKey,
        UniqueKey,
        NormalIndex,
        ForeignKey,
        Unknown;

    }
}

