/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dms.subscribe.clients;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.dts.subscribe.clients.common.RetryUtil;
import com.aliyun.dts.subscribe.clients.formats.avro.Operation;
import com.aliyun.dts.subscribe.clients.formats.avro.Record;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dts.model.v20200101.DescribeSubscriptionMetaRequest;
import com.aliyuncs.dts.model.v20200101.DescribeSubscriptionMetaResponse;
import com.aliyuncs.exceptions.ClientException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMapper {
    private final Logger log = LoggerFactory.getLogger(DBMapper.class);
    private Map<String, String> physic2logicDBMapper = new HashMap<String, String>();
    private Map<String, String> physic2logicTableMapper = new HashMap<String, String>();
    private boolean mapping = true;
    private IAcsClient iAcsClient;
    private DescribeSubscriptionMetaRequest describeSubscriptionMetaRequest;
    private RetryUtil retryUtil = new RetryUtil(4, TimeUnit.SECONDS, 15, e -> true);

    public void setClient(IAcsClient client) {
        this.iAcsClient = client;
    }

    public void setDescribeSubscriptionMetaRequest(DescribeSubscriptionMetaRequest describeSubscriptionMetaRequest) {
        this.describeSubscriptionMetaRequest = describeSubscriptionMetaRequest;
    }

    public synchronized void init(String dbListString) {
        JSONObject dbList = JSONObject.parseObject((String)dbListString);
        for (Map.Entry entry : dbList.entrySet()) {
            String physicDb = (String)entry.getKey();
            String logicDb = (String)((JSONObject)entry.getValue()).get((Object)"name");
            JSONObject tables = (JSONObject)((JSONObject)entry.getValue()).get((Object)"Table");
            this.physic2logicDBMapper.put(physicDb, logicDb);
            for (Map.Entry table : tables.entrySet()) {
                String physicTable = (String)table.getKey();
                String logicTable = (String)((JSONObject)table.getValue()).get((Object)"name");
                this.physic2logicTableMapper.put(physicDb + "." + physicTable, logicDb + "." + logicTable);
            }
        }
    }

    public void init(List<String> dbLists) {
        for (String dbList : dbLists) {
            this.init(dbList);
        }
    }

    public boolean refreshDbList() throws ClientException {
        ArrayList<String> dbLists = new ArrayList<String>();
        DescribeSubscriptionMetaResponse res = (DescribeSubscriptionMetaResponse)this.iAcsClient.getAcsResponse((AcsRequest)this.describeSubscriptionMetaRequest);
        boolean success = res.getSuccess().equalsIgnoreCase("true");
        if (success) {
            for (DescribeSubscriptionMetaResponse.SubscriptionMetaListItem meta : res.getSubscriptionMetaList()) {
                dbLists.add(meta.getDBList());
                this.log.debug("refresh dbList:" + meta.getDBList());
            }
            this.init(dbLists);
        }
        return success;
    }

    public Record transform(Record record) {
        if (record.getOperation().equals((Object)Operation.INSERT) || record.getOperation().equals((Object)Operation.UPDATE) || record.getOperation().equals((Object)Operation.DELETE)) {
            if (!this.physic2logicTableMapper.containsKey(record.getObjectName())) {
                this.log.info("Cannot find logic db table for " + record.getObjectName() + ", refreshing dbList now");
                try {
                    this.retryUtil.callFunctionWithRetry(() -> this.refreshDbList());
                }
                catch (Exception e) {
                    this.log.error("Error getting dbList:" + e);
                }
            }
            record.setObjectName(this.physic2logicTableMapper.get(record.getObjectName()));
        }
        return record;
    }

    public boolean isMapping() {
        return this.mapping;
    }

    public void setMapping(boolean mapping) {
        this.mapping = mapping;
    }
}

