/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients;

import com.aliyun.dts.subscribe.clients.AbstractDTSConsumer;
import com.aliyun.dts.subscribe.clients.ConsumerContext;
import com.aliyun.dts.subscribe.clients.common.Checkpoint;
import com.aliyun.dts.subscribe.clients.common.Util;
import com.aliyun.dts.subscribe.clients.common.WorkThread;
import com.aliyun.dts.subscribe.clients.exception.CriticalException;
import com.aliyun.dts.subscribe.clients.recordfetcher.KafkaRecordFetcher;
import com.aliyun.dts.subscribe.clients.recordgenerator.UserRecordGenerator;
import com.aliyun.dts.subscribe.clients.recordprocessor.EtlRecordProcessor;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDTSConsumer
extends AbstractDTSConsumer {
    private static final Logger log = LoggerFactory.getLogger(DefaultDTSConsumer.class);

    public DefaultDTSConsumer(ConsumerContext consumerContext) {
        super(consumerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        boolean checkResult = this.check();
        if (!checkResult) {
            log.error("DTS precheck failed, dts consumer exit.");
            throw new CriticalException("DTS precheck failed, dts consumer exit.");
        }
        DefaultDTSConsumer defaultDTSConsumer = this;
        synchronized (defaultDTSConsumer) {
            DefaultDTSConsumer.initLog4j();
            if (this.started) {
                throw new IllegalStateException("The client has already been started");
            }
            KafkaRecordFetcher recordFetcher = new KafkaRecordFetcher(this.consumerContext, this.toProcessRecords);
            UserRecordGenerator userRecordGenerator = new UserRecordGenerator(this.consumerContext, this.toProcessRecords, this.defaultUserRecords, (tp, timestamp, offset, metadata) -> recordFetcher.setToCommitCheckpoint(new Checkpoint(tp, timestamp, offset, metadata)));
            EtlRecordProcessor etlRecordProcessor = new EtlRecordProcessor(this.consumerContext, this.defaultUserRecords, this.recordListeners);
            List<WorkThread> startStream = DefaultDTSConsumer.startWorker(etlRecordProcessor, userRecordGenerator, recordFetcher);
            while (!this.consumerContext.isExited()) {
                Util.sleepMS(1000L);
            }
            log.info("DTS Consumer: shutting down...");
            for (WorkThread workThread : startStream) {
                workThread.stop();
            }
            this.started = true;
        }
    }

    private static List<WorkThread> startWorker(EtlRecordProcessor etlRecordProcessor, UserRecordGenerator userRecordGenerator, KafkaRecordFetcher recordGenerator) {
        LinkedList<WorkThread> ret = new LinkedList<WorkThread>();
        ret.add(new WorkThread<EtlRecordProcessor>(etlRecordProcessor, EtlRecordProcessor.class.getName()));
        ret.add(new WorkThread<UserRecordGenerator>(userRecordGenerator, UserRecordGenerator.class.getName()));
        ret.add(new WorkThread<KafkaRecordFetcher>(recordGenerator, KafkaRecordFetcher.class.getName()));
        for (WorkThread workThread : ret) {
            workThread.start();
        }
        return ret;
    }
}

