/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.formats.avro;

import com.aliyun.dts.subscribe.clients.formats.avro.BinaryGeometry;
import com.aliyun.dts.subscribe.clients.formats.avro.BinaryObject;
import com.aliyun.dts.subscribe.clients.formats.avro.Character;
import com.aliyun.dts.subscribe.clients.formats.avro.DateTime;
import com.aliyun.dts.subscribe.clients.formats.avro.Decimal;
import com.aliyun.dts.subscribe.clients.formats.avro.EmptyObject;
import com.aliyun.dts.subscribe.clients.formats.avro.Float;
import com.aliyun.dts.subscribe.clients.formats.avro.Integer;
import com.aliyun.dts.subscribe.clients.formats.avro.TextGeometry;
import com.aliyun.dts.subscribe.clients.formats.avro.TextObject;
import com.aliyun.dts.subscribe.clients.formats.avro.Timestamp;
import com.aliyun.dts.subscribe.clients.formats.avro.TimestampWithTimeZone;
import com.aliyun.dts.subscribe.clients.record.value.BinaryEncodingObject;
import com.aliyun.dts.subscribe.clients.record.value.DecimalNumeric;
import com.aliyun.dts.subscribe.clients.record.value.FloatNumeric;
import com.aliyun.dts.subscribe.clients.record.value.IntegerNumeric;
import com.aliyun.dts.subscribe.clients.record.value.NoneValue;
import com.aliyun.dts.subscribe.clients.record.value.ObjectType;
import com.aliyun.dts.subscribe.clients.record.value.StringValue;
import com.aliyun.dts.subscribe.clients.record.value.TextEncodingObject;
import com.aliyun.dts.subscribe.clients.record.value.UnixTimestamp;
import com.aliyun.dts.subscribe.clients.record.value.Value;
import com.aliyun.dts.subscribe.clients.record.value.WKBGeometry;
import com.aliyun.dts.subscribe.clients.record.value.WKTGeometry;

public class DefaultValueDeserializer {
    public static Value deserialize(Object data) {
        if (null == data) {
            return null;
        }
        if (data instanceof String) {
            return new StringValue((String)data);
        }
        if (data instanceof Integer) {
            Integer integer = (Integer)((Object)data);
            return new IntegerNumeric(integer.getValue());
        }
        if (data instanceof Character) {
            Character character = (Character)((Object)data);
            return new StringValue(character.getValue(), character.getCharset());
        }
        if (data instanceof TextObject) {
            TextObject textObject = (TextObject)((Object)data);
            return new TextEncodingObject(ObjectType.valueOf(textObject.getType().toUpperCase()), textObject.getValue());
        }
        if (data instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)((Object)data);
            UnixTimestamp unixTimestamp = new UnixTimestamp();
            unixTimestamp.setTimestampSec(timestamp.getTimestamp());
            if (null != timestamp.getMillis()) {
                unixTimestamp.setMicro(timestamp.getMillis());
            }
            return unixTimestamp;
        }
        if (data instanceof DateTime) {
            DateTime aDt = (DateTime)((Object)data);
            return DefaultValueDeserializer.deserialize(aDt);
        }
        if (data instanceof TimestampWithTimeZone) {
            TimestampWithTimeZone timestampWithTimeZone = (TimestampWithTimeZone)((Object)data);
            com.aliyun.dts.subscribe.clients.record.value.DateTime dt = DefaultValueDeserializer.deserialize(timestampWithTimeZone.getValue());
            dt.setTimeZone(timestampWithTimeZone.getTimezone());
            return dt;
        }
        if (data instanceof BinaryObject) {
            BinaryObject binaryObject = (BinaryObject)((Object)data);
            return new BinaryEncodingObject(ObjectType.valueOf(binaryObject.getType().toUpperCase()), binaryObject.getValue());
        }
        if (data instanceof Float) {
            Float aFloat = (Float)((Object)data);
            return new FloatNumeric(aFloat.getValue());
        }
        if (data instanceof Decimal) {
            Decimal decimal = (Decimal)((Object)data);
            return new DecimalNumeric(decimal.getValue());
        }
        if (data instanceof BinaryGeometry) {
            BinaryGeometry geometry = (BinaryGeometry)((Object)data);
            return new WKBGeometry(geometry.getValue());
        }
        if (data instanceof TextGeometry) {
            TextGeometry geometry = (TextGeometry)((Object)data);
            return new WKTGeometry(geometry.getValue());
        }
        if (data == EmptyObject.NONE) {
            return new NoneValue();
        }
        throw new RuntimeException("Not support avro class type:" + data.getClass().getName());
    }

    static com.aliyun.dts.subscribe.clients.record.value.DateTime deserialize(DateTime inDt) {
        com.aliyun.dts.subscribe.clients.record.value.DateTime dt = new com.aliyun.dts.subscribe.clients.record.value.DateTime();
        if (null != inDt.getYear()) {
            dt.setSegments(2);
            dt.setYear(inDt.getYear());
        }
        if (null != inDt.getMonth()) {
            dt.setSegments(4);
            dt.setMonth(inDt.getMonth());
        }
        if (null != inDt.getDay()) {
            dt.setSegments(8);
            dt.setDay(inDt.getDay());
        }
        if (null != inDt.getHour()) {
            dt.setSegments(112);
            dt.setHour(inDt.getHour());
            dt.setMinute(inDt.getMinute());
            dt.setSecond(inDt.getSecond());
        }
        if (null != inDt.getMillis()) {
            dt.setSegments(128);
            dt.setNaons(inDt.getMillis() * 1000);
        }
        return dt;
    }
}

