/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.metrics;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.dts.subscribe.clients.common.ThreadFactoryWithNamePrefix;
import com.aliyun.dts.subscribe.clients.exception.DTSBaseException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMetricsReporter
implements MetricsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(LogMetricsReporter.class);
    private static final Logger METRICS_LOG = LoggerFactory.getLogger((String)"log.metrics");
    private static final String METRICS_PREFIX = "metrics.";
    static final String METRICS_PERIOD_CONFIG = "metrics.period.sec";
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("metrics.period.sec", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "The frequency at which metrics should be reported, in second");
    private Set<String> includeSet = new HashSet<String>();
    private final Object lock = new Object();
    private final Map<MetricName, KafkaMetric> metrics = new LinkedHashMap<MetricName, KafkaMetric>();
    private int period;
    private final ScheduledThreadPoolExecutor executor;
    private final Time time;
    private static final Map<String, String> STATIC_KEY_MAPPER = new HashMap<String, String>();

    public LogMetricsReporter() {
        this((Time)new SystemTime(), new ScheduledThreadPoolExecutor(1, new ThreadFactoryWithNamePrefix("subscribe-logMetricsReporter-")));
    }

    LogMetricsReporter(Time mockTime, ScheduledThreadPoolExecutor mockExecutor) {
        this.time = mockTime;
        this.executor = mockExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(List<KafkaMetric> initMetrics) {
        Object object = this.lock;
        synchronized (object) {
            for (KafkaMetric metric : initMetrics) {
                if (!this.includeSet.isEmpty() && !this.includeSet.contains(metric.metricName().name())) continue;
                LOG.debug("Adding metric {}", (Object)metric.metricName());
                this.metrics.put(metric.metricName(), metric);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metricChange(KafkaMetric metric) {
        Object object = this.lock;
        synchronized (object) {
            if (this.includeSet.isEmpty() || this.includeSet.contains(metric.metricName().name())) {
                LOG.debug("Updating metric {}", (Object)metric.metricName());
                this.metrics.put(metric.metricName(), metric);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metricRemoval(KafkaMetric metric) {
        Object object = this.lock;
        synchronized (object) {
            LOG.debug("Removing metric {}", (Object)metric.metricName());
            this.metrics.remove(metric.metricName());
        }
    }

    public void start() {
        this.executor.scheduleAtFixedRate(new PeriodReporter(), this.period, this.period, TimeUnit.SECONDS);
    }

    public void close() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new DTSBaseException("Interrupted when shutting down LogMetricsReporter" + e);
        }
    }

    public void configure(Map<String, ?> configs) {
        LogMetricsReporterConfig config = new LogMetricsReporterConfig(CONFIG_DEF, configs);
        this.period = config.getInteger(METRICS_PERIOD_CONFIG);
        LOG.info("Configured Log MetricsReporter to report every {} seconds", (Object)this.period);
    }

    public void configure(int period, String includeCfg) {
        this.period = period;
        if (StringUtils.isBlank((CharSequence)includeCfg)) {
            return;
        }
        Collections.addAll(this.includeSet, includeCfg.split(","));
    }

    public String genContent(Collection<MetricValue> metricValues) {
        try {
            if (metricValues == null) {
                return null;
            }
            JSONObject jsonObject = new JSONObject();
            for (MetricValue metricValue : metricValues) {
                BigDecimal metricMeasurableValue = null;
                try {
                    metricMeasurableValue = new BigDecimal(String.valueOf(metricValue.value));
                }
                catch (Exception var8) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)metricValue.name, (CharSequence)"maxQueuedKeyInfo")) continue;
                    jsonObject.put("maxQueuedKeyInfo", (Object)String.valueOf(metricValue.value));
                    continue;
                }
                String alias = STATIC_KEY_MAPPER.get(metricValue.name);
                if (metricMeasurableValue.scale() > 2) {
                    metricMeasurableValue = metricMeasurableValue.setScale(2, RoundingMode.HALF_UP);
                }
                jsonObject.put(metricValue.name, (Object)metricMeasurableValue);
                if (null == alias) continue;
                jsonObject.put(alias, (Object)metricMeasurableValue);
            }
            jsonObject.put("__dt", (Object)new Date().getTime());
            return jsonObject.toJSONString();
        }
        catch (Exception var9) {
            LOG.warn("LogMetricsReporter: format metric failed, cause " + var9.getMessage());
            return null;
        }
    }

    private static class MetricsReport {
        private final long timestamp;
        private final Collection<MetricValue> metrics;

        MetricsReport(long timestamp, Collection<MetricValue> metrics) {
            this.timestamp = timestamp;
            this.metrics = metrics;
        }

        @JsonProperty
        public long timestamp() {
            return this.timestamp;
        }

        @JsonProperty
        public Collection<MetricValue> metrics() {
            return this.metrics;
        }
    }

    private static class MetricValue {
        private final String name;
        private final String group;
        private final Map<String, String> tags;
        private final Object value;

        MetricValue(String name, String group, Map<String, String> tags, Object value) {
            this.name = name;
            this.group = group;
            this.tags = tags;
            this.value = value;
        }

        @JsonProperty
        public String name() {
            return this.name;
        }

        @JsonProperty
        public String group() {
            return this.group;
        }

        @JsonProperty
        public Map<String, String> tags() {
            return this.tags;
        }

        @JsonProperty
        public Object value() {
            return this.value;
        }

        public String toString() {
            return String.format("name=%s;group=%s;tags=%s;value=%s", this.name, this.group, this.tags, this.value);
        }
    }

    private class PeriodReporter
    implements Runnable {
        private PeriodReporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<MetricValue> samples;
            long now = LogMetricsReporter.this.time.milliseconds();
            Object object = LogMetricsReporter.this.lock;
            synchronized (object) {
                samples = new ArrayList<MetricValue>(LogMetricsReporter.this.metrics.size());
                for (KafkaMetric metric : LogMetricsReporter.this.metrics.values()) {
                    MetricName name = metric.metricName();
                    samples.add(new MetricValue(name.name(), name.group(), name.tags(), metric.metricValue()));
                }
            }
            MetricsReport report = new MetricsReport(now, samples);
            LOG.trace("Reporting {} metrics", (Object)samples.size());
            String content = LogMetricsReporter.this.genContent(report.metrics());
            if (!StringUtils.isEmpty((CharSequence)content)) {
                METRICS_LOG.info(content);
            }
        }
    }

    private static class LogMetricsReporterConfig
    extends AbstractConfig {
        LogMetricsReporterConfig(ConfigDef definition, Map<?, ?> originals) {
            super(definition, originals);
        }

        public Integer getInteger(String key) {
            return (Integer)this.get(key);
        }
    }
}

