/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.record;

import com.aliyun.dts.subscribe.clients.common.UserCommitCallBack;
import com.aliyun.dts.subscribe.clients.formats.avro.Record;
import com.aliyun.dts.subscribe.clients.record.AvroRecordParser;
import com.aliyun.dts.subscribe.clients.record.OperationType;
import com.aliyun.dts.subscribe.clients.record.RecordSchema;
import com.aliyun.dts.subscribe.clients.record.RowImage;
import com.aliyun.dts.subscribe.clients.record.UserRecord;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;

public class DefaultUserRecord
implements UserRecord {
    private final TopicPartition topicPartition;
    private final long offset;
    private final Record avroRecord;
    private final UserCommitCallBack userCommitCallBack;
    private volatile boolean initHeader = false;
    private RecordSchema recordSchema;
    private RowImage beforeImage;
    private RowImage afterImage;

    public DefaultUserRecord(TopicPartition tp, long offset, Record avroRecord, UserCommitCallBack userCommitCallBack) {
        this.topicPartition = tp;
        this.offset = offset;
        this.avroRecord = avroRecord;
        this.userCommitCallBack = userCommitCallBack;
    }

    public long getOffset() {
        return this.offset;
    }

    private <R> R callAvroRecordMethod(Function<? super Record, ? extends R> method) {
        return method.apply(this.avroRecord);
    }

    public Record getAvroRecord() {
        return this.avroRecord;
    }

    public TopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    public void commit(String metadata) {
        this.userCommitCallBack.commit(this.topicPartition, this.avroRecord, this.offset, metadata);
    }

    @Override
    public long getId() {
        return this.callAvroRecordMethod(Record::getId);
    }

    @Override
    public long getSourceTimestamp() {
        return this.callAvroRecordMethod(Record::getSourceTimestamp);
    }

    @Override
    public OperationType getOperationType() {
        return this.callAvroRecordMethod(AvroRecordParser::getOperationType);
    }

    @Override
    public RecordSchema getSchema() {
        return this.callAvroRecordMethod(avroRecord -> {
            if (this.recordSchema == null) {
                this.recordSchema = AvroRecordParser.getRecordSchema(avroRecord);
            }
            return this.recordSchema;
        });
    }

    @Override
    public RowImage getBeforeImage() {
        if (null == this.beforeImage) {
            this.beforeImage = this.callAvroRecordMethod(record -> AvroRecordParser.getRowImage(this.getSchema(), record, true));
        }
        return this.beforeImage;
    }

    @Override
    public RowImage getAfterImage() {
        if (null == this.afterImage) {
            this.afterImage = this.callAvroRecordMethod(record -> AvroRecordParser.getRowImage(this.getSchema(), record, false));
        }
        return this.afterImage;
    }
}

