/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dts.subscribe.clients.record.value;

import com.aliyun.dts.subscribe.clients.common.BytesUtil;
import com.aliyun.dts.subscribe.clients.record.value.ObjectType;
import com.aliyun.dts.subscribe.clients.record.value.Value;
import com.aliyun.dts.subscribe.clients.record.value.ValueType;
import java.nio.ByteBuffer;

public class BinaryEncodingObject
implements Value<ByteBuffer> {
    private ObjectType objectType;
    private ByteBuffer binaryData;

    public BinaryEncodingObject(ObjectType objectType, ByteBuffer binaryData) {
        this.objectType = objectType;
        this.binaryData = binaryData;
    }

    @Override
    public ValueType getType() {
        return ValueType.BINARY_ENCODING_OBJECT;
    }

    @Override
    public ByteBuffer getData() {
        return this.binaryData;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public long size() {
        if (null != this.binaryData) {
            return this.binaryData.capacity();
        }
        return 0L;
    }

    @Override
    public String toString() {
        return BytesUtil.byteBufferToHexString(this.binaryData);
    }
}

