/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncTableBuilderBase;
import org.apache.hadoop.hbase.client.ClientUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.RawAsyncLayeredTableImpl;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class RawAsyncHotTableImpl
extends RawAsyncLayeredTableImpl {
    protected long hotTtl = -1L;

    RawAsyncHotTableImpl(AsyncConnectionImpl conn, AsyncTableBuilderBase<?> builder, long hotTtl) {
        super(conn, builder);
        this.hotTtl = hotTtl;
    }

    @Override
    public ResultScanner getScanner(Scan scan) {
        Scan hotScan = null;
        try {
            hotScan = ClientUtil.removeColdDataFromScan(scan, this.hotTtl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.getRawScanner(hotScan);
    }

    @Override
    public CompletableFuture<Result> get(Get get) {
        Get hotGet = null;
        try {
            hotGet = ClientUtil.removeColdDataFromGet(get, this.hotTtl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.rawGet(hotGet);
    }

    @Override
    public List<CompletableFuture<Result>> get(List<Get> gets) {
        List<Get> hotGets = null;
        try {
            hotGets = ClientUtil.removeColdDataFromGets(gets, this.hotTtl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.rawGet(hotGets);
    }
}

