/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper2;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.SetDataRequest;

@InterfaceAudience.Private
public class ZKUtil2 {
    private static final Log LOG = LogFactory.getLog(ZKUtil2.class);
    public static final char ZNODE_PATH_SEPARATOR = '/';
    private static int zkDumpConnectionTimeOut;

    public static RecoverableZooKeeper2 connect(Configuration conf, Watcher watcher) throws IOException {
        String ensemble = ZKConfig.getZKQuorumServersString((Configuration)conf);
        return ZKUtil2.connect(conf, ensemble, watcher);
    }

    public static RecoverableZooKeeper2 connect(Configuration conf, String ensemble, Watcher watcher) throws IOException {
        return ZKUtil2.connect(conf, ensemble, watcher, null);
    }

    public static RecoverableZooKeeper2 connect(Configuration conf, String ensemble, Watcher watcher, String identifier) throws IOException {
        if (ensemble == null) {
            throw new IOException("Unable to determine ZooKeeper ensemble");
        }
        int timeout = conf.getInt("zookeeper.session.timeout", 90000);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(identifier + " opening connection to ZooKeeper ensemble=" + ensemble));
        }
        int retry = conf.getInt("zookeeper.recovery.retry", 3);
        int retryIntervalMillis = conf.getInt("zookeeper.recovery.retry.intervalmill", 1000);
        zkDumpConnectionTimeOut = conf.getInt("zookeeper.dump.connection.timeout", 1000);
        return new RecoverableZooKeeper2(ensemble, timeout, watcher, retry, retryIntervalMillis, identifier);
    }

    public static void loginServer(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        ZKUtil2.login(conf, keytabFileKey, userNameKey, hostname, "zookeeper.sasl.serverconfig", "zookeeper-server-keytab-kerberos");
    }

    public static void loginClient(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        ZKUtil2.login(conf, keytabFileKey, userNameKey, hostname, "zookeeper.sasl.clientconfig", "zookeeper-client-keytab-kerberos");
    }

    private static void login(Configuration conf, String keytabFileKey, String userNameKey, String hostname, String loginContextProperty, String loginContextName) throws IOException {
        if (!ZKUtil2.isSecureZooKeeper(conf)) {
            return;
        }
        if (System.getProperty("java.security.auth.login.config") != null) {
            return;
        }
        String keytabFilename = conf.get(keytabFileKey);
        if (keytabFilename == null) {
            LOG.warn((Object)("no keytab specified for: " + keytabFileKey));
            return;
        }
        String principalConfig = conf.get(userNameKey, System.getProperty("user.name"));
        String principalName = SecurityUtil.getServerPrincipal((String)principalConfig, (String)hostname);
        JaasConfiguration jaasConf = new JaasConfiguration(loginContextName, principalName, keytabFilename);
        javax.security.auth.login.Configuration.setConfiguration(jaasConf);
        System.setProperty(loginContextProperty, loginContextName);
    }

    public static String joinZNode(String prefix, String suffix) {
        return prefix + '/' + suffix;
    }

    public static String getParent(String node) {
        int idx = node.lastIndexOf(47);
        return idx <= 0 ? null : node.substring(0, idx);
    }

    public static String getNodeName(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public static String getZooKeeperClusterKey(Configuration conf) {
        return ZKUtil2.getZooKeeperClusterKey(conf, null);
    }

    public static String getZooKeeperClusterKey(Configuration conf, String name) {
        String ensemble = conf.get("hbase.zookeeper.quorum".replaceAll("[\\t\\n\\x0B\\f\\r]", ""));
        StringBuilder builder = new StringBuilder(ensemble);
        builder.append(":");
        builder.append(conf.get("hbase.zookeeper.property.clientPort"));
        builder.append(":");
        builder.append(conf.get("zookeeper.znode.parent"));
        if (name != null && !name.isEmpty()) {
            builder.append(",");
            builder.append(name);
        }
        return builder.toString();
    }

    public static boolean watchAndCheckExists(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            boolean exists;
            Stat s = zkw.getRecoverableZooKeeper2().exists(znode, zkw);
            boolean bl = exists = s != null;
            if (exists) {
                LOG.debug((Object)zkw.prefix("Set watcher on existing znode=" + znode));
            } else {
                LOG.debug((Object)zkw.prefix("Set watcher on znode that does not yet exist, " + znode));
            }
            return exists;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static boolean setWatchIfNodeExists(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper2().getData(znode, true, null);
            return true;
        }
        catch (KeeperException.NoNodeException e) {
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static int checkExists(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            Stat s = zkw.getRecoverableZooKeeper2().exists(znode, null);
            return s != null ? s.getVersion() : -1;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode (" + znode + ")"), (Throwable)e);
            zkw.keeperException(e);
            return -1;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode (" + znode + ")"), (Throwable)e);
            zkw.interruptedException(e);
            return -1;
        }
    }

    public static List<String> listChildrenAndWatchForNewChildren(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            List<String> children = zkw.getRecoverableZooKeeper2().getChildren(znode, zkw);
            return children;
        }
        catch (KeeperException.NoNodeException ke) {
            LOG.debug((Object)zkw.prefix("Unable to list children of znode " + znode + " because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode + " "), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode + " "), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static List<String> listChildrenAndWatchThem(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        List<String> children = ZKUtil2.listChildrenAndWatchForNewChildren(zkw, znode);
        if (children == null) {
            return null;
        }
        for (String child : children) {
            ZKUtil2.watchAndCheckExists(zkw, ZKUtil2.joinZNode(znode, child));
        }
        return children;
    }

    public static List<String> listChildrenNoWatch(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        List<String> children = null;
        try {
            children = zkw.getRecoverableZooKeeper2().getChildren(znode, null);
        }
        catch (KeeperException.NoNodeException nne) {
            return null;
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
        return children;
    }

    public static boolean nodeHasChildren(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            return !zkw.getRecoverableZooKeeper2().getChildren(znode, null).isEmpty();
        }
        catch (KeeperException.NoNodeException ke) {
            LOG.debug((Object)zkw.prefix("Unable to list children of znode " + znode + " because node does not exist (not an error)"));
            return false;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static int getNumberOfChildren(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            Stat stat = zkw.getRecoverableZooKeeper2().exists(znode, null);
            return stat == null ? 0 : stat.getNumChildren();
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get children of node " + znode));
            zkw.keeperException(e);
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
        }
        return 0;
    }

    public static byte[] getData(ZooKeeperWatcher zkw, String znode) throws KeeperException, InterruptedException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper2().getData(znode, null, null);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug((Object)zkw.prefix("Unable to get data of znode " + znode + " because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
    }

    public static byte[] getDataAndWatch(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        return ZKUtil2.getDataInternal(zkw, znode, null, true);
    }

    public static byte[] getDataAndWatch(ZooKeeperWatcher zkw, String znode, Stat stat) throws KeeperException {
        return ZKUtil2.getDataInternal(zkw, znode, stat, true);
    }

    private static byte[] getDataInternal(ZooKeeperWatcher zkw, String znode, Stat stat, boolean watcherSet) throws KeeperException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper2().getData(znode, zkw, stat);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.trace((Object)zkw.prefix("Unable to get data of znode " + znode + " because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static byte[] getDataNoWatch(ZooKeeperWatcher zkw, String znode, Stat stat) throws KeeperException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper2().getData(znode, null, stat);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug((Object)zkw.prefix("Unable to get data of znode " + znode + " because node does not exist (not necessarily an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static List<NodeAndData> getChildDataAndWatchForNewChildren(ZooKeeperWatcher zkw, String baseNode) throws KeeperException {
        List<String> nodes = ZKUtil2.listChildrenAndWatchForNewChildren(zkw, baseNode);
        if (nodes != null) {
            ArrayList<NodeAndData> newNodes = new ArrayList<NodeAndData>();
            for (String node : nodes) {
                String nodePath = ZKUtil2.joinZNode(baseNode, node);
                byte[] data = ZKUtil2.getDataAndWatch(zkw, nodePath);
                newNodes.add(new NodeAndData(nodePath, data));
            }
            return newNodes;
        }
        return null;
    }

    public static void updateExistingNodeData(ZooKeeperWatcher zkw, String znode, byte[] data, int expectedVersion) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper2().setData(znode, data, expectedVersion);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static boolean setData(ZooKeeperWatcher zkw, String znode, byte[] data, int expectedVersion) throws KeeperException, KeeperException.NoNodeException {
        try {
            return zkw.getRecoverableZooKeeper2().setData(znode, data, expectedVersion) != null;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
    }

    public static void createSetData(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        if (ZKUtil2.checkExists(zkw, znode) == -1) {
            ZKUtil2.createWithParents(zkw, znode, data);
        } else {
            ZKUtil2.setData(zkw, znode, data);
        }
    }

    public static void setData(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException, KeeperException.NoNodeException {
        ZKUtil2.setData(zkw, (ZKUtil2Op.SetData)ZKUtil2Op.setData(znode, data));
    }

    private static void setData(ZooKeeperWatcher zkw, ZKUtil2Op.SetData setData) throws KeeperException, KeeperException.NoNodeException {
        SetDataRequest sd = (SetDataRequest)ZKUtil2.toZooKeeperOp(zkw, setData).toRequestRecord();
        ZKUtil2.setData(zkw, sd.getPath(), sd.getData(), sd.getVersion());
    }

    public static boolean isSecureZooKeeper(Configuration conf) {
        try {
            javax.security.auth.login.Configuration testConfig = javax.security.auth.login.Configuration.getConfiguration();
            if (testConfig.getAppConfigurationEntry("Client") == null && testConfig.getAppConfigurationEntry("zookeeper-client-keytab-kerberos") == null && testConfig.getAppConfigurationEntry("zookeeper-server-keytab-kerberos") == null && conf.get("hbase.zookeeper.client.kerberos.principal") == null && conf.get("hbase.zookeeper.server.kerberos.principal") == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return "kerberos".equalsIgnoreCase(conf.get("hbase.security.authentication"));
    }

    private static ArrayList<ACL> createACL(ZooKeeperWatcher zkw, String node) {
        return ZKUtil2.createACL(zkw, node, ZKUtil2.isSecureZooKeeper(zkw.getConfiguration()));
    }

    public static ArrayList<ACL> createACL(ZooKeeperWatcher zkw, String node, boolean isSecureZooKeeper) {
        if (!node.startsWith(zkw.baseZNode)) {
            return ZooDefs.Ids.OPEN_ACL_UNSAFE;
        }
        if (isSecureZooKeeper) {
            String superUser = zkw.getConfiguration().get("hbase.superuser");
            ArrayList<ACL> acls = new ArrayList<ACL>();
            if (superUser != null) {
                acls.add(new ACL(31, new Id("sasl", superUser)));
            }
            if (zkw.isClientReadable(node)) {
                acls.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
                acls.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
            } else {
                acls.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
            }
            return acls;
        }
        return ZooDefs.Ids.OPEN_ACL_UNSAFE;
    }

    public static boolean createEphemeralNodeAndWatch(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        boolean ret = true;
        try {
            zkw.getRecoverableZooKeeper2().create(znode, data, ZKUtil2.createACL(zkw, znode), CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NodeExistsException nee) {
            ret = false;
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!ZKUtil2.watchAndCheckExists(zkw, znode)) {
            return ZKUtil2.createEphemeralNodeAndWatch(zkw, znode, data);
        }
        return ret;
    }

    public static boolean createNodeIfNotExistsAndWatch(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        boolean ret = true;
        try {
            zkw.getRecoverableZooKeeper2().create(znode, data, ZKUtil2.createACL(zkw, znode), CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            ret = false;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
        try {
            zkw.getRecoverableZooKeeper2().exists(znode, zkw);
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
        return ret;
    }

    public static String createNodeIfNotExistsNoWatch(ZooKeeperWatcher zkw, String znode, byte[] data, CreateMode createMode) throws KeeperException {
        String createdZNode = null;
        try {
            createdZNode = zkw.getRecoverableZooKeeper2().create(znode, data, ZKUtil2.createACL(zkw, znode), createMode);
        }
        catch (KeeperException.NodeExistsException nee) {
            return znode;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return null;
        }
        return createdZNode;
    }

    public static int createAndWatch(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException, KeeperException.NodeExistsException {
        try {
            zkw.getRecoverableZooKeeper2().create(znode, data, ZKUtil2.createACL(zkw, znode), CreateMode.PERSISTENT);
            Stat stat = zkw.getRecoverableZooKeeper2().exists(znode, zkw);
            if (stat == null) {
                throw KeeperException.create((KeeperException.Code)KeeperException.Code.SYSTEMERROR, (String)("ZK.exists returned null (i.e.: znode does not exist) for znode=" + znode));
            }
            return stat.getVersion();
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return -1;
        }
    }

    public static void asyncCreate(ZooKeeperWatcher zkw, String znode, byte[] data, AsyncCallback.StringCallback cb, Object ctx) {
        zkw.getRecoverableZooKeeper2().getZooKeeper().create(znode, data, ZKUtil2.createACL(zkw, znode), CreateMode.PERSISTENT, cb, ctx);
    }

    public static void createAndFailSilent(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        ZKUtil2.createAndFailSilent(zkw, znode, new byte[0]);
    }

    public static void createAndFailSilent(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        ZKUtil2.createAndFailSilent(zkw, (ZKUtil2Op.CreateAndFailSilent)ZKUtil2Op.createAndFailSilent(znode, data));
    }

    private static void createAndFailSilent(ZooKeeperWatcher zkw, ZKUtil2Op.CreateAndFailSilent cafs) throws KeeperException {
        CreateRequest create = (CreateRequest)ZKUtil2.toZooKeeperOp(zkw, cafs).toRequestRecord();
        String znode = create.getPath();
        try {
            RecoverableZooKeeper2 zk = zkw.getRecoverableZooKeeper2();
            if (zk.exists(znode, false) == null) {
                zk.create(znode, create.getData(), create.getAcl(), CreateMode.fromFlag((int)create.getFlags()));
            }
        }
        catch (KeeperException.NodeExistsException zk) {
        }
        catch (KeeperException.NoAuthException nee) {
            try {
                if (null == zkw.getRecoverableZooKeeper2().exists(znode, false)) {
                    throw nee;
                }
            }
            catch (InterruptedException ie) {
                zkw.interruptedException(ie);
            }
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void createWithParents(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        ZKUtil2.createWithParents(zkw, znode, new byte[0]);
    }

    public static void createWithParents(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        try {
            if (znode == null) {
                return;
            }
            zkw.getRecoverableZooKeeper2().create(znode, data, ZKUtil2.createACL(zkw, znode), CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            return;
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil2.createWithParents(zkw, ZKUtil2.getParent(znode));
            ZKUtil2.createWithParents(zkw, znode, data);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void deleteNode(ZooKeeperWatcher zkw, String node) throws KeeperException {
        ZKUtil2.deleteNode(zkw, node, -1);
    }

    public static boolean deleteNode(ZooKeeperWatcher zkw, String node, int version) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper2().delete(node, version);
            return true;
        }
        catch (KeeperException.BadVersionException bve) {
            return false;
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
            return false;
        }
    }

    public static void deleteNodeFailSilent(ZooKeeperWatcher zkw, String node) throws KeeperException {
        ZKUtil2.deleteNodeFailSilent(zkw, (ZKUtil2Op.DeleteNodeFailSilent)ZKUtil2Op.deleteNodeFailSilent(node));
    }

    private static void deleteNodeFailSilent(ZooKeeperWatcher zkw, ZKUtil2Op.DeleteNodeFailSilent dnfs) throws KeeperException {
        DeleteRequest delete = (DeleteRequest)ZKUtil2.toZooKeeperOp(zkw, dnfs).toRequestRecord();
        try {
            zkw.getRecoverableZooKeeper2().delete(delete.getPath(), delete.getVersion());
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    private static List<String> listChildrenBFSNoWatch(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        String node;
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(znode);
        while ((node = (String)queue.pollFirst()) != null) {
            List<String> children = ZKUtil2.listChildrenNoWatch(zkw, node);
            if (children == null) continue;
            for (String child : children) {
                String childPath = node + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    private static List<String> listChildrenBFSAndWatchThem(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        String node;
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(znode);
        while ((node = (String)queue.pollFirst()) != null) {
            List<String> children = ZKUtil2.listChildrenAndWatchThem(zkw, node);
            if (children == null) continue;
            for (String child : children) {
                String childPath = node + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    private static Op toZooKeeperOp(ZooKeeperWatcher zkw, ZKUtil2Op op) throws UnsupportedOperationException {
        if (op == null) {
            return null;
        }
        if (op instanceof ZKUtil2Op.CreateAndFailSilent) {
            ZKUtil2Op.CreateAndFailSilent cafs = (ZKUtil2Op.CreateAndFailSilent)op;
            return Op.create((String)cafs.getPath(), (byte[])cafs.getData(), ZKUtil2.createACL(zkw, cafs.getPath()), (CreateMode)CreateMode.PERSISTENT);
        }
        if (op instanceof ZKUtil2Op.DeleteNodeFailSilent) {
            ZKUtil2Op.DeleteNodeFailSilent dnfs = (ZKUtil2Op.DeleteNodeFailSilent)op;
            return Op.delete((String)dnfs.getPath(), (int)-1);
        }
        if (op instanceof ZKUtil2Op.SetData) {
            ZKUtil2Op.SetData sd = (ZKUtil2Op.SetData)op;
            return Op.setData((String)sd.getPath(), (byte[])sd.getData(), (int)-1);
        }
        throw new UnsupportedOperationException("Unexpected ZKUtil2Op type: " + op.getClass().getName());
    }

    private static void processSequentially(ZooKeeperWatcher zkw, List<ZKUtil2Op> ops) throws KeeperException, KeeperException.NoNodeException {
        for (ZKUtil2Op op : ops) {
            if (op instanceof ZKUtil2Op.CreateAndFailSilent) {
                ZKUtil2.createAndFailSilent(zkw, (ZKUtil2Op.CreateAndFailSilent)op);
                continue;
            }
            if (op instanceof ZKUtil2Op.DeleteNodeFailSilent) {
                ZKUtil2.deleteNodeFailSilent(zkw, (ZKUtil2Op.DeleteNodeFailSilent)op);
                continue;
            }
            if (op instanceof ZKUtil2Op.SetData) {
                ZKUtil2.setData(zkw, (ZKUtil2Op.SetData)op);
                continue;
            }
            throw new UnsupportedOperationException("Unexpected ZKUtil2Op type: " + op.getClass().getName());
        }
    }

    private static void getReplicationZnodesDump(ZooKeeperWatcher zkw, StringBuilder sb) throws KeeperException {
        String replicationZNodeName = zkw.getConfiguration().get("zookeeper.znode.replication", "replication");
        String replicationZnode = ZKUtil2.joinZNode(zkw.baseZNode, replicationZNodeName);
        if (ZKUtil2.checkExists(zkw, replicationZnode) == -1) {
            return;
        }
        sb.append("\n").append(replicationZnode).append(": ");
        List<String> children = ZKUtil2.listChildrenNoWatch(zkw, replicationZnode);
        for (String child : children) {
            String znode = ZKUtil2.joinZNode(replicationZnode, child);
            if (child.equals(zkw.getConfiguration().get("zookeeper.znode.replication.peers", "peers"))) {
                ZKUtil2.appendPeersZnodes(zkw, znode, sb);
                continue;
            }
            if (!child.equals(zkw.getConfiguration().get("zookeeper.znode.replication.rs", "rs"))) continue;
            ZKUtil2.appendRSZnodes(zkw, znode, sb);
        }
    }

    private static void appendRSZnodes(ZooKeeperWatcher zkw, String znode, StringBuilder sb) throws KeeperException {
        LinkedList<String> stack = new LinkedList<String>();
        stack.add(znode);
        do {
            byte[] data;
            String znodeToProcess = (String)stack.remove(stack.size() - 1);
            sb.append("\n").append(znodeToProcess).append(": ");
            try {
                data = ZKUtil2.getData(zkw, znodeToProcess);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return;
            }
            if (data != null && data.length > 0) {
                long position = 0L;
                try {
                    position = ZKUtil2.parseWALPositionFrom(ZKUtil2.getData(zkw, znodeToProcess));
                    sb.append(position);
                }
                catch (DeserializationException deserializationException) {
                }
                catch (InterruptedException e) {
                    zkw.interruptedException(e);
                    return;
                }
            }
            for (String zNodeChild : ZKUtil2.listChildrenNoWatch(zkw, znodeToProcess)) {
                stack.add(ZKUtil2.joinZNode(znodeToProcess, zNodeChild));
            }
        } while (stack.size() > 0);
    }

    private static void appendPeersZnodes(ZooKeeperWatcher zkw, String peersZnode, StringBuilder sb) throws KeeperException {
        int pblen = ProtobufUtil.lengthOfPBMagic();
        sb.append("\n").append(peersZnode).append(": ");
        for (String peerIdZnode : ZKUtil2.listChildrenNoWatch(zkw, peersZnode)) {
            byte[] data;
            String znodeToProcess = ZKUtil2.joinZNode(peersZnode, peerIdZnode);
            try {
                data = ZKUtil2.getData(zkw, znodeToProcess);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return;
            }
            try {
                ZooKeeperProtos.ReplicationPeer.Builder builder = ZooKeeperProtos.ReplicationPeer.newBuilder();
                ProtobufUtil.mergeFrom((Message.Builder)builder, data, pblen, data.length - pblen);
                String clusterKey = builder.getClusterkey();
                sb.append("\n").append(znodeToProcess).append(": ").append(clusterKey);
                ZKUtil2.appendPeerState(zkw, znodeToProcess, sb);
            }
            catch (IOException ipbe) {
                LOG.warn((Object)("Got Exception while parsing peer: " + znodeToProcess), (Throwable)ipbe);
            }
        }
    }

    private static void appendPeerState(ZooKeeperWatcher zkw, String znodeToProcess, StringBuilder sb) throws KeeperException, InvalidProtocolBufferException {
        String peerState = zkw.getConfiguration().get("zookeeper.znode.replication.peers.state", "peer-state");
        int pblen = ProtobufUtil.lengthOfPBMagic();
        for (String child : ZKUtil2.listChildrenNoWatch(zkw, znodeToProcess)) {
            if (!child.equals(peerState)) continue;
            String peerStateZnode = ZKUtil2.joinZNode(znodeToProcess, child);
            sb.append("\n").append(peerStateZnode).append(": ");
            try {
                byte[] peerStateData = ZKUtil2.getData(zkw, peerStateZnode);
                ZooKeeperProtos.ReplicationState.Builder builder = ZooKeeperProtos.ReplicationState.newBuilder();
                ProtobufUtil.mergeFrom((Message.Builder)builder, peerStateData, pblen, peerStateData.length - pblen);
                sb.append(builder.getState().name());
            }
            catch (IOException ipbe) {
                LOG.warn((Object)("Got Exception while parsing peer: " + znodeToProcess), (Throwable)ipbe);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return;
            }
        }
    }

    public static String[] getServerStats(String server, int timeout) throws IOException {
        String line;
        String[] sp = server.split(":");
        if (sp == null || sp.length == 0) {
            return null;
        }
        String host = sp[0];
        int port = sp.length > 1 ? Integer.parseInt(sp[1]) : 2181;
        Socket socket = new Socket();
        InetSocketAddress sockAddr = new InetSocketAddress(host, port);
        socket.connect(sockAddr, timeout);
        socket.setSoTimeout(timeout);
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        out.println("stat");
        out.flush();
        ArrayList<String> res = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            res.add(line);
        }
        socket.close();
        return res.toArray(new String[res.size()]);
    }

    public static byte[] blockUntilAvailable(ZooKeeperWatcher zkw, String znode, long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (zkw == null) {
            throw new IllegalArgumentException();
        }
        if (znode == null) {
            throw new IllegalArgumentException();
        }
        byte[] data = null;
        boolean finished = false;
        long endTime = System.currentTimeMillis() + timeout;
        while (!finished) {
            try {
                data = ZKUtil2.getData(zkw, znode);
            }
            catch (KeeperException e) {
                if (e instanceof KeeperException.SessionExpiredException || e instanceof KeeperException.AuthFailedException) {
                    throw new InterruptedException("interrupted due to " + (Object)((Object)e));
                }
                LOG.warn((Object)"Unexpected exception handling blockUntilAvailable", (Throwable)e);
            }
            if (data == null && System.currentTimeMillis() + 200L < endTime) {
                Thread.sleep(200L);
                continue;
            }
            finished = true;
        }
        return data;
    }

    public static KeeperException convert(DeserializationException e) {
        KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
        ke.initCause((Throwable)e);
        return ke;
    }

    public static void logZKTree(ZooKeeperWatcher zkw, String root) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)"Current zk system:");
        String prefix = "|-";
        LOG.debug((Object)(prefix + root));
        try {
            ZKUtil2.logZKTree(zkw, root, prefix);
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void logZKTree(ZooKeeperWatcher zkw, String root, String prefix) throws KeeperException {
        List<String> children = ZKUtil2.listChildrenNoWatch(zkw, root);
        if (children == null) {
            return;
        }
        for (String child : children) {
            LOG.debug((Object)(prefix + child));
            String node = ZKUtil2.joinZNode(root.equals("/") ? "" : root, child);
            ZKUtil2.logZKTree(zkw, node, prefix + "---");
        }
    }

    public static byte[] positionToByteArray(long position) {
        byte[] bytes = ZooKeeperProtos.ReplicationHLogPosition.newBuilder().setPosition(position).build().toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }

    public static long parseWALPositionFrom(byte[] bytes) throws DeserializationException {
        if (bytes == null) {
            throw new DeserializationException("Unable to parse null WAL position.");
        }
        if (ProtobufUtil.isPBMagicPrefix(bytes)) {
            ZooKeeperProtos.ReplicationHLogPosition position;
            int pblen = ProtobufUtil.lengthOfPBMagic();
            ZooKeeperProtos.ReplicationHLogPosition.Builder builder = ZooKeeperProtos.ReplicationHLogPosition.newBuilder();
            try {
                ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen, bytes.length - pblen);
                position = builder.build();
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
            return position.getPosition();
        }
        if (bytes.length > 0) {
            return Bytes.toLong((byte[])bytes);
        }
        return 0L;
    }

    public static byte[] regionSequenceIdsToByteArray(Long regionLastFlushedSequenceId, Map<byte[], Long> storeSequenceIds) {
        ClusterStatusProtos.RegionStoreSequenceIds.Builder regionSequenceIdsBuilder = ClusterStatusProtos.RegionStoreSequenceIds.newBuilder();
        ClusterStatusProtos.StoreSequenceId.Builder storeSequenceIdBuilder = ClusterStatusProtos.StoreSequenceId.newBuilder();
        if (storeSequenceIds != null) {
            for (Map.Entry<byte[], Long> e : storeSequenceIds.entrySet()) {
                byte[] columnFamilyName = e.getKey();
                Long curSeqId = e.getValue();
                storeSequenceIdBuilder.setFamilyName(ByteStringer.wrap((byte[])columnFamilyName));
                storeSequenceIdBuilder.setSequenceId(curSeqId.longValue());
                regionSequenceIdsBuilder.addStoreSequenceId(storeSequenceIdBuilder.build());
                storeSequenceIdBuilder.clear();
            }
        }
        regionSequenceIdsBuilder.setLastFlushedSequenceId(regionLastFlushedSequenceId.longValue());
        byte[] result = regionSequenceIdsBuilder.build().toByteArray();
        return ProtobufUtil.prependPBMagic(result);
    }

    public static ClusterStatusProtos.RegionStoreSequenceIds parseRegionStoreSequenceIds(byte[] bytes) throws DeserializationException {
        if (bytes == null || !ProtobufUtil.isPBMagicPrefix(bytes)) {
            throw new DeserializationException("Unable to parse RegionStoreSequenceIds.");
        }
        ClusterStatusProtos.RegionStoreSequenceIds.Builder regionSequenceIdsBuilder = ClusterStatusProtos.RegionStoreSequenceIds.newBuilder();
        int pblen = ProtobufUtil.lengthOfPBMagic();
        ClusterStatusProtos.RegionStoreSequenceIds storeIds = null;
        try {
            ProtobufUtil.mergeFrom((Message.Builder)regionSequenceIdsBuilder, bytes, pblen, bytes.length - pblen);
            storeIds = regionSequenceIdsBuilder.build();
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
        return storeIds;
    }

    public static abstract class ZKUtil2Op {
        private String path;

        private ZKUtil2Op(String path) {
            this.path = path;
        }

        public static ZKUtil2Op createAndFailSilent(String path, byte[] data) {
            return new CreateAndFailSilent(path, data);
        }

        public static ZKUtil2Op deleteNodeFailSilent(String path) {
            return new DeleteNodeFailSilent(path);
        }

        public static ZKUtil2Op setData(String path, byte[] data) {
            return new SetData(path, data);
        }

        public String getPath() {
            return this.path;
        }

        public static class SetData
        extends ZKUtil2Op {
            private byte[] data;

            private SetData(String path, byte[] data) {
                super(path);
                this.data = data;
            }

            public byte[] getData() {
                return this.data;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof SetData)) {
                    return false;
                }
                SetData op = (SetData)o;
                return this.getPath().equals(op.getPath()) && Arrays.equals(this.data, op.data);
            }

            public int hashCode() {
                int ret = this.getPath().hashCode();
                return ret * 31 + Bytes.hashCode((byte[])this.data);
            }
        }

        public static class DeleteNodeFailSilent
        extends ZKUtil2Op {
            private DeleteNodeFailSilent(String path) {
                super(path);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof DeleteNodeFailSilent)) {
                    return false;
                }
                return super.equals(o);
            }

            public int hashCode() {
                return this.getPath().hashCode();
            }
        }

        public static class CreateAndFailSilent
        extends ZKUtil2Op {
            private byte[] data;

            private CreateAndFailSilent(String path, byte[] data) {
                super(path);
                this.data = data;
            }

            public byte[] getData() {
                return this.data;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof CreateAndFailSilent)) {
                    return false;
                }
                CreateAndFailSilent op = (CreateAndFailSilent)o;
                return this.getPath().equals(op.getPath()) && Arrays.equals(this.data, op.data);
            }

            public int hashCode() {
                int ret = 17 + this.getPath().hashCode() * 31;
                return ret * 31 + Bytes.hashCode((byte[])this.data);
            }
        }
    }

    @Deprecated
    public static class NodeAndData {
        private String node;
        private byte[] data;

        public NodeAndData(String node, byte[] data) {
            this.node = node;
            this.data = data;
        }

        public String getNode() {
            return this.node;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return this.node;
        }

        public boolean isEmpty() {
            return this.data == null || this.data.length == 0;
        }
    }

    private static class JaasConfiguration
    extends javax.security.auth.login.Configuration {
        private static final String SERVER_KEYTAB_KERBEROS_CONFIG_NAME = "zookeeper-server-keytab-kerberos";
        private static final String CLIENT_KEYTAB_KERBEROS_CONFIG_NAME = "zookeeper-client-keytab-kerberos";
        private static final Map<String, String> BASIC_JAAS_OPTIONS = new HashMap<String, String>();
        private static final Map<String, String> KEYTAB_KERBEROS_OPTIONS;
        private static final AppConfigurationEntry KEYTAB_KERBEROS_LOGIN;
        private static final AppConfigurationEntry[] KEYTAB_KERBEROS_CONF;
        private javax.security.auth.login.Configuration baseConfig;
        private final String loginContextName;
        private final boolean useTicketCache;
        private final String keytabFile;
        private final String principal;

        public JaasConfiguration(String loginContextName, String principal) {
            this(loginContextName, principal, null, true);
        }

        public JaasConfiguration(String loginContextName, String principal, String keytabFile) {
            this(loginContextName, principal, keytabFile, keytabFile == null || keytabFile.length() == 0);
        }

        private JaasConfiguration(String loginContextName, String principal, String keytabFile, boolean useTicketCache) {
            try {
                this.baseConfig = javax.security.auth.login.Configuration.getConfiguration();
            }
            catch (SecurityException e) {
                this.baseConfig = null;
            }
            this.loginContextName = loginContextName;
            this.useTicketCache = useTicketCache;
            this.keytabFile = keytabFile;
            this.principal = principal;
            LOG.info((Object)("JaasConfiguration loginContextName=" + loginContextName + " principal=" + principal + " useTicketCache=" + useTicketCache + " keytabFile=" + keytabFile));
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (this.loginContextName.equals(appName)) {
                if (!this.useTicketCache) {
                    KEYTAB_KERBEROS_OPTIONS.put("keyTab", this.keytabFile);
                    KEYTAB_KERBEROS_OPTIONS.put("useKeyTab", "true");
                }
                KEYTAB_KERBEROS_OPTIONS.put("principal", this.principal);
                KEYTAB_KERBEROS_OPTIONS.put("useTicketCache", this.useTicketCache ? "true" : "false");
                return KEYTAB_KERBEROS_CONF;
            }
            if (this.baseConfig != null) {
                return this.baseConfig.getAppConfigurationEntry(appName);
            }
            return null;
        }

        static {
            String jaasEnvVar = System.getenv("HBASE_JAAS_DEBUG");
            if (jaasEnvVar != null && "true".equalsIgnoreCase(jaasEnvVar)) {
                BASIC_JAAS_OPTIONS.put("debug", "true");
            }
            KEYTAB_KERBEROS_OPTIONS = new HashMap<String, String>();
            KEYTAB_KERBEROS_OPTIONS.put("doNotPrompt", "true");
            KEYTAB_KERBEROS_OPTIONS.put("storeKey", "true");
            KEYTAB_KERBEROS_OPTIONS.put("refreshKrb5Config", "true");
            KEYTAB_KERBEROS_OPTIONS.putAll(BASIC_JAAS_OPTIONS);
            KEYTAB_KERBEROS_LOGIN = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, KEYTAB_KERBEROS_OPTIONS);
            KEYTAB_KERBEROS_CONF = new AppConfigurationEntry[]{KEYTAB_KERBEROS_LOGIN};
        }
    }

    @VisibleForTesting
    public static class ZKClusterKey {
        public String quorumString;
        public int clientPort;
        public String znodeParent;

        ZKClusterKey(String quorumString, int clientPort, String znodeParent) {
            this.quorumString = quorumString;
            this.clientPort = clientPort;
            this.znodeParent = znodeParent;
        }
    }
}

