/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.kms.handlers;

import com.aliyun.dkms.gcs.openapi.Client;
import com.aliyun.dkms.gcs.openapi.util.models.RuntimeOptions;
import com.aliyun.kms.utils.KmsErrorCodeTransferUtils;
import com.aliyun.kms.utils.XmlUtil;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaRetryableException;
import com.aliyun.tea.TeaUnretryableException;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.utils.StringUtils;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public interface KmsTransferHandler<DReq extends TeaModel, DRep extends TeaModel> {
    public static final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).setPrettyPrinting().disableHtmlEscaping().create();
    public static final Base64 base64 = new Base64();

    public Client getClient();

    public String getAction();

    default public <T extends AcsResponse> HttpResponse handlerDKmsRequestWithOptions(AcsRequest<T> request, RuntimeOptions runtimeOptions) throws ClientException, ServerException {
        DReq dkmsRequest = this.buildDKMSRequest(request, runtimeOptions);
        try {
            return this.transferResponse(request, this.callDKMS(dkmsRequest, runtimeOptions));
        }
        catch (TeaException e) {
            throw this.transferTeaException(e);
        }
        catch (TeaUnretryableException e) {
            throw this.transferTeaUnretryableException(e, request.getSysActionName());
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.transferException(e, request.getSysActionName());
        }
    }

    public <T extends AcsResponse> DReq buildDKMSRequest(AcsRequest<T> var1, RuntimeOptions var2) throws ClientException;

    public DRep callDKMS(DReq var1, RuntimeOptions var2) throws Exception;

    public HttpResponse transferResponse(AcsRequest var1, DRep var2) throws ClientException;

    default public ClientException transferTeaException(TeaException e) {
        Map data = e.getData();
        String requestId = "";
        if (data != null) {
            requestId = String.valueOf(data.getOrDefault("requestId", ""));
        }
        switch (e.getCode()) {
            case "InvalidParam": {
                if ("The Param Date is invalid.".equals(e.getMessage())) {
                    ClientException clientException = KmsErrorCodeTransferUtils.transferInvalidDateException();
                    clientException.setRequestId(requestId);
                    return clientException;
                }
                if ("The Param Authorization is invalid.".equals(e.getMessage())) {
                    ClientException clientException = KmsErrorCodeTransferUtils.transferIncompleteSignatureException();
                    clientException.setRequestId(requestId);
                    return clientException;
                }
            }
            case "Unauthorized": {
                ClientException clientException = KmsErrorCodeTransferUtils.transferInvalidAccessKeyIdException();
                clientException.setRequestId(requestId);
                return clientException;
            }
        }
        String errorMessage = KmsErrorCodeTransferUtils.transferErrorMessage(e.getCode());
        errorMessage = StringUtils.isEmpty((CharSequence)errorMessage) ? e.getMessage() : errorMessage;
        return new ClientException(e.getCode(), errorMessage, requestId);
    }

    default public ClientException transferTeaUnretryableException(TeaUnretryableException e, String actionName) {
        if (e.getCause() != null && e.getCause() instanceof TeaRetryableException && (e.getCause().getMessage() != null && e.getCause().getMessage().contains("Read timed out") || e.getCause().getMessage() != null && e.getCause().getMessage().contains("timeout") || e.getCause().getCause() != null && e.getCause().getCause() instanceof SocketTimeoutException || e.getCause().getCause() != null && e.getCause().getCause().getCause() != null && e.getCause().getCause().getCause() instanceof SocketTimeoutException)) {
            return new ClientException("SDK.ReadTimeout", "SocketTimeoutException has occurred on a socket read or accept.The action is " + actionName, e.getCause().getCause());
        }
        return new ClientException((Throwable)e);
    }

    default public ClientException transferException(Exception e, String actionName) {
        if (e != null && e instanceof InvalidProtocolBufferException && !StringUtils.isEmpty((CharSequence)e.getMessage()) && e.getMessage().contains("Protocol message end-group tag did not match expected tag.")) {
            return new ClientException("SDK.ServerUnreachable", "Server unreachable: connection action:" + actionName + " failed", (Throwable)e);
        }
        return new ServerException("SDK.InvalidServerResponse", "Failed to parse the response. The request was succeeded, but the server returned an empty HTTP body.");
    }

    default public ClientException newMissingParameterClientException(String paramName) {
        return new ClientException("MissingParameter", String.format("The parameter  %s  needed but no provided.", paramName));
    }

    default public byte[] getHttpContent(FormatType acceptFormat, AcsResponse response) throws ClientException {
        if (FormatType.JSON.equals((Object)acceptFormat)) {
            return gson.toJson((Object)response).getBytes(StandardCharsets.UTF_8);
        }
        if (FormatType.XML.equals((Object)acceptFormat)) {
            try {
                return XmlUtil.buildRequestXml(response).getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
        throw new ClientException(String.format("Server response has a bad format type: %s;", acceptFormat));
    }
}

